/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.zzzzz.test;

import java.io.ByteArrayInputStream;
import org.eclnt.jsfserver.bufferedcontent.UploadContentParser;
import org.eclnt.util.valuemgmt.ValueManager;
import org.junit.Assert;
import org.junit.Test;

public class TestUploadMgr {
    int m_counter = 0;

    @Test
    public void testOneFile() {
        try {
            this.m_counter = 0;
            String test = "FILENAME0=harry.txt&CONTENT0=0011223344556677889900";
            byte[] bytes = test.getBytes("UTF-8");
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            UploadContentParser.parseUploadContent(bis, new UploadContentParser.IParserListener(){

                @Override
                public void reactOnFileRead(String fileName, byte[] content) {
                    System.out.println("File name: " + fileName);
                    String hex = ValueManager.encodeHexString(content);
                    System.out.println("Content  : " + hex);
                    Assert.assertEquals((Object)"0011223344556677889900", (Object)hex);
                    ++TestUploadMgr.this.m_counter;
                }
            });
            Assert.assertEquals((long)1L, (long)this.m_counter);
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)("Problem occurred: " + t.toString()));
        }
    }

    @Test
    public void testTwoFiles() {
        try {
            this.m_counter = 0;
            String test = "FILENAME0=harry.txt&CONTENT0=00112233&FILENAME1=jo.txt&CONTENT1=44556677";
            byte[] bytes = test.getBytes("UTF-8");
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            UploadContentParser.parseUploadContent(bis, new UploadContentParser.IParserListener(){

                @Override
                public void reactOnFileRead(String fileName, byte[] content) {
                    System.out.println("File name: " + fileName);
                    String hex = ValueManager.encodeHexString(content);
                    System.out.println("Content  : " + hex);
                    if (TestUploadMgr.this.m_counter == 0) {
                        Assert.assertEquals((Object)"harry.txt", (Object)fileName);
                        Assert.assertEquals((Object)"00112233", (Object)hex);
                    } else if (TestUploadMgr.this.m_counter == 1) {
                        Assert.assertEquals((Object)"jo.txt", (Object)fileName);
                        Assert.assertEquals((Object)"44556677", (Object)hex);
                    }
                    ++TestUploadMgr.this.m_counter;
                }
            });
            Assert.assertEquals((long)2L, (long)this.m_counter);
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)("Problem occurred: " + t.toString()));
        }
    }

    @Test
    public void testLongFile() {
        try {
            this.m_counter = 0;
            StringBuffer sb = new StringBuffer();
            sb.append("FILENAME0=harry.txt&CONTENT0=");
            for (int i = 0; i < 100000; ++i) {
                sb.append("00112233445566778899AABBCCDDEEFF");
            }
            byte[] bytes = sb.toString().getBytes("UTF-8");
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            UploadContentParser.parseUploadContent(bis, new UploadContentParser.IParserListener(){

                @Override
                public void reactOnFileRead(String fileName, byte[] content) {
                    System.out.println("File name: " + fileName);
                    String hex = ValueManager.encodeHexString(content);
                    System.out.println("Content  : " + hex.length());
                    Assert.assertEquals((long)3200000L, (long)hex.length());
                    ++TestUploadMgr.this.m_counter;
                }
            });
            Assert.assertEquals((long)1L, (long)this.m_counter);
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)("Problem occurred: " + t.toString()));
        }
    }
}

