/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.base.servlet;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import org.eclnt.jsfserver.base.component.UIComponentTagBuilderXML;
import org.eclnt.jsfserver.base.faces.context.FacesContext;
import org.eclnt.jsfserver.base.faces.webapp.UIComponentTag;
import org.eclnt.jsfserver.util.CCServletBase;
import org.eclnt.jsfserver.util.ICCServerConstants;
import org.eclnt.jsfserver.util.PageReader;
import org.eclnt.util.log.CLog;

public class RISCPageServlet
extends CCServletBase
implements ICCServerConstants {
    @Override
    public void init() throws ServletException {
        super.init();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.processRequest(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.processRequest(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        FacesContext context = null;
        try {
            HttpSession session = request.getSession();
            String subpageId = request.getParameter("cc_subpageId");
            String requestId = request.getHeader("eclnt-requestid");
            context = FacesContext.getCurrentInstance();
            if (context == null) {
                context = FacesContext.initCurrentInstance(session, subpageId);
                String pageName = this.findPageNameInURL(request);
                String pageXml = PageReader.readXMLForAbsolutePageName(pageName);
                pageXml = pageXml.replace("f:subview", "t:page");
                UIComponentTag sct = UIComponentTagBuilderXML.buildFromXML(context, pageXml);
                System.out.println(sct.dump());
            }
            context.startRequestProcessing(session, request, response);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Problem during request processing", t);
        }
        finally {
            if (context != null) {
                context.endRequestProcessing();
            }
        }
    }

    private String findPageNameInURL(HttpServletRequest req) {
        String uri = req.getRequestURI();
        int jsessionIdIndex = uri.indexOf(";jsessionid=");
        if (jsessionIdIndex >= 0) {
            uri = uri.substring(0, jsessionIdIndex);
        }
        int riscPageIndex = uri.indexOf("/riscpage/");
        String result = uri.substring(riscPageIndex + "/riscpage".length());
        return result;
    }
}

