/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.bc;

import java.util.ArrayList;
import java.util.List;
import org.eclnt.jsfserver.base.faces.event.ActionEvent;
import org.eclnt.jsfserver.defaultscreens.ISetId;
import org.eclnt.jsfserver.defaultscreens.IdTextSelection;
import org.eclnt.jsfserver.elements.events.BaseActionEventFlush;
import org.eclnt.jsfserver.elements.events.BaseActionEventValidate;
import org.eclnt.jsfserver.elements.events.BaseActionEventValueHelp;
import org.eclnt.jsfserver.util.valuemgmt.IDynamicContentBindingObject;

public class BCOBJECTSELECTIONBinding
implements IDynamicContentBindingObject {
    IDocking m_docking;
    ObjectInfo m_objectInfo = null;
    String m_text = null;

    public BCOBJECTSELECTIONBinding(IDocking docking) {
        this.m_docking = docking;
    }

    public void setObject(ObjectInfo oi) {
        this.m_objectInfo = oi;
        this.m_text = null;
    }

    public void setText(String value) {
        List<ObjectInfo> ois;
        this.m_text = value;
        this.m_objectInfo = null;
        if (this.m_docking != null && (ois = this.query()) != null && ois.size() == 1) {
            this.m_objectInfo = ois.get(0);
            this.m_text = null;
        }
    }

    public String getText() {
        if (this.m_objectInfo != null) {
            return this.m_objectInfo.i_text;
        }
        return this.m_text;
    }

    public String getBgpaint() {
        if (this.m_objectInfo == null && this.m_text != null) {
            return "error()";
        }
        return null;
    }

    public void onAction(ActionEvent e) {
        if (e instanceof BaseActionEventValueHelp) {
            this.openValuePopup();
        } else if (e instanceof BaseActionEventFlush) {
            BaseActionEventFlush ef = (BaseActionEventFlush)e;
            if (ef.getFlushWasTriggeredByTimer() && this.m_objectInfo == null) {
                this.openValuePopup();
            }
        } else if (e instanceof BaseActionEventValidate) {
            this.validateValue();
        }
    }

    private List<ObjectInfo> query() {
        if (this.m_docking == null) {
            return new ArrayList<ObjectInfo>();
        }
        String searchText = this.m_text;
        if (searchText == null) {
            searchText = "";
        }
        return this.m_docking.queryObjects(searchText);
    }

    private void openValuePopup() {
        if (this.m_docking == null) {
            return;
        }
        List<ObjectInfo> ois = this.query();
        if (ois == null) {
            ois = new ArrayList<ObjectInfo>();
        }
        IdTextSelection idts = IdTextSelection.createInstance();
        idts.setRenderIdColumn(false);
        for (ObjectInfo oi : ois) {
            idts.addLine(oi.i_id, oi.i_text);
        }
        idts.setCallBack(new ISetId(){

            @Override
            public void setId(String id) {
                ObjectInfo oi;
                BCOBJECTSELECTIONBinding.this.m_objectInfo = oi = BCOBJECTSELECTIONBinding.this.m_docking.getObjectInfo(id);
                BCOBJECTSELECTIONBinding.this.m_text = null;
                BCOBJECTSELECTIONBinding.this.m_docking.reactOnObjectSelection();
            }
        });
    }

    private void validateValue() {
        if (this.m_text == null) {
            return;
        }
        if (this.m_docking == null) {
            return;
        }
        List<ObjectInfo> ois = this.query();
        if (ois.size() == 1) {
            this.m_objectInfo = ois.get(0);
            this.m_docking.reactOnObjectSelection();
        } else {
            this.m_objectInfo = null;
            this.m_text = null;
        }
    }

    public static class ObjectInfo {
        String i_id;
        Object i_object;
        String i_text;

        public ObjectInfo(Object object, String id, String text) {
            this.i_id = id;
            this.i_object = object;
            this.i_text = text;
        }
    }

    public static interface IDocking {
        public List<ObjectInfo> queryObjects(String var1);

        public ObjectInfo getObjectInfo(String var1);

        public void reactOnObjectSelection();
    }

    public static class DefaultDocking
    implements IDocking {
        @Override
        public List<ObjectInfo> queryObjects(String searchText) {
            return null;
        }

        @Override
        public ObjectInfo getObjectInfo(String id) {
            return null;
        }

        @Override
        public void reactOnObjectSelection() {
        }
    }
}

