/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.bufferedcontent;

import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URLDecoder;
import org.eclnt.util.valuemgmt.ValueManager;

public class UploadContentParserBySeparateOutputStreams {
    public static void parseUploadContent(InputStream is, IParserListener listener) {
        try {
            boolean readingFILENAME = true;
            boolean readingCONTENT = false;
            InputStreamReader isr = new InputStreamReader(is, "UTF-8");
            StringBuffer currentFILENAME = new StringBuffer();
            BufferedOutputStream currentCONTENT = null;
            String processedFileName = null;
            char hex1 = '\u0000';
            char hex2 = '\u0000';
            byte[] buf = new byte[1024];
            int count = 0;
            int charactersToSkip = 0;
            while ((count = is.read(buf)) >= 0) {
                for (int iBuf = 0; iBuf < count; ++iBuf) {
                    if (charactersToSkip > 0) {
                        --charactersToSkip;
                        continue;
                    }
                    byte ic = buf[iBuf];
                    char c = (char)ic;
                    if (c != '&') {
                        if (readingFILENAME) {
                            currentFILENAME.append(c);
                            continue;
                        }
                        if (!readingCONTENT) continue;
                        if (hex1 == '\u0000') {
                            hex1 = c;
                            continue;
                        }
                        hex2 = c;
                        byte b = ValueManager.decodeHexChars(hex1, hex2);
                        currentCONTENT.write(b);
                        hex1 = '\u0000';
                        continue;
                    }
                    if (readingFILENAME) {
                        String s = currentFILENAME.toString();
                        int index = s.indexOf("=");
                        processedFileName = s.substring(index + 1);
                        try {
                            processedFileName = URLDecoder.decode(processedFileName, "UTF-8");
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        String fileIndexStr = s.substring("FILENAME".length(), index);
                        readingFILENAME = false;
                        readingCONTENT = true;
                        charactersToSkip = "CONTENT".length() + fileIndexStr.length() + 1;
                        OutputStream os = listener.reactOnFileStarted(processedFileName);
                        currentCONTENT = !(os instanceof BufferedOutputStream) ? new BufferedOutputStream(os, 1024) : (BufferedOutputStream)os;
                        currentFILENAME = new StringBuffer();
                        continue;
                    }
                    if (!readingCONTENT) continue;
                    currentCONTENT.flush();
                    currentCONTENT.close();
                    listener.reactOnFileEnded();
                    currentCONTENT = null;
                    currentFILENAME = new StringBuffer();
                    readingCONTENT = false;
                    readingFILENAME = true;
                }
            }
            if (currentCONTENT != null) {
                currentCONTENT.flush();
                currentCONTENT.close();
                listener.reactOnFileEnded();
            }
        }
        catch (Throwable t) {
            throw new Error("Problem when parsing file upload content", t);
        }
    }

    public static interface IParserListener {
        public OutputStream reactOnFileStarted(String var1);

        public void reactOnFileEnded();
    }
}

