/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.configuration;

import org.eclnt.jsfserver.managedbean.DefaultHotDeployListener;
import org.eclnt.jsfserver.managedbean.HotDeployClassLoader;
import org.eclnt.jsfserver.managedbean.HotDeployManager;
import org.eclnt.jsfserver.managedbean.HotDeployNotifier;
import org.eclnt.jsfserver.util.CCDefaultConfigurationObjectLoader;
import org.eclnt.jsfserver.util.IConfigurationObjectLoader;
import org.eclnt.jsfserver.util.SystemXml;
import org.eclnt.util.classresolver.CCClassResolver;
import org.eclnt.util.classresolver.ENUMCallerType;
import org.eclnt.util.log.CLog;

public class CCConfigurationObjectLoader {
    static final Object SYNCHER = new Object();
    static IConfigurationObjectLoader s_instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized IConfigurationObjectLoader instance() {
        if (s_instance == null) {
            Object object = SYNCHER;
            synchronized (object) {
                if (s_instance == null) {
                    s_instance = CCConfigurationObjectLoader.createInstance();
                }
            }
        }
        return s_instance;
    }

    private static IConfigurationObjectLoader createInstance() {
        try {
            String className = SystemXml.getConfigurationObjectLoaderClass();
            ClassLoader cl = HotDeployManager.currentClassLoader();
            Class c = CCClassResolver.resolveClass(className, ENUMCallerType.CONFIGURATION);
            return (IConfigurationObjectLoader)c.newInstance();
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Problem creating instance of IConfigurationObjectLoader", t);
            return new CCDefaultConfigurationObjectLoader();
        }
    }

    static {
        HotDeployNotifier.addListener(new DefaultHotDeployListener(){

            @Override
            public void onClassLoaderUpdate(ClassLoader newClassLoader) {
                if (s_instance != null && s_instance.getClass().getClassLoader() instanceof HotDeployClassLoader) {
                    s_instance = null;
                }
            }
        });
    }
}

