/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.defaultscreens;

import java.io.Serializable;
import org.eclnt.jsfserver.defaultscreens.DefaultScreens;
import org.eclnt.jsfserver.elements.phases.PhaseManager;
import org.eclnt.jsfserver.elements.util.Trigger;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.ValueManager;

public class Clipboard
implements Serializable {
    String m_contentSet = null;
    String m_dataFlavor = null;
    Trigger m_contentSetTrigger = new Trigger();

    public static void copyToClientClipboard(String text) {
        Clipboard clipboard = DefaultScreens.getSessionAccess().getClipboard();
        clipboard.copyToClientClipboardExecute(text);
    }

    public static void copyImageToClientCliboard(byte[] imageBytes) {
        Clipboard clipboard = DefaultScreens.getSessionAccess().getClipboard();
        clipboard.copyImageToClientClipboardExecute(imageBytes);
    }

    public void setContentSet(String value) {
        this.m_contentSet = value;
    }

    public String getContentSet() {
        return this.m_contentSet;
    }

    public void setDataFlavor(String value) {
        this.m_dataFlavor = value;
    }

    public String getDataFlavor() {
        return this.m_dataFlavor;
    }

    public Trigger getContentSetTrigger() {
        return this.m_contentSetTrigger;
    }

    public void copyToClientClipboardExecute(String text) {
        Clipboard clipboard = DefaultScreens.getSessionAccess().getClipboard();
        clipboard.setContentSet(text);
        clipboard.setDataFlavor(null);
        clipboard.getContentSetTrigger().trigger();
        PhaseManager.runAfterRenderResponsePhase(new Clearer());
    }

    public void copyImageToClientClipboardExecute(byte[] imageBytes) {
        Clipboard clipboard = DefaultScreens.getSessionAccess().getClipboard();
        clipboard.setContentSet(ValueManager.encodeHexString(imageBytes));
        clipboard.setDataFlavor("image");
        clipboard.getContentSetTrigger().trigger();
        PhaseManager.runAfterRenderResponsePhase(new Clearer());
    }

    public void clear() {
        this.m_contentSet = null;
        this.m_dataFlavor = null;
    }

    public void destroy() {
    }

    public class Clearer
    implements Serializable,
    Runnable {
        @Override
        public void run() {
            if (HttpSessionAccess.getCurrentComponentDump(HttpSessionAccess.getCurrentFacesContext()).isAutoTriggered()) {
                CLog.L.log(CLog.LL_INF, "Statusbar clearing is postponed - request is an automatically created one!");
                PhaseManager.runBeforeUpdatePhase(this);
            } else {
                Clipboard.this.clear();
            }
        }
    }
}

