/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.defaultscreens;

import java.io.StringReader;
import javax.xml.parsers.SAXParser;
import org.eclnt.jsfserver.base.faces.context.FacesContext;
import org.eclnt.jsfserver.defaultscreens.BasePopup;
import org.eclnt.jsfserver.defaultscreens.IPopupPersistence;
import org.eclnt.jsfserver.streamstore.IStreamStore;
import org.eclnt.jsfserver.streamstore.StreamStore;
import org.eclnt.jsfserver.util.parse.SAXParserCreator;
import org.eclnt.jsfserver.util.useraccess.UserAccessMgr;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.ValueManager;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DefaultPopupPersistence
implements IPopupPersistence {
    @Override
    public IPopupPersistence.PersistentInfo readPersistentInfo(FacesContext context, BasePopup popup, String persistId) {
        if (popup == null) {
            return null;
        }
        if (persistId == null) {
            return null;
        }
        try {
            String path = this.findPath(context, persistId);
            IStreamStore iss = StreamStore.getInstance();
            String xml = iss.readUTF8(path, true);
            SAXParser parser = SAXParserCreator.createSAXParser();
            InputSource is = new InputSource(new StringReader(xml));
            MyParser mp = new MyParser();
            parser.parse(is, (DefaultHandler)mp);
            return mp.i_pi;
        }
        catch (Throwable t) {
            return null;
        }
    }

    @Override
    public void updatePersistentInfo(FacesContext context, BasePopup popup, String persistId, IPopupPersistence.PersistentInfo persistentInfo) {
        if (persistentInfo == null) {
            return;
        }
        if (popup == null) {
            return;
        }
        if (persistId == null) {
            return;
        }
        try {
            String xml = "<windowposition left=\"" + persistentInfo.getLeft() + "\" top=\"" + persistentInfo.getTop() + "\" width=\"" + persistentInfo.getWidth() + "\" height=\"" + persistentInfo.getHeight() + "\" windowstate=\"" + persistentInfo.getWindowstate() + "\"></windowposition>";
            IStreamStore iss = StreamStore.getInstance();
            iss.writeUTF8(this.findPath(context, persistId), xml, true);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_WAR, "Problem when persisting window position");
        }
    }

    private String findPath(FacesContext context, String persistId) {
        String user = UserAccessMgr.getCurrentUser();
        persistId = persistId.replace("\\", "");
        persistId = persistId.replace("/", "");
        persistId = persistId.replace(":", "");
        persistId = persistId.replace("&", "");
        persistId = persistId.replace("?", "");
        persistId = persistId.replace("=", "");
        persistId = persistId.replace(".", "");
        return "/ccpopupposition/" + user + "/" + persistId + ".xml";
    }

    static class MyParser
    extends DefaultHandler {
        IPopupPersistence.PersistentInfo i_pi;

        MyParser() {
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if ("windowposition".equals(name)) {
                this.i_pi = new IPopupPersistence.PersistentInfo();
                this.i_pi.setLeft(ValueManager.decodeInt(attributes.getValue("left"), -1));
                this.i_pi.setTop(ValueManager.decodeInt(attributes.getValue("top"), -1));
                this.i_pi.setWidth(ValueManager.decodeInt(attributes.getValue("width"), -1));
                this.i_pi.setHeight(ValueManager.decodeInt(attributes.getValue("height"), -1));
                this.i_pi.setWindowstate(ValueManager.decodeInt(attributes.getValue("windowstate"), 0));
            }
        }
    }
}

