/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.defaultscreens;

import jakarta.servlet.http.HttpSession;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import org.eclnt.jsfserver.base.faces.event.ActionEvent;
import org.eclnt.jsfserver.defaultscreens.DefaultScreens;
import org.eclnt.jsfserver.elements.phases.PhaseManager;
import org.eclnt.jsfserver.util.ISessionAbstraction;
import org.eclnt.jsfserver.util.TypeOfSessionMgmt;
import org.eclnt.util.log.CLog;

public class ShowServerError
implements Serializable {
    Throwable m_throwable = null;
    String m_text = "No error information available. Please check the server log.";
    String m_clientErrorClass = null;
    String m_clientErrorText = null;

    public void onHideAllPopups(ActionEvent event) {
        try {
            DefaultScreens.getSessionAccess().hideAllPopups(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String getText() {
        return this.m_text;
    }

    public Throwable getThrowable() {
        return this.m_throwable;
    }

    public String getClientErrorClass() {
        return this.m_clientErrorClass;
    }

    public String getClientErrorText() {
        return this.m_clientErrorText;
    }

    public String getClientErrorInfo() {
        if (this.m_clientErrorClass == null) {
            return null;
        }
        return this.m_clientErrorClass + "\n" + this.m_clientErrorText;
    }

    public static void passThrowable(Throwable t) {
        try {
            ShowServerError sse = DefaultScreens.getSessionAccess().getShowServerError();
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            sse.m_text = sw.toString();
            PhaseManager.runAfterRenderResponsePhase(new SetBackErrorText());
        }
        catch (Throwable tt) {
            CLog.L.log(CLog.LL_INF, "ShowServerError - passing of throwable not successful: " + t.toString());
        }
    }

    @Deprecated
    public static void passClientError(HttpSession session, String clientErrorClass, String clientErrorText) {
        try {
            if (TypeOfSessionMgmt.getSessionMgmtViaCookie()) {
                CLog.L.log(CLog.LL_WAR, "Method passClientError with HttpSession is deprecated and should not be used anymore!");
                CLog.L.log(CLog.LL_WAR, "Please use method passClientError with ISessionAbstraction");
            }
            ShowServerError sse = DefaultScreens.getSessionAccess().getShowServerError();
            sse.m_clientErrorClass = clientErrorClass;
            sse.m_clientErrorText = clientErrorText;
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "ShowServerError - passing of client error (deprecated variant!) not successful: " + t.toString());
        }
    }

    public static void passClientError(ISessionAbstraction dialogSession, String clientErrorClass, String clientErrorText) {
        try {
            ShowServerError sse = DefaultScreens.getSessionAccess(dialogSession).getShowServerError();
            sse.m_clientErrorClass = clientErrorClass;
            sse.m_clientErrorText = clientErrorText;
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "ShowServerError - passing of client error not successful: " + t.toString());
        }
    }

    public static class SetBackErrorText
    implements Runnable,
    Serializable {
        @Override
        public void run() {
            try {
                ShowServerError sse = DefaultScreens.getSessionAccess().getShowServerError();
                sse.m_text = "No error information available. Please check the server log.";
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

