/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.elements;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclnt.jsfserver.base.faces.application.Application;
import org.eclnt.jsfserver.base.faces.component.ActionSource;
import org.eclnt.jsfserver.base.faces.component.UIComponent;
import org.eclnt.jsfserver.base.faces.context.FacesContext;
import org.eclnt.jsfserver.base.faces.event.ActionListener;
import org.eclnt.jsfserver.base.faces.webapp.UIComponentTag;
import org.eclnt.jsfserver.elements.BaseComponent;
import org.eclnt.jsfserver.elements.BaseComponentTagBase;
import org.eclnt.jsfserver.elements.CRN;
import org.eclnt.jsfserver.elements.ComponentRepository;
import org.eclnt.jsfserver.elements.macros.IDefaultMacro;
import org.eclnt.jsfserver.elements.macros.IMacro;
import org.eclnt.jsfserver.elements.macros.MacroFactory;
import org.eclnt.jsfserver.util.ExpressionManagerM;
import org.eclnt.jsfserver.util.ExpressionManagerV;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.SystemXml;
import org.eclnt.util.classresolver.CCClassResolver;
import org.eclnt.util.classresolver.ENUMCallerType;
import org.eclnt.util.log.CLog;
import org.eclnt.util.log.CLogConstants;
import org.eclnt.util.valuemgmt.UniqueIdCreator;
import org.eclnt.util.valuemgmt.ValueManager;

public abstract class BaseComponentTag
extends BaseComponentTagBase
implements CLogConstants {
    protected Map<String, String> m_originalAttributes = new BaseComponentTagBase.MyHashMap();
    protected String m_tagName;
    protected String m_tagPrefix;
    protected boolean m_isGridCellComponent;
    private ComponentRepository.TLDInfo m_tldInfo;
    private List<ValueManager.NameValue> m_contentReplacements;
    transient ComponentRepository mtransient_componentRepository;
    static long s_idCounter = System.currentTimeMillis();

    public BaseComponentTag() {
        if (CLog.L.isLoggable(CLog.LL_DBG)) {
            CLog.L.log(CLog.LL_DBG, "Creating BaseComponentTag: " + this.getClass().getSimpleName());
        }
        String[] info = ComponentRepository.getTagNameForComponentTagClass(this.getClass());
        this.m_tagPrefix = info[0];
        this.m_tagName = info[1];
        this.m_tldInfo = ComponentRepository.getTLDInfo(this.m_tagPrefix);
    }

    protected ComponentRepository m_componentRepository() {
        if (this.mtransient_componentRepository == null) {
            this.mtransient_componentRepository = ComponentRepository.getInstance(this.m_tagPrefix);
        }
        return this.mtransient_componentRepository;
    }

    @Override
    public void setRendered(String value) {
        this.m_attributes.put(ATT_RENDERED, value);
        this.m_attributes.put(ATT_gp_rendered, value);
    }

    public String getRendererType() {
        return null;
    }

    public String getComponentType() {
        String result = this.getClass().getName();
        result = result.substring(0, result.length() - 3);
        return result;
    }

    @Override
    public void release() {
        super.release();
        this.m_attributes = null;
    }

    private Map<String, String> getAttributeMap() {
        return this.m_attributes;
    }

    public void setAttributeInAttributeMap(String attribute, String value) {
        if ((attribute = BaseComponentTag.updateIntoUniqueAttributeName(attribute)) == ATT_ID) {
            this.setId(value);
            return;
        }
        this.m_attributes.put(attribute, value);
    }

    public static String updateIntoUniqueAttributeName(String attribute) {
        if ((attribute = CRN.a(attribute)).equals(ATT_ACTIONLISTENER)) {
            attribute = ATT_ACTIONLISTENER;
        }
        if (attribute.equals(ATT_COMPONENTBINDING)) {
            attribute = ATT_COMPONENTBINDING;
        }
        if (attribute.equals(ATT_OBJECTBINDING)) {
            attribute = ATT_OBJECTBINDING;
        }
        if (attribute.equals(ATT_RENDERED)) {
            attribute = ATT_RENDERED;
        }
        return attribute;
    }

    public String getAttributeFromAttributeMap(String attribute) {
        return (String)this.m_attributes.get(attribute);
    }

    public String getTagName() {
        return this.m_tagName;
    }

    public String getTagPrefix() {
        return this.m_tagPrefix;
    }

    public String getTagNameWithPrefix() {
        return this.m_tagPrefix + ":" + this.m_tagName;
    }

    @Override
    public int doEndTag() throws Exception {
        this.m_attributes.clear();
        return super.doEndTag();
    }

    public void defineContentReplacements(List<ValueManager.NameValue> contentReplacements) {
        this.m_contentReplacements = contentReplacements;
    }

    public boolean isGridCellComponent() {
        return this.m_isGridCellComponent;
    }

    public void setIsGridCellComponent(boolean value) {
        this.m_isGridCellComponent = value;
    }

    @Override
    public void setId(String id) {
        super.setId(id);
    }

    protected List<String> readTagAttributes() {
        List<String> result = this.m_componentRepository().getComponentInfo(this.m_tagName).getAttributes();
        return result;
    }

    protected boolean hasAction() {
        return this.m_componentRepository().getComponentInfo(this.m_tagName).hasAction();
    }

    protected boolean hasActionListener() {
        return this.m_componentRepository().getComponentInfo(this.m_tagName).hasActionListener();
    }

    public static boolean checkIfIsValueReference(String attrName, String attrValue) {
        int indexColon;
        boolean fastExpressionResolution = SystemXml.getFastExpressionResolution();
        if ((ATT_CONTENTREPLACE.equals(attrName) || ATT_CONTENTREPLACEDRILLDOWN.equals(attrName)) && (indexColon = attrValue.indexOf(58)) >= 0) {
            return false;
        }
        if (!fastExpressionResolution) {
            return BaseComponentTag.isValueReference(attrValue);
        }
        if (attrValue == null) {
            return false;
        }
        if (attrValue.length() < 2) {
            return false;
        }
        if (attrValue.charAt(0) == '#' && attrValue.charAt(1) == '{' && attrValue.charAt(attrValue.length() - 1) == '}') {
            return true;
        }
        int index1 = attrValue.indexOf("#{");
        int index2 = attrValue.indexOf("}");
        return index1 >= 0 && index2 >= index1;
    }

    private static boolean checkIfIsGridValueReferenceForActionListener(String attrName, String attrValue) {
        if (attrValue == null) {
            return false;
        }
        if (attrValue.length() < 2) {
            return false;
        }
        return attrValue.charAt(0) == '.' && attrValue.charAt(1) == '{' && attrValue.charAt(attrValue.length() - 1) == '}';
    }

    private static Object createValueExpression(Application app, String vbString) {
        return ExpressionManagerV.createExpression(app, vbString);
    }

    private static ActionListener createMethodExpression(Application app, String mbString) {
        return ExpressionManagerM.createExpression(app, mbString);
    }

    public void setProperties(UIComponent component) {
        String attrValue;
        FacesContext facesContext = HttpSessionAccess.getCurrentFacesContext();
        Application app = facesContext.getApplication();
        HashSet<String> propertiesExplicitlySet = new HashSet<String>(5);
        ArrayList<String> propertiesFix = new ArrayList<String>();
        ArrayList<String> propertiesExpression = new ArrayList<String>();
        ArrayList<String> propertiesUsed = new ArrayList<String>();
        Iterator keys = this.m_attributes.keySet().iterator();
        while (keys.hasNext()) {
            propertiesExplicitlySet.add((String)keys.next());
        }
        this.presetHardWiredProperties();
        this.executeAttributeMacro();
        this.executeDefaultAttributeMacro();
        this.presetDefaults();
        this.applyContentReplacements();
        keys = this.m_attributes.keySet().iterator();
        boolean inOutestPage = this.checkIfInOutestPage();
        HashSet<String> explicitlyNulledAttributes = null;
        StringBuffer clientAddonControlInfo = null;
        if (SystemXml.getClientAddOnDataWithControlInfo()) {
            clientAddonControlInfo = new StringBuffer();
        }
        while (keys.hasNext()) {
            String attrValue2;
            String attrName = (String)keys.next();
            if (ATT_ACTIONLISTENER.equals(attrName)) {
                if (clientAddonControlInfo == null || (attrValue2 = (String)this.m_attributes.get(attrName)) == null) continue;
                clientAddonControlInfo.append(attrName + ":" + attrValue2.replace("#", ">") + ";");
                continue;
            }
            attrValue2 = (String)this.m_attributes.get(attrName);
            if (attrValue2 == null) continue;
            if ("null!".equals(attrValue2)) {
                if (explicitlyNulledAttributes == null) {
                    explicitlyNulledAttributes = new HashSet<String>();
                }
                explicitlyNulledAttributes.add(attrName);
                continue;
            }
            if ("empty!".equals(attrValue2)) {
                attrValue2 = "";
            }
            propertiesUsed.add(attrName);
            if (BaseComponentTag.checkIfIsValueReference(attrName, attrValue2) && attrName != ATT_COMPONENTBINDING && (attrName != ATT_OBJECTBINDING || this.checkIfToSendObjectBinding()) && !attrName.equals(ATT_REFERENCE)) {
                try {
                    Object vb = BaseComponentTag.createValueExpression(app, attrValue2);
                    ExpressionManagerV.setExpressionAsComponentAttribute(component, attrName, vb);
                    propertiesExpression.add(attrName);
                    if (clientAddonControlInfo == null || !ComponentRepository.checkIfAttributeIsRelevantForClientInfo(attrName)) continue;
                    clientAddonControlInfo.append(attrName + ":" + attrValue2.replace("#", ">") + ";");
                }
                catch (Throwable t) {
                    CLog.L.log(CLog.LL_INF, "Problem occurred when creating the value binding " + attrName + "/" + attrValue2, t);
                    component.getAttributes().put(attrName, attrValue2);
                    propertiesFix.add(attrName);
                }
                continue;
            }
            if (inOutestPage) {
                attrValue2 = ValueManager.decodeFromXML(attrValue2);
            }
            propertiesFix.add(attrName);
            if (attrValue2 != null && attrValue2 instanceof String && ATT_RENDERED.equals(attrName)) {
                boolean renderedValue = ValueManager.decodeBoolean(attrValue2, true);
                component.getAttributes().put(attrName, renderedValue);
                component.setRendered(renderedValue);
                continue;
            }
            component.getAttributes().put(attrName, attrValue2);
        }
        if (clientAddonControlInfo != null && clientAddonControlInfo.length() > 0) {
            String pageInfo = (String)this.m_attributes.get(ATT_pageinfo);
            if (pageInfo != null) {
                component.getAttributes().put(ATT_pageinfo, pageInfo + "||" + clientAddonControlInfo.toString());
            } else {
                component.getAttributes().put(ATT_pageinfo, "||" + clientAddonControlInfo.toString());
            }
            if (!this.m_attributes.containsKey(ATT_pageinfo)) {
                propertiesUsed.add(ATT_pageinfo);
                propertiesFix.add(ATT_pageinfo);
            }
        }
        if (component instanceof BaseComponent) {
            propertiesUsed.trimToSize();
            propertiesFix.trimToSize();
            propertiesExpression.trimToSize();
            ((BaseComponent)component).passPropertyUsage(propertiesExplicitlySet, propertiesUsed, propertiesFix, propertiesExpression, this.m_originalAttributes, explicitlyNulledAttributes);
        }
        if (this.hasActionListener() && (attrValue = (String)this.m_attributes.get(ATT_ACTIONLISTENER)) != null) {
            if (BaseComponentTag.checkIfIsValueReference(ATT_ACTIONLISTENER, attrValue)) {
                ActionListener mb = BaseComponentTag.createMethodExpression(app, attrValue);
                ((ActionSource)((Object)component)).addActionListener(mb);
            } else if (BaseComponentTag.checkIfIsGridValueReferenceForActionListener(ATT_ACTIONLISTENER, attrValue)) {
                component.getAttributes().put(ATT_gp_actionListener, attrValue);
            }
        }
        if (this.m_attributes.get(ATT_RENDERED) == null) {
            component.setRendered(true);
        }
        if (component instanceof BaseComponent) {
            ((BaseComponent)component).reactOnSetPropertiesByTagFinished();
        }
        this.m_attributes.clear();
    }

    protected boolean checkIfToSendObjectBinding() {
        return false;
    }

    public BaseComponent createBaseComponent() {
        try {
            BaseComponent result;
            if (this.getId() == null) {
                this.setId(this.createUniqueId());
            }
            String baseComponentClassName = this.getClass().getName();
            baseComponentClassName = baseComponentClassName.substring(0, baseComponentClassName.length() - 3);
            if (HttpSessionAccess.getCurrentFacesContext() != null && this.m_tldInfo.isTypeJSFControlLibary()) {
                Application application = HttpSessionAccess.getCurrentFacesContext().getApplication();
                result = (BaseComponent)application.createComponent(baseComponentClassName);
            } else {
                Class baseComponentClass = CCClassResolver.resolveClass(baseComponentClassName, ENUMCallerType.COMPONENT);
                result = (BaseComponent)baseComponentClass.newInstance();
            }
            result.setId(this.getId());
            this.setProperties(result);
            return result;
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "", t);
            throw new Error(t);
        }
    }

    public String createUniqueId() {
        return this.createSubId();
    }

    public void invokeSetter(String property, String value) {
        if (!"rendered".equals(property)) {
            property = CRN.a(property);
            this.m_attributes.put(property, value);
            return;
        }
        try {
            String methodName = "set" + ValueManager.toUpperCaseId(property.substring(0, 1)) + property.substring(1);
            Method m = this.getClass().getMethod(methodName, String.class);
            m.invoke((Object)this, value);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Could not set attribute in component tag: " + property, t);
        }
    }

    private String createSubId() {
        return "S" + UniqueIdCreator.createCounter() + "-" + this.getId();
    }

    protected void presetHardWiredProperties() {
    }

    protected void presetPropertyIfNull(String name, String value) {
        if (this.m_attributes.get(name) == null) {
            this.m_attributes.put(name, value);
        }
    }

    protected void executeDefaultAttributeMacro() {
        Set<IDefaultMacro> defaultMacros = MacroFactory.getWebappInstance().getDefaultMacros();
        for (IDefaultMacro defaultMacro : defaultMacros) {
            String tag = this.m_tagPrefix + ":" + this.m_tagName;
            try {
                if (!defaultMacro.checkIfApplicable(tag)) continue;
                defaultMacro.executeMacro(this, new String[0]);
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_ERR, "Error when executing default macro: " + defaultMacro.getClass().getName() + ", tag: " + tag, t);
            }
        }
    }

    protected void executeAttributeMacro() {
        String attributemacro = (String)this.m_attributes.get("attributemacro");
        if (attributemacro == null) {
            return;
        }
        try {
            String macroName = ValueManager.decodeMethodName(attributemacro);
            String[] macroParams = ValueManager.decodeMethodParams(attributemacro);
            IMacro macro = MacroFactory.getWebappInstance().getMacro(macroName);
            macro.executeMacro(this, macroParams);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Error when executing macro: " + attributemacro, t);
        }
    }

    private void applyContentReplacements() {
        if (this.m_contentReplacements == null || this.m_contentReplacements.size() == 0) {
            return;
        }
        for (String key : this.m_attributes.keySet()) {
            String value;
            if (ATT_gridcontentreplace.equals(key) || (value = (String)this.m_attributes.get(key)) == null) continue;
            String orignialValue = value;
            ReplacementResult rr = BaseComponentTag.executeReplacement(value, this.m_contentReplacements);
            value = rr.value;
            boolean replacementExecuted = rr.replacementExecuted;
            if (!replacementExecuted) continue;
            this.m_attributes.put(key, value);
            if (value.equals(orignialValue)) continue;
            this.m_originalAttributes.put(key, orignialValue);
        }
    }

    public static ReplacementResult junit_executeReplacement(String v, List<ValueManager.NameValue> contentReplacements) {
        return BaseComponentTag.executeReplacement(v, contentReplacements);
    }

    public static ReplacementResult executeReplacement(String v, List<ValueManager.NameValue> contentReplacements) {
        ReplacementResult result = new ReplacementResult();
        result.replacementExecuted = false;
        result.value = v;
        for (ValueManager.NameValue nameValue : contentReplacements) {
            String from = nameValue.name;
            String to = nameValue.value;
            if (from == null || to == null) continue;
            boolean toIsExpression = to.startsWith("#{");
            boolean valueIsExpression = result.value.startsWith("#{");
            if (toIsExpression && valueIsExpression && result.value.startsWith(from) && result.value.startsWith(to)) continue;
            result.value = result.value.replace(from, to);
            result.replacementExecuted = true;
            if (!toIsExpression || !valueIsExpression || !to.endsWith(".") || !from.endsWith(".")) continue;
            String from2 = from.substring(0, from.length() - 1) + "}";
            String to2 = to.substring(0, to.length() - 1) + "}";
            result.value = result.value.replace(from2, to2);
        }
        return result;
    }

    protected void presetDefaults() {
    }

    private boolean checkIfInOutestPage() {
        UIComponentTag parent = this.getParent();
        boolean result = true;
        while (true) {
            if (parent == null) {
                result = false;
                break;
            }
            if (!(parent instanceof BaseComponentTag)) break;
            parent = ((BaseComponentTag)parent).getParent();
        }
        return result;
    }

    public static class ReplacementResult {
        public boolean replacementExecuted = false;
        public String value;
    }
}

