/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.elements;

import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.MethodExpression;
import jakarta.el.MethodInfo;
import jakarta.el.MethodNotFoundException;
import jakarta.el.PropertyNotFoundException;
import java.util.ArrayList;
import java.util.List;
import org.eclnt.jsfserver.base.faces.context.FacesContext;
import org.eclnt.jsfserver.base.faces.event.AbortProcessingException;
import org.eclnt.jsfserver.base.faces.event.ActionEvent;
import org.eclnt.jsfserver.base.faces.event.ActionListener;
import org.eclnt.jsfserver.defaultscreens.ShowServerError;
import org.eclnt.jsfserver.elements.ApplicationErrorInfo;
import org.eclnt.jsfserver.elements.BaseActionEvent;
import org.eclnt.jsfserver.elements.ThreadData;
import org.eclnt.jsfserver.util.ClientTestLog;
import org.eclnt.jsfserver.util.ExpressionManagerV;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.IMethodBindingListener;
import org.eclnt.jsfserver.util.StackedMethodExpression;
import org.eclnt.jsfserver.util.StackedValueExpression;
import org.eclnt.util.log.CLog;
import org.eclnt.util.logdt.DTLogFactory;
import org.eclnt.util.logdt.ENUMLogCategory;

public class MethodExpressionDelegator
extends MethodExpression
implements ActionListener {
    MethodExpression m_delegateTo;

    public MethodExpressionDelegator(MethodExpression delegateTo) {
        this.m_delegateTo = delegateTo;
    }

    public boolean equals(Object arg0) {
        return this.m_delegateTo.equals(arg0);
    }

    public String getExpressionString() {
        return this.m_delegateTo.getExpressionString();
    }

    public MethodInfo getMethodInfo(ELContext arg0) throws NullPointerException, PropertyNotFoundException, MethodNotFoundException, ELException {
        return this.m_delegateTo.getMethodInfo(arg0);
    }

    public int hashCode() {
        return this.m_delegateTo.hashCode();
    }

    public Object invoke(ELContext elContext, Object[] args) throws NullPointerException, PropertyNotFoundException, MethodNotFoundException, ELException {
        FacesContext facesContext = HttpSessionAccess.getCurrentFacesContext();
        try {
            StackedValueExpression vb;
            Object o;
            Object result = null;
            boolean invoke = true;
            IMethodBindingListener mbl = HttpSessionAccess.getMethodBindingListener();
            if (mbl != null && args.length >= 1 && args[0] instanceof ActionEvent) {
                CLog.L.log(CLog.LL_INF, "Calling central methodBindingListener (pre) - " + mbl.getClass());
                invoke = mbl.reactOnActionListenerInvokeBefore(this.getExpressionString(), (ActionEvent)args[0]);
                if (!invoke) {
                    CLog.L.log(CLog.LL_INF, "Method binding listener intterrups normal actionListener processing!");
                    invoke = false;
                }
            }
            List<String> baseExpressions = this.getBaseExpressions(this.getExpressionString());
            Object currentObjectMbl = null;
            if (baseExpressions.size() >= 1 && args.length >= 1 && args[0] instanceof ActionEvent && (o = (vb = new StackedValueExpression(facesContext.getApplication(), baseExpressions.get(0) + "}")).getValue(elContext)) != null && o instanceof IMethodBindingListener) {
                currentObjectMbl = (IMethodBindingListener)o;
            }
            if (currentObjectMbl != null) {
                CLog.L.log(CLog.LL_INF, "Calling methodBindingListener (pre) - " + currentObjectMbl.getClass());
                boolean mblResult = currentObjectMbl.reactOnActionListenerInvokeBefore(this.getExpressionString(), (ActionEvent)args[0]);
                if (!mblResult) {
                    CLog.L.log(CLog.LL_INF, "Method binding listener intterrups normal actionListener processing!");
                    invoke = false;
                }
            }
            if (invoke) {
                if (CLog.L.isLoggable(CLog.LL_INF)) {
                    CLog.L.log(CLog.LL_INF, "Invoking method: " + this.m_delegateTo.getExpressionString());
                }
                ThreadData threadData = ThreadData.getInstance();
                boolean profileMode = threadData.getProfileMode();
                long nanos1 = System.nanoTime();
                result = this.m_delegateTo.invoke(elContext, args);
                if (profileMode) {
                    long nanos2 = System.nanoTime();
                    String comment = this.m_delegateTo.getExpressionString();
                    threadData.addConsumedNanosInvoke(comment, nanos2 - nanos1);
                }
            }
            if (currentObjectMbl != null) {
                CLog.L.log(CLog.LL_INF, "Calling methodBindingListener (pre) - " + currentObjectMbl.getClass());
                currentObjectMbl.reactOnActionListenerInvokeAfter(this.getExpressionString(), (ActionEvent)args[0]);
            }
            if (mbl != null && args.length >= 1 && args[0] instanceof ActionEvent) {
                CLog.L.log(CLog.LL_INF, "Calling central methodBindingListener (post) - " + mbl.getClass());
                mbl.reactOnActionListenerInvokeAfter(this.getExpressionString(), (ActionEvent)args[0]);
            }
            if (ClientTestLog.checkIfClientTestLogIsActive()) {
                try {
                    for (int i = 0; i < baseExpressions.size(); ++i) {
                        String methodName = baseExpressions.get(i) + ".onCreateClientTestLogMessage}";
                        CLog.L.log(CLog.LL_INF, "Calling " + methodName);
                        try {
                            StackedMethodExpression mb = new StackedMethodExpression(facesContext.getApplication(), methodName);
                            boolean continueTesting = (Boolean)mb.invoke(elContext, new Object[0]);
                            if (continueTesting) continue;
                            break;
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
                catch (Throwable t) {
                    CLog.L.log(CLog.LL_WAR, "Error occurred when calling application's test log output");
                }
            }
            return result;
        }
        catch (Throwable t) {
            if (t instanceof MethodNotFoundException) {
                CLog.L.log(CLog.LL_WAR, "Method not available: " + this.m_delegateTo.getExpressionString());
                CLog.L.log(CLog.LL_WAR, "Application will be continued without executing any method");
                DTLogFactory.getLog().log(ENUMLogCategory.METHODERROR_IMPL, this.m_delegateTo.getExpressionString(), null, t);
                return null;
            }
            CLog.L.log(CLog.LL_INF, "Error happened when invoking action listener", t);
            String methodName = this.getExpressionString();
            int index = methodName.lastIndexOf(46);
            if (index < 0) {
                throw new Error(t);
            }
            List<String> baseExpressions = this.getBaseExpressions(methodName);
            for (int i = 0; i < baseExpressions.size(); ++i) {
                methodName = baseExpressions.get(i) + ".onApplicationError}";
                CLog.L.log(CLog.LL_INF, "Try to delegate to method " + methodName);
                try {
                    StackedMethodExpression mb = new StackedMethodExpression(facesContext.getApplication(), methodName);
                    ApplicationErrorInfo aei = new ApplicationErrorInfo();
                    aei.m_exception = t;
                    aei.m_methodExpression = this.getExpressionString();
                    if (args.length == 1 && args[0] instanceof BaseActionEvent) {
                        aei.m_bae = (BaseActionEvent)args[0];
                    }
                    mb.invoke(elContext, new Object[]{aei}, true);
                    CLog.L.log(CLog.LL_INF, "Result of processing delegation: OK!");
                    return null;
                }
                catch (Throwable t2) {
                    CLog.L.log(CLog.LL_INF, "Result of processing delegation: " + t2.toString());
                    continue;
                }
            }
            ShowServerError.passThrowable(t);
            throw new Error(t);
        }
    }

    public boolean isLiteralText() {
        return this.m_delegateTo.isLiteralText();
    }

    @Override
    public void processAction(ActionEvent event) throws AbortProcessingException {
        this.invoke(HttpSessionAccess.getCurrentFacesContext().getELContext(), new Object[]{event});
    }

    public String toString() {
        return this.m_delegateTo.getExpressionString();
    }

    private List<String> getBaseExpressions(String expression) {
        ArrayList<String> result = new ArrayList<String>();
        String[] tokens = ExpressionManagerV.buildTokens(expression);
        if (tokens.length > 1) {
            StringBuffer sb = new StringBuffer();
            sb.append("#{");
            for (int i = 0; i < tokens.length - 1; ++i) {
                if (i != 0) {
                    sb.append(".");
                }
                sb.append(tokens[i]);
                result.add(0, sb.toString());
            }
        }
        return result;
    }
}

