/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.elements.adapter;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclnt.jsfserver.elements.adapter.ComponentAdapterByAnnotation;
import org.eclnt.jsfserver.elements.adapter.IBeanAccess;
import org.eclnt.jsfserver.util.BeanIntrospector;
import org.eclnt.util.log.CLog;

public class ComponentAdapterByAnnotationForBeanProperty<BEANCLASS>
extends ComponentAdapterByAnnotation {
    private static final String PROPERTY_DELIMITER = "$";
    BEANCLASS m_bean;
    IBeanAccess<BEANCLASS> m_beanAccess;
    String m_property;
    List<String> m_propertyTokens;
    Class mbuffererd_propertyType;
    String m_componentAttribute;
    Set<String> m_dynAttributes = null;

    public ComponentAdapterByAnnotationForBeanProperty(String componentAttribute, BEANCLASS bean, String property) {
        this.m_bean = bean;
        this.m_property = property;
        this.m_propertyTokens = this.tokenizePropertyName(this.m_property);
        this.m_componentAttribute = componentAttribute;
    }

    public ComponentAdapterByAnnotationForBeanProperty(String componentAttribute, IBeanAccess<BEANCLASS> beanAccess, String property) {
        this.m_beanAccess = beanAccess;
        this.m_property = property;
        this.m_propertyTokens = this.tokenizePropertyName(this.m_property);
        this.m_componentAttribute = componentAttribute;
    }

    public ComponentAdapterByAnnotationForBeanProperty(BEANCLASS bean, String property) {
        this.m_bean = bean;
        this.m_property = property;
        this.m_propertyTokens = this.tokenizePropertyName(this.m_property);
    }

    public ComponentAdapterByAnnotationForBeanProperty(IBeanAccess<BEANCLASS> beanAccess, String property) {
        this.m_beanAccess = beanAccess;
        this.m_property = property;
        this.m_propertyTokens = this.tokenizePropertyName(this.m_property);
    }

    public void initComponentAttribute(String attributeName) {
        this.m_componentAttribute = attributeName;
    }

    @Override
    public Set<String> getDynamicAttributeNames() {
        if (this.m_dynAttributes == null) {
            if (this.m_componentAttribute == null) {
                throw new Error("Component attribute not defined: adapter for property: " + this.m_property);
            }
            this.m_dynAttributes = new HashSet<String>();
            this.m_dynAttributes.addAll(super.getDynamicAttributeNames());
            this.m_dynAttributes.add(this.m_componentAttribute);
        }
        return this.m_dynAttributes;
    }

    @Override
    public void setAttributeValue(String attributeName, Object value) {
        if (attributeName.equals(this.m_componentAttribute)) {
            this.setPropertyValue(value);
        } else {
            super.setAttributeValue(attributeName, value);
        }
    }

    @Override
    public Class getAttibuteType(String attributeName) {
        if (attributeName.equals(this.m_componentAttribute)) {
            return this.getPropertyType();
        }
        return super.getAttibuteType(attributeName);
    }

    @Override
    public Object getAttributeValue(String attributeName) {
        if (attributeName.equals(this.m_componentAttribute)) {
            return this.getPropertyValue();
        }
        return super.getAttributeValue(attributeName);
    }

    public Class getPropertyType() {
        if (this.mbuffererd_propertyType != null) {
            return this.mbuffererd_propertyType;
        }
        try {
            Class<?> beanClass = this.getBean().getClass();
            for (int i = 0; i < this.m_propertyTokens.size(); ++i) {
                BeanIntrospector.PropertyIntrospectionInfo pii = BeanIntrospector.readProperty(beanClass, this.m_propertyTokens.get(i));
                if (pii == null) {
                    throw new Exception("Property does not exist: " + beanClass.getName() + ": " + this.m_propertyTokens.get(i));
                }
                beanClass = pii.getGetter().getReturnType();
            }
            this.mbuffererd_propertyType = beanClass;
            return this.mbuffererd_propertyType;
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problem getting property type: " + this.m_property + ", " + t.toString());
            return String.class;
        }
    }

    public Object getPropertyValue() {
        try {
            Object result = this.getBean();
            for (String token : this.m_propertyTokens) {
                result = this.readPropertyFromObject(result, token);
            }
            return result;
        }
        catch (Throwable t) {
            throw new Error("Problem getting property value: " + this.m_property, t);
        }
    }

    public void setPropertyValue(Object value) {
        try {
            Object bean = this.getBean();
            for (int i = 0; i < this.m_propertyTokens.size() - 1; ++i) {
                bean = this.readPropertyFromObject(bean, this.m_propertyTokens.get(i));
            }
            BeanIntrospector.PropertyIntrospectionInfo pii = null;
            String lastToken = this.m_propertyTokens.get(this.m_propertyTokens.size() - 1);
            if (bean == null) {
                throw new Error("Cannot set property value: bean to set is null: " + this.m_property);
            }
            pii = BeanIntrospector.readProperty(bean.getClass(), lastToken);
            pii.getSetter().invoke(bean, value);
        }
        catch (Throwable t) {
            throw new Error("Problem setting property value: " + this.m_property, t);
        }
    }

    public BEANCLASS getBean() {
        BEANCLASS result = null;
        if (this.m_bean != null) {
            result = this.m_bean;
        } else if (this.m_beanAccess != null) {
            result = this.m_beanAccess.getBean();
        }
        if (result == null) {
            throw new Error("Bean not available: neither as direct bean nor as IBeanAccess.");
        }
        return result;
    }

    public String getProperty() {
        return this.m_property;
    }

    private List<String> tokenizePropertyName(String propertyName) {
        StringTokenizer t = new StringTokenizer(propertyName, PROPERTY_DELIMITER);
        ArrayList<String> result = new ArrayList<String>();
        while (t.hasMoreTokens()) {
            result.add(t.nextToken());
        }
        return result;
    }

    private Object readPropertyFromObject(Object o, String propertyName) {
        if (o == null) {
            return null;
        }
        try {
            BeanIntrospector.PropertyIntrospectionInfo pii = null;
            pii = BeanIntrospector.readProperty(o.getClass(), propertyName);
            return pii.getGetter().invoke(o, new Object[0]);
        }
        catch (Throwable t) {
            throw new Error("Problem getting property value: " + this.m_property, t);
        }
    }
}

