/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.elements.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.eclnt.jsfserver.base.faces.component.UIComponent;
import org.eclnt.jsfserver.base.faces.context.FacesContext;
import org.eclnt.jsfserver.base.faces.event.ActionEvent;
import org.eclnt.jsfserver.defaultscreens.ModelessPopup;
import org.eclnt.jsfserver.elements.ApplicationErrorInfo;
import org.eclnt.jsfserver.elements.BaseComponent;
import org.eclnt.jsfserver.elements.ThreadData;
import org.eclnt.jsfserver.elements.impl.FIXGRIDBinding;
import org.eclnt.jsfserver.elements.impl.FIXGRIDComponent;
import org.eclnt.jsfserver.elements.impl.GRIDCOLComponent;
import org.eclnt.jsfserver.elements.impl.IFIXGRIDItem;
import org.eclnt.jsfserver.elements.impl.LABELComponentTag;
import org.eclnt.jsfserver.elements.impl.PANEComponentTag;
import org.eclnt.jsfserver.elements.impl.ROWComponent;
import org.eclnt.jsfserver.elements.impl.ROWComponentTag;
import org.eclnt.jsfserver.elements.phases.PhaseManager;
import org.eclnt.jsfserver.elements.util.Trigger;
import org.eclnt.jsfserver.util.ExpressionManagerV;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.util.log.CLog;

public class FIXGRIDComponentDetailUtil
implements Serializable,
ModelessPopup.IModelessPopupListener {
    static int s_defaultPopupWidth = 300;
    static int s_defaultPopupHeight = 350;
    FIXGRIDComponent m_fixgridComponent;
    ROWComponent m_lastRow;
    ModelessPopup m_popup;
    ClosePopupRunner m_closePopupRunner = new ClosePopupRunner();
    Trigger m_animationTrigger = new Trigger();
    String m_animationType = null;
    boolean m_showAllColumns = false;
    int m_popupWidth = s_defaultPopupWidth;
    int m_popupHeight = s_defaultPopupHeight;

    public FIXGRIDComponentDetailUtil(FIXGRIDComponent fixgridComponent) {
        this.m_fixgridComponent = fixgridComponent;
    }

    public void setShowAllColumns(boolean value) {
        if (this.m_showAllColumns == value) {
            return;
        }
        this.m_lastRow = null;
        this.m_showAllColumns = value;
    }

    public static void setDefaultPopupWidth(int defaultPopupWidth) {
        s_defaultPopupWidth = defaultPopupWidth;
    }

    public static int getDefaultPopupWidth() {
        return s_defaultPopupWidth;
    }

    public static void setDefaultPopupHeight(int defaultPopupHeight) {
        s_defaultPopupHeight = defaultPopupHeight;
    }

    public static int getDefaultPopupHeight() {
        return s_defaultPopupHeight;
    }

    public void setPopupWidth(int popupWidth) {
        this.m_popupWidth = popupWidth;
    }

    public int getPopupWidth() {
        return this.m_popupWidth;
    }

    public void setPopupHeight(int popupHeight) {
        this.m_popupHeight = popupHeight;
    }

    public int getPopupHeight() {
        return this.m_popupHeight;
    }

    public void onOpenRowDataPopup(ActionEvent event) {
        this.openPopup(false);
    }

    public void onOpenRowDataPopupAllColumns(ActionEvent event) {
        this.openPopup(true);
    }

    public ModelessPopup openPopup(boolean showAllColumns) {
        try {
            this.setShowAllColumns(showAllColumns);
            if (this.m_popup != null) {
                return null;
            }
            PhaseManager.runAfterInvokePhase(this.m_closePopupRunner);
            FIXGRIDBinding fb = this.getFIXGRIDBinding();
            if (fb.getRows().size() == 0) {
                return null;
            }
            if (fb.getSelectedItem() == null) {
                fb.selectItem((IFIXGRIDItem)fb.getRows().get(0));
            }
            this.m_popup = ModelessPopup.createInstance();
            this.m_popup.open("/eclntjsfserver/popups/gridrowdata.jsp", "Grid Row Data", this.m_popupWidth, this.m_popupHeight, this);
            this.m_popup.setContentReplace("GRIDBINDING:" + this.m_fixgridComponent.getObjectBindingString());
            this.m_popup.setUndecorated(true);
            this.m_popup.setCloseonclickoutside(true);
            this.m_popup.setLeft(100);
            this.m_popup.setTop(50);
            this.m_popup.setLefTopReferenceComponentId(this.m_fixgridComponent.getId());
            this.m_popup.setStartfromrootwindow(false);
            this.m_popup.setSizeableIfUndecorated(true);
            return this.m_popup;
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Problems opening the row-data-popup", t);
            return null;
        }
    }

    public void setRow(ROWComponent row) {
        if (this.m_lastRow == row) {
            return;
        }
        this.createDetailUI(row);
    }

    public void createDetailUI(ROWComponent row) {
        row.clearAndDestroyChildren();
        StringBuffer sb = new StringBuffer();
        List<FIXGRIDComponent.ColumnInfo> columnInfos = this.m_showAllColumns ? this.m_fixgridComponent.getColumns() : this.m_fixgridComponent.getColumns(this.getFIXGRIDBinding().getColumnsequence());
        String expressionPrefix = this.m_fixgridComponent.getObjectBindingString() + ".selectedItem";
        PANEComponentTag pct = new PANEComponentTag();
        pct.setRowdistance("5");
        pct.setWidth("100%");
        BaseComponent pc = pct.createBaseComponent();
        if (row.getChildren().add(pc)) {
            // empty if block
        }
        HashMap<String, String> overrideAttributes = new HashMap<String, String>();
        overrideAttributes.put("width", "100%");
        for (int i = 0; i < columnInfos.size(); ++i) {
            FIXGRIDComponent.ColumnInfo columnInfo = columnInfos.get(i);
            GRIDCOLComponent gridCol = columnInfo.getGridcolComponent();
            BaseComponent gridControl = (BaseComponent)columnInfo.getGridcontrolComponent();
            if (gridCol == null || gridControl == null || gridControl.getAttributeString("actionListener") != null && gridControl.getAttributeString("actionListener").endsWith("onOpenRowDataPopup}")) continue;
            ROWComponentTag rct = new ROWComponentTag();
            BaseComponent rc = rct.createBaseComponent();
            pc.getChildren().add(rc);
            LABELComponentTag lct = new LABELComponentTag();
            lct.setText(gridCol.getAttributeValueAsString("text"));
            lct.setWidth("100");
            BaseComponent lc = lct.createBaseComponent();
            rc.getChildren().add(lc);
            UIComponent uic = this.m_fixgridComponent.createControlInstance(gridControl, expressionPrefix, "_detail", overrideAttributes);
            rc.getChildren().add(uic);
        }
    }

    @Override
    public void reactOnPopupClosedByUser() {
        this.m_popup.close();
        this.m_popup = null;
    }

    public Trigger getAnimationTrigger() {
        return this.m_animationTrigger;
    }

    public String getAnimationType() {
        return this.m_animationType;
    }

    public void onSelectLineUp(ActionEvent event) {
        Object sel1 = this.getFIXGRIDBinding().getSelectedItem();
        this.getFIXGRIDBinding().getScrollHelper().onSelectLineUp(event);
        Object sel2 = this.getFIXGRIDBinding().getSelectedItem();
        if (sel1 != sel2) {
            this.m_animationType = "foglight";
            this.m_animationTrigger.trigger();
        }
    }

    public void onSelectLineDown(ActionEvent event) {
        Object sel1 = this.getFIXGRIDBinding().getSelectedItem();
        this.getFIXGRIDBinding().getScrollHelper().onSelectLineDown(event);
        Object sel2 = this.getFIXGRIDBinding().getSelectedItem();
        if (sel1 != sel2) {
            this.m_animationType = "foglight";
            this.m_animationTrigger.trigger();
        }
    }

    public void onApplicationError(ApplicationErrorInfo aei) {
        CLog.L.log(CLog.LL_ERR, "Error occurred in row detail processing", aei.getException());
    }

    private FIXGRIDBinding getFIXGRIDBinding() {
        try {
            FacesContext fc = HttpSessionAccess.getCurrentFacesContext();
            String expression = "#{" + this.m_fixgridComponent.getObjectBindingString() + "}";
            return (FIXGRIDBinding)ExpressionManagerV.getValueForExpressionString(fc, expression);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public class ClosePopupRunner
    implements Runnable {
        @Override
        public void run() {
            try {
                FIXGRIDBinding fgb;
                if (FIXGRIDComponentDetailUtil.this.m_popup != null && (fgb = FIXGRIDComponentDetailUtil.this.getFIXGRIDBinding()).getSelectedItem() == null) {
                    FIXGRIDComponentDetailUtil.this.m_popup.close();
                    FIXGRIDComponentDetailUtil.this.m_popup = null;
                    return;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (FIXGRIDComponentDetailUtil.this.m_popup != null) {
                ThreadData.getInstance().registerChangeUpdatingAllAreas();
                PhaseManager.runAfterInvokePhase(FIXGRIDComponentDetailUtil.this.m_closePopupRunner);
            }
        }
    }
}

