/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.elements.impl;

import java.io.IOException;
import java.util.List;
import org.eclnt.jsfserver.base.faces.context.FacesContext;
import org.eclnt.jsfserver.elements.BaseActionComponent;
import org.eclnt.jsfserver.elements.BaseComponent;
import org.eclnt.jsfserver.elements.impl.IMAGEComponentTag;
import org.eclnt.jsfserver.elements.impl.IMAGESHAKERBinding;
import org.eclnt.jsfserver.elements.impl.PAINTAREAComponentTag;
import org.eclnt.jsfserver.elements.impl.PAINTAREAITEMComponentTag;
import org.eclnt.jsfserver.util.ExpressionManagerV;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.util.valuemgmt.ValueManager;

public class IMAGESHAKERComponent
extends BaseActionComponent {
    int m_lastChangeIndex = -1;

    @Override
    public Object saveState(FacesContext context) {
        return new Object[]{super.saveState(context), new Integer(this.m_lastChangeIndex)};
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.m_lastChangeIndex = (Integer)values[1];
    }

    @Override
    public void encodeBegin(FacesContext context) throws IOException {
        IMAGESHAKERComponent.ensureSessionIsValid(HttpSessionAccess.getCurrentHttpSessionIfAvailable(context));
        boolean inRiscMode = HttpSessionAccess.checkIfCurrentClientTypeIsRisc();
        String binding = this.getAttributeValueAsString("objectbinding");
        IMAGESHAKERBinding shaker = null;
        try {
            shaker = (IMAGESHAKERBinding)ExpressionManagerV.getValueForExpressionString(context, binding);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        boolean buildupRequired = false;
        if (this.getChildCount() == 0) {
            buildupRequired = true;
        }
        if (shaker != null && shaker.getChangeIndex() != this.m_lastChangeIndex) {
            this.m_lastChangeIndex = shaker.getChangeIndex();
            buildupRequired = true;
        }
        if (buildupRequired) {
            try {
                this.clearAndDestroyChildren();
                PAINTAREAComponentTag pct = new PAINTAREAComponentTag();
                pct.setId(this.createSubId());
                pct.setBackground(this.getAttributeValueAsString("background"));
                pct.setBgpaint(this.getAttributeValueAsString("bgpaint"));
                pct.setWidth(this.getAttributeValueAsString("width"));
                pct.setHeight(this.getAttributeValueAsString("height"));
                pct.setX(this.getAttributeValueAsString("x"));
                pct.setY(this.getAttributeValueAsString("y"));
                pct.setTrigger(binding.replace("}", ".trigger}"));
                pct.setMagnifyfactor("10");
                BaseComponent pc = pct.createBaseComponent();
                this.getChildren().add(pc);
                if (shaker != null) {
                    shaker.setImageheight(ValueManager.decodeIntWithRounding(this.getAttributeValueAsString("imageheight"), 120));
                    shaker.setImagewidth(ValueManager.decodeIntWithRounding(this.getAttributeValueAsString("imagewidth"), 180));
                    List<String> images = shaker.getImages();
                    int maxCount = images.size();
                    for (int counter = 0; counter < maxCount; ++counter) {
                        BaseComponent pic;
                        String image = images.get(counter);
                        PAINTAREAITEMComponentTag pit = new PAINTAREAITEMComponentTag();
                        pit.setId(this.createSubId());
                        pit.setBounds(binding.replace("}", ".imageInfoMap[\"" + counter + "\"].bounds}"));
                        pit.setInvokeevent("click");
                        pit.setActionListener(binding.replace("}", ".imageInfoMap[\"" + counter + "\"].onAction}"));
                        pit.setTooltip(binding.replace("}", ".imageInfoMap[\"" + counter + "\"].tooltip}"));
                        if (!inRiscMode) {
                            pit.setBgpaint(binding.replace("}", ".imageInfoMap[\"" + counter + "\"].bgpaint}"));
                            pic = pit.createBaseComponent();
                            pc.getChildren().add(pic);
                            continue;
                        }
                        pit.setBorder(binding.replace("}", ".imageInfoMap[\"" + counter + "\"].border}"));
                        pic = pit.createBaseComponent();
                        pc.getChildren().add(pic);
                        IMAGEComponentTag img = new IMAGEComponentTag();
                        img.setId(this.createSubId());
                        img.setImage(binding.replace("}", ".imageInfoMap[\"" + counter + "\"].image}"));
                        img.setWidth("100%");
                        img.setHeight("100%");
                        img.setKeepratio("false");
                        BaseComponent imgc = img.createBaseComponent();
                        pic.getChildren().add(imgc);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void encodeEnd(FacesContext context) throws IOException {
    }

    @Override
    public boolean getRendersChildren() {
        return true;
    }
}

