/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.elements.impl;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.eclnt.jsfserver.base.faces.context.FacesContext;
import org.eclnt.jsfserver.base.faces.context.ResponseWriter;
import org.eclnt.jsfserver.defaultscreens.AsynchMessageBus;
import org.eclnt.jsfserver.elements.BaseComponent;
import org.eclnt.jsfserver.elements.ComponentDump;
import org.eclnt.jsfserver.elements.ThreadData;
import org.eclnt.jsfserver.elements.XMLNode;
import org.eclnt.jsfserver.elements.impl.MESSAGEComponentTag;
import org.eclnt.jsfserver.elements.impl.ROWINCLUDEComponent;
import org.eclnt.jsfserver.elements.impl.ROWINCLUDEComponentTag;
import org.eclnt.jsfserver.session.SessionInfo;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.NagleUtil;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.ValueManager;

public class PAGEADDONSComponent
extends BaseComponent {
    boolean m_built = false;
    ROWINCLUDEComponent m_rowinclude;

    @Override
    public Object saveState(FacesContext context) {
        CLog.L.log(CLog.LL_INF, "State Magement: saveState is executed");
        return new Object[]{super.saveState(context), new Boolean(this.m_built)};
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        CLog.L.log(CLog.LL_INF, "State Magement: restoreState is executed");
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.m_built = (Boolean)values[1];
        this.m_rowinclude = (ROWINCLUDEComponent)this.getChild(0);
    }

    @Override
    public void decode(FacesContext context) {
        super.decode(context);
        this.executeQueueingOfBufferedEvents();
    }

    @Override
    public void encodeBegin(FacesContext context) throws IOException {
        PAGEADDONSComponent.ensureSessionIsValid(HttpSessionAccess.getCurrentHttpSessionIfAvailable(context));
        if (!this.m_built) {
            boolean loadedAsSubpage = this.checkIfLoadedAsSubpage();
            if (!loadedAsSubpage) {
                ROWINCLUDEComponentTag rict = new ROWINCLUDEComponentTag();
                rict.setId(this.createSubId());
                rict.setPage("/eclntjsfserver/includes/modalpopup.jsp");
                this.m_rowinclude = (ROWINCLUDEComponent)rict.createBaseComponent();
                this.clearAndDestroyChildren();
                this.getChildren().add(this.m_rowinclude);
            } else {
                CLog.L.log(CLog.LL_INF, "SUBPAGE was loaded - no adding of popup management");
            }
            this.m_built = true;
        }
        if (this.m_rowinclude != null) {
            this.m_rowinclude.encodeBegin(context);
        }
    }

    @Override
    public void encodeEnd(FacesContext context) throws IOException {
        if (this.m_rowinclude != null) {
            this.m_rowinclude.encodeEnd(context);
        }
        CLog.L.log(CLog.LL_INF, "Writing XML document for client response - Begin");
        HttpSession session = HttpSessionAccess.getCurrentHttpSession(context);
        PAGEADDONSComponent.writeDumpToXML(context, session);
        CLog.L.log(CLog.LL_INF, "Writing XML document for client response - End");
        Locale l = context.getViewRoot().getLocale();
        session.setAttribute("ccLastUsedLocale", (Object)l);
    }

    public static void writeDumpToXML(FacesContext context, HttpSession session) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        ComponentDump currentDump = (ComponentDump)session.getAttribute(ThreadData.getInstance().getSubpageId() + "/" + "org.eclnt.jsfserver/currentDump");
        try {
            XMLNode topNode = currentDump.getCurrentTopXMLNode();
            PAGEADDONSComponent.shiftClientConfigNodeToTop(topNode, true);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Problem shifting CLIENTCONFIG to front", t);
        }
        ThreadData.getInstance().setStampStartOfWritingResponse(System.currentTimeMillis());
        currentDump.writeXMLNodeToWriter(writer);
        SessionInfo si = SessionInfo.getSessionInstance(session, null);
        if (si != null && si.getNagleResponseSize() > 0) {
            PAGEADDONSComponent.appendNagleResponse(writer, si.getNagleResponseSize());
        }
    }

    private static void shiftClientConfigNodeToTop(XMLNode topNode, boolean alsoUseSubNode) {
        for (int i = topNode.getChildren().size() - 1; i >= 0; --i) {
            XMLNode childNode = topNode.getChildren().get(i);
            if (!childNode.getName().equals("clientconfig") || !childNode.getAttributeValue("id").endsWith("CCMP_CLIENTCONFIG")) continue;
            topNode.getChildren().remove(i);
            topNode.getChildren().add(0, childNode);
            return;
        }
        if (!alsoUseSubNode || topNode.getChildren().size() <= 0) {
            throw new Error("Could not find central CLIENTCONFIGNODE.");
        }
        PAGEADDONSComponent.shiftClientConfigNodeToTop(topNode.getChildren().get(0), false);
    }

    @Override
    public void encodeChildren(FacesContext context) throws IOException {
        if (this.m_rowinclude != null && this.m_rowinclude.getRendersChildren()) {
            this.m_rowinclude.encodeChildren(context);
        }
        List<String> messages = AsynchMessageBus.getMessages();
        long duration = System.currentTimeMillis() - ThreadData.getInstance().getStampStartOfProcessing();
        messages.add("ccserverrequestinfo(" + duration + ")");
        Iterator<String> iter = messages.iterator();
        int counter = 0;
        while (iter.hasNext()) {
            String message = iter.next();
            MESSAGEComponentTag mct = new MESSAGEComponentTag();
            mct.setMessage("#{eclntdefscr.asynchMessageBus.myMessages[" + counter + "]}");
            mct.setWithframedelegation("#{eclntdefscr.asynchMessageBus.myWithFrameDelegations[" + counter + "]}");
            BaseComponent mc = mct.createBaseComponent();
            mc.encodeBegin(context);
            if (mc.getRendersChildren()) {
                mc.encodeChildren(context);
            }
            mc.encodeEnd(context);
            ++counter;
        }
        AsynchMessageBus.clearMessages();
    }

    @Override
    public boolean getRendersChildren() {
        return true;
    }

    private boolean checkIfLoadedAsSubpage() {
        HttpServletRequest request = HttpSessionAccess.getCurrentRequest();
        if (request == null) {
            return false;
        }
        String ccassubpage = request.getParameter("CCASSUBPAGE");
        boolean result = ValueManager.decodeBoolean(ccassubpage, false);
        return result;
    }

    private static void appendNagleResponse(ResponseWriter writer, int nagleResponseSize) {
        if (nagleResponseSize <= 0) {
            return;
        }
        try {
            String nagleContent = NagleUtil.buildNagleString(nagleResponseSize);
            String nagleString = "<nagle content=\"" + nagleContent + "\"/>\n";
            writer.write(nagleString);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problem when appending nagle string", t);
        }
    }
}

