/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.elements.impl;

import java.io.IOException;
import java.util.List;
import org.eclnt.jsfserver.base.faces.context.FacesContext;
import org.eclnt.jsfserver.elements.BaseActionComponent;
import org.eclnt.jsfserver.elements.BaseComponent;
import org.eclnt.jsfserver.elements.ICCComponentProperties;
import org.eclnt.jsfserver.elements.impl.DRAWAREAComponentTag;
import org.eclnt.jsfserver.elements.impl.LABELComponentTag;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.util.valuemgmt.ValueManager;

public class RADIALComponent
extends BaseActionComponent
implements ICCComponentProperties {
    transient boolean m_isBuilt = false;
    transient String m_compareString = "inittini";
    transient BaseComponent m_drawarea = null;
    transient BaseComponent m_label = null;

    @Override
    public void encodeBegin(FacesContext context) throws IOException {
        RADIALComponent.ensureSessionIsValid(HttpSessionAccess.getCurrentHttpSessionIfAvailable(context));
        if (!this.m_isBuilt) {
            this.clearAndDestroyChildren();
            DRAWAREAComponentTag dact = new DRAWAREAComponentTag();
            dact.setId(this.createSubId("da"));
            LABELComponentTag lact = new LABELComponentTag();
            dact.setId(this.createSubId("la"));
            lact.setAlign("center");
            lact.setValign("middle");
            List<String> propertiesUsed = this.getPropertiesUsed();
            for (String property : propertiesUsed) {
                if (ATT_value.equals(property) || ATT_linesize.equals(property) || ATT_linecolor.equals(property)) continue;
                if (ATT_font.equals(property) || ATT_foreground.equals(property)) {
                    lact.invokeSetter(property, this.getAttributeString(property));
                    continue;
                }
                dact.invokeSetter(property, this.getAttributeString(property));
            }
            this.m_drawarea = dact.createBaseComponent();
            this.getChildren().add(this.m_drawarea);
            this.m_label = lact.createBaseComponent();
            this.m_drawarea.getChildren().add(this.m_label);
            this.m_isBuilt = true;
        }
        String value = this.getAttributeValueAsString(ATT_value);
        String width = this.getAttributeValueAsString(ATT_width);
        String height = this.getAttributeValueAsString(ATT_height);
        String linesize = this.getAttributeValueAsString(ATT_linesize);
        String linecolor = this.getAttributeValueAsString(ATT_linecolor);
        String compareString = "COMP/" + value + "/" + width + "/" + height + "/" + linesize + "/" + linecolor;
        if (!this.m_compareString.equals(compareString)) {
            this.m_compareString = compareString;
            if (width == null) {
                width = "100";
            }
            if (height == null) {
                height = "100";
            }
            if (value == null) {
                value = "50";
            }
            if (linesize == null) {
                linesize = "5";
            }
            if (linecolor == null) {
                linecolor = "#A0A0A0";
            }
            height = height.endsWith("%") ? height + "-10" : "" + (ValueManager.decodeInt(height, 100) - 10);
            width = width.endsWith("%") ? width + "-10" : "" + (ValueManager.decodeInt(width, 100) - 10);
            String drawCommand0 = ValueManager.encodeMethod("ovalline", new String[]{"5", "5", width, height, "#00000010", "1"});
            String drawCommand1 = ValueManager.encodeMethod("ovalline", new String[]{"5", "5", width, height, linecolor, linesize, "" + value});
            String drawCommand = drawCommand0 + ";" + drawCommand1;
            this.m_drawarea.setAttributeValueFromOutside(ATT_drawcommands, drawCommand);
            this.m_label.setAttributeValueFromOutside(ATT_text, value + "%");
        }
    }

    @Override
    public String getClientTagName() {
        return "radial";
    }
}

