/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.elements.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclnt.jsfserver.base.faces.event.ActionEvent;
import org.eclnt.jsfserver.elements.BaseComponentTag;
import org.eclnt.jsfserver.elements.BaseComponentTagBase;
import org.eclnt.jsfserver.util.IPropertyTypeResolver;
import org.eclnt.jsfserver.util.valuemgmt.IActionListenerDelegation;
import org.eclnt.jsfserver.util.valuemgmt.IDynamicContentBindingObject;
import org.eclnt.jsfserver.util.valuemgmt.IValueDelegation;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.UniqueIdCreator;
import org.eclnt.util.valuemgmt.ValueManager;

public class ROWDYNAMICCONTENTBinding
implements Serializable,
IDynamicContentBindingObject {
    String m_xml = null;
    long m_counter = 0L;
    List<ComponentNode> m_contentNodes = null;
    boolean m_rebuildOnContentChangeOnly = false;
    BoundAttributesMap m_boundAttributes = new BoundAttributesMap();
    String m_expressionBase = null;

    public ROWDYNAMICCONTENTBinding() {
    }

    public ROWDYNAMICCONTENTBinding(boolean rebuildOnContentChangeOnly) {
        this.m_rebuildOnContentChangeOnly = rebuildOnContentChangeOnly;
    }

    public void setContentXml(String xml) {
        this.m_xml = xml;
        this.m_contentNodes = null;
        this.updateCounter();
    }

    public String getContentXml() {
        return this.m_xml;
    }

    public void setContentNode(ComponentNode node) {
        if (node != null) {
            ArrayList<ComponentNode> nodes = new ArrayList<ComponentNode>(1);
            nodes.add(node);
            this.setContentNodes(nodes);
        } else {
            this.setContentNodes(new ArrayList<ComponentNode>(0));
        }
    }

    public void setContentNodes(List<ComponentNode> nodes) {
        this.m_contentNodes = nodes;
        this.m_xml = null;
        this.updateCounter();
    }

    public List<ComponentNode> getContentNodes() {
        return this.m_contentNodes;
    }

    public long getCounter() {
        return this.m_counter;
    }

    public void setCounter(long counter) {
        this.m_counter = counter;
    }

    public String findCurrentXML() {
        if (this.m_xml != null) {
            return this.m_xml;
        }
        if (this.m_contentNodes != null) {
            this.prepareValueBinding();
            StringBuffer sb = new StringBuffer();
            for (ComponentNode cn : this.m_contentNodes) {
                sb.append(cn.toXML());
            }
            return sb.toString();
        }
        return null;
    }

    public void passRuntimeExpression(String value) {
        this.m_expressionBase = value.substring(0, value.length() - 1);
    }

    public void prepareValueBinding() {
        this.m_boundAttributes.clear();
        if (this.m_contentNodes == null) {
            return;
        }
        for (ComponentNode node : this.m_contentNodes) {
            node.prepareValueBinding(this.m_expressionBase, this.m_boundAttributes.i_cas);
        }
    }

    public Map getBas() {
        return this.m_boundAttributes;
    }

    private void updateCounter() {
        StringBuffer sb = new StringBuffer();
        if (this.m_contentNodes != null) {
            for (ComponentNode cn : this.m_contentNodes) {
                sb.append(cn.toString());
            }
        }
        if (this.m_xml != null) {
            sb.append(this.m_xml);
        }
        String s = sb.toString();
        this.m_counter = this.calculateCounter(s);
    }

    protected long calculateCounter(String s) {
        if (this.m_rebuildOnContentChangeOnly) {
            if (s == null) {
                return 0L;
            }
            return s.hashCode();
        }
        return UniqueIdCreator.createCounter();
    }

    public class BoundAttributesMap
    extends HashMap<String, Object>
    implements IPropertyTypeResolver {
        List<ComponentAttribute> i_cas = new ArrayList<ComponentAttribute>();

        @Override
        public Object get(Object key) {
            int index = ValueManager.decodeInt("" + key, -1);
            ComponentAttribute ca = this.i_cas.get(index);
            Object result = ca.i_value;
            if (result != null && result instanceof IValueDelegation) {
                result = ((IValueDelegation)result).getValue();
            }
            return result;
        }

        @Override
        public Object put(String key, Object value) {
            int index = ValueManager.decodeInt("" + key, -1);
            ComponentAttribute ca = this.i_cas.get(index);
            if (ca != null && ca.i_value instanceof IValueDelegation) {
                ((IValueDelegation)ca.i_value).setValue(value);
            } else {
                CLog.L.log(CLog.LL_INF, "Put called in situation where it is not expected: " + key);
            }
            return value;
        }

        @Override
        public void clear() {
            super.clear();
            this.i_cas.clear();
        }

        @Override
        public Class resolveType(String key) {
            Class result = null;
            int index = ValueManager.decodeInt("" + key, -1);
            ComponentAttribute ca = this.i_cas.get(index);
            Object cav = ca.i_value;
            if (cav != null && cav instanceof IValueDelegation) {
                result = ((IValueDelegation)cav).getValueClass();
            }
            return result;
        }
    }

    public static class ComponentNode
    implements Serializable {
        String i_tagName;
        List<ComponentNode> i_subNodes = new ArrayList<ComponentNode>();
        Map<String, ComponentAttribute> i_attributes = new HashMap<String, ComponentAttribute>();

        public ComponentNode(String tagName) {
            this.i_tagName = tagName;
        }

        public String getTagName() {
            return this.i_tagName;
        }

        public List<ComponentNode> getSubNodes() {
            return this.i_subNodes;
        }

        public Map<String, ComponentAttribute> getAttributesMap() {
            return this.i_attributes;
        }

        public ComponentAttribute getAttribute(String name) {
            return this.i_attributes.get(name);
        }

        public ComponentNode addAttribute(String name, String value) {
            if (name == null) {
                throw new Error("addAttribute must not be called with name: null");
            }
            this.i_attributes.put(name, new ComponentAttribute(name, value));
            return this;
        }

        public ComponentNode addAttribute(String name, IDynamicContentBindingObject value) {
            ComponentAttribute ca;
            if (name == null) {
                throw new Error("addAttribute must not be called with name: null");
            }
            if (BaseComponentTagBase.ATT_ACTIONLISTENER.equals(name) && value != null) {
                if (!(value instanceof IActionListenerDelegation)) {
                    throw new Error("Attribute actionListener must bind to instance of IComponentNodeActionListener. The class of the current value is: " + value.getClass().getName());
                }
                value = new ActionListenerDelegator((IActionListenerDelegation)value);
            }
            if ((ca = this.i_attributes.get(name)) == null) {
                ca = new ComponentAttribute(name, value);
                this.i_attributes.put(name, ca);
            } else {
                ca.setValue(value);
            }
            return this;
        }

        public ComponentNode addAttributeValues(List<IComponentAttributeValueProvider> providedValues) {
            for (IComponentAttributeValueProvider providedValue : providedValues) {
                if (providedValue instanceof IComponentAttributeStringProvider) {
                    this.addAttribute(providedValue.getName(), ((IComponentAttributeStringProvider)providedValue).getValue());
                    continue;
                }
                if (providedValue instanceof IComponentAttributeBindingProvider) {
                    this.addAttribute(providedValue.getName(), ((IComponentAttributeBindingProvider)providedValue).getValue());
                    continue;
                }
                throw new Error("providedValue must implement either IComponentAttributeStringProvider or IComponentAttributeBindingProvider");
            }
            return this;
        }

        public Object getAttributeValue(String attributeName) {
            ComponentAttribute ca = this.i_attributes.get(attributeName);
            if (ca == null) {
                return null;
            }
            if (ca.isBound()) {
                IDynamicContentBindingObject result = ca.getBoundValue();
                if (result != null && result instanceof ActionListenerDelegator) {
                    result = ((ActionListenerDelegator)result).i_delegateTo;
                }
                return result;
            }
            return ca.getValue();
        }

        public ComponentNode addSubNode(ComponentNode componentNode) {
            this.i_subNodes.add(componentNode);
            return this;
        }

        public String toString() {
            return this.toString(0);
        }

        private String toString(int level) {
            StringBuffer result = new StringBuffer();
            for (int i = 0; i < level; ++i) {
                result.append("    ");
            }
            result.append(this.i_tagName);
            for (ComponentAttribute attribute : this.i_attributes.values()) {
                result.append(" " + attribute.i_name + ":" + attribute.i_value);
            }
            result.append("\n");
            for (ComponentNode subNode : this.i_subNodes) {
                result.append(subNode.toString(level + 1));
            }
            return result.toString();
        }

        public String toXML() {
            return this.toXML(0);
        }

        private String toXML(int level) {
            StringBuffer result = new StringBuffer();
            for (int i = 0; i < level; ++i) {
                result.append("    ");
            }
            result.append("<" + this.i_tagName);
            for (ComponentAttribute attribute : this.i_attributes.values()) {
                result.append(" " + attribute.i_name + "=\"");
                result.append(ValueManager.encodeIntoValidXMLString(attribute.getComponentAttributeValue()));
                result.append("\"");
            }
            result.append(">\n");
            for (ComponentNode subNode : this.i_subNodes) {
                result.append(subNode.toXML(level + 1));
            }
            for (int i = 0; i < level; ++i) {
                result.append("    ");
            }
            result.append("</" + this.i_tagName + ">\n");
            return result.toString();
        }

        private void prepareValueBinding(String expressionBase, List<ComponentAttribute> boundAttributes) {
            for (ComponentAttribute attribute : this.i_attributes.values()) {
                attribute.i_expression = null;
                if (!attribute.isBound() || expressionBase == null) continue;
                if (!BaseComponentTag.ATT_ACTIONLISTENER.equals(attribute.getName())) {
                    boundAttributes.add(attribute);
                    attribute.i_expression = expressionBase + ".bas['" + (boundAttributes.size() - 1) + "']}";
                    continue;
                }
                if (attribute.getBoundValue() != null && !(attribute.getBoundValue() instanceof IActionListenerDelegation)) {
                    throw new Error("The object bound to actionListener must implement IComponentNodeActionListener. Class of your object is: " + attribute.getBoundValue().getClass().getName());
                }
                boundAttributes.add(attribute);
                attribute.i_expression = expressionBase + ".bas[" + (boundAttributes.size() - 1) + "].onAction}";
            }
            for (ComponentNode subNode : this.i_subNodes) {
                subNode.prepareValueBinding(expressionBase, boundAttributes);
            }
        }
    }

    public static class ComponentAttributeContainer {
        ComponentAttribute i_attribute;

        public ComponentAttributeContainer(ComponentAttribute attribute) {
            this.i_attribute = attribute;
        }
    }

    public static class ActionListenerDelegator
    implements IActionListenerDelegation {
        IActionListenerDelegation i_delegateTo;

        public ActionListenerDelegator(IActionListenerDelegation delegateTo) {
            this.i_delegateTo = delegateTo;
        }

        @Override
        public void onAction(ActionEvent event) {
            if (this.i_delegateTo != null) {
                this.i_delegateTo.onAction(event);
            }
        }
    }

    public static class ComponentAttribute
    implements Serializable {
        boolean i_bound = false;
        String i_name;
        Object i_value;
        String i_expression = null;

        ComponentAttribute(String name, Object value) {
            this.i_name = name;
            this.i_value = value;
            if (value instanceof IDynamicContentBindingObject) {
                this.i_bound = true;
            }
        }

        public String getName() {
            return this.i_name;
        }

        public String getValue() {
            if (this.i_bound) {
                throw new Error("Value to be accessed is not directly set but bound: " + this.i_name);
            }
            return (String)this.i_value;
        }

        public IDynamicContentBindingObject getBoundValue() {
            if (!this.i_bound) {
                throw new Error("Value to be accessed is not bound: " + this.i_name);
            }
            Object result = this.i_value;
            if (result != null && result instanceof ActionListenerDelegator) {
                result = ((ActionListenerDelegator)result).i_delegateTo;
            }
            return (IDynamicContentBindingObject)this.i_value;
        }

        public void setValue(IDynamicContentBindingObject value) {
            if (!this.i_bound) {
                throw new Error("Value to be accessed is not bound: " + this.i_name);
            }
            this.i_value = value;
        }

        public String getComponentAttributeValue() {
            if (!this.i_bound) {
                return (String)this.i_value;
            }
            return this.i_expression;
        }

        public boolean isBound() {
            return this.i_bound;
        }
    }

    public static interface IComponentAttributeBindingProvider
    extends IComponentAttributeValueProvider {
        public IDynamicContentBindingObject getValue();
    }

    public static interface IComponentAttributeStringProvider
    extends IComponentAttributeValueProvider {
        public String getValue();
    }

    public static interface IComponentAttributeValueProvider {
        public String getName();
    }
}

