/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.elements.pagemodifier.implxml;

import java.util.Hashtable;
import java.util.Map;
import org.eclnt.jsfserver.elements.impl.ROWINCLUDEComponent;
import org.eclnt.jsfserver.elements.pagemodifier.IPageModifier;
import org.eclnt.jsfserver.elements.pagemodifier.implxml.Modification;
import org.eclnt.jsfserver.elements.pagemodifier.implxml.ModificationAttribute;
import org.eclnt.jsfserver.elements.pagemodifier.implxml.ModificationControl;
import org.eclnt.jsfserver.elements.pagemodifier.implxml.ModificationReader;

public class PageModifierXML
implements IPageModifier {
    String m_resourcePath;
    Modification m_modification;
    Map<String, ModificationControl> m_byId = new Hashtable<String, ModificationControl>();

    public PageModifierXML(String resourcePath) {
        this.m_resourcePath = resourcePath;
        this.m_modification = ModificationReader.readModification(resourcePath);
        for (ModificationControl mc : this.m_modification.getControls()) {
            if (mc.getControlId() == null) continue;
            this.m_byId.put(mc.getControlId(), mc);
        }
    }

    @Override
    public String getId() {
        return this.m_resourcePath;
    }

    @Override
    public void updateParsedNode(ROWINCLUDEComponent.ParsedNode node) {
        if (this.m_byId.containsKey(node.getId())) {
            ModificationControl mc = this.m_byId.get(node.getId());
            for (ModificationAttribute ma : mc.getAttributes()) {
                if (ma.getName() == null || ma.getValue() == null) continue;
                node.setAttributeValue(ma.getName(), ma.getValue());
            }
        }
    }

    public boolean checkIfAnyModificationContained() {
        return this.m_byId.values().size() != 0;
    }
}

