/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.elements.phases;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.ISessionAbstraction;
import org.eclnt.jsfserver.util.ISessionAbstractionListener;
import org.eclnt.jsfserver.util.ThreadingSynchronization;
import org.eclnt.util.buffermgmt.IResetBuffer;
import org.eclnt.util.buffermgmt.ResetBuffers;
import org.eclnt.util.log.CLog;

public class PostResponseProcessing {
    int m_threadSleepDuration = 5000;
    int m_defaultLatency = 2000;
    private static PostResponseProcessing s_instance = new PostResponseProcessing();
    ObservationThread m_observationThread = new ObservationThread();
    boolean m_isActive = false;
    Set<PostResponseProcessingInfo> m_listenerInfos = new HashSet<PostResponseProcessingInfo>();
    Map<IProcessPostResponseTrigger, PostResponseProcessingInfo> m_listeners = new HashMap<IProcessPostResponseTrigger, PostResponseProcessingInfo>();
    Map<String, List<PostResponseProcessingInfo>> m_listenerInfosBySessionId = new Hashtable<String, List<PostResponseProcessingInfo>>();

    public static PostResponseProcessing instance() {
        return s_instance;
    }

    public static void initialize(PostResponseProcessing instance) {
        s_instance = instance;
    }

    public void addPostResponseProcessing(IProcessPostResponseTrigger trigger) {
        this.addPostResponseProcessing(trigger, HttpSessionAccess.getCurrentDialogSession(), this.m_defaultLatency);
    }

    public void addPostResponseProcessing(IProcessPostResponseTrigger trigger, int latency) {
        this.addPostResponseProcessing(trigger, HttpSessionAccess.getCurrentDialogSession(), latency);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePostResponseProcessing(IProcessPostResponseTrigger listener) {
        if (!this.m_isActive) {
            return;
        }
        Map<IProcessPostResponseTrigger, PostResponseProcessingInfo> map = this.m_listeners;
        synchronized (map) {
            PostResponseProcessingInfo li = this.m_listeners.get(listener);
            if (li != null) {
                this.m_listeners.remove(listener);
                this.m_listenerInfos.remove(li);
                List<PostResponseProcessingInfo> l = this.m_listenerInfosBySessionId.get(li.getDialogSessionId());
                if (l != null) {
                    l.remove(li);
                    li.i_trigger = null;
                }
            }
        }
    }

    public void notifyRequestFinished(String dialogSessionId) {
        if (!this.m_isActive) {
            return;
        }
        try {
            List<PostResponseProcessingInfo> lis = this.m_listenerInfosBySessionId.get(dialogSessionId);
            if (lis != null) {
                long now = System.currentTimeMillis();
                for (PostResponseProcessingInfo li : lis) {
                    if (li.getTimeStampLastTrigger() > li.getTimeStampLastResponse()) {
                        li.setTimeStampLastTrigger(now - 1L);
                    }
                    li.setTimeStampLastResponse(now);
                }
            }
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problem occurred during notifyRequestFinished, dialog session: " + dialogSessionId, t);
        }
    }

    protected PostResponseProcessingInfo createPostResponseProcessingInfo(IProcessPostResponseTrigger trigger, String dialogSessionId, int latency) {
        return new PostResponseProcessingInfo(trigger, dialogSessionId, latency);
    }

    protected ObservationThread createObservationThread() {
        return new ObservationThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPostResponseProcessing(IProcessPostResponseTrigger trigger, ISessionAbstraction dialogSession, int latency) {
        this.activate();
        Map<IProcessPostResponseTrigger, PostResponseProcessingInfo> map = this.m_listeners;
        synchronized (map) {
            if (!this.m_listeners.containsKey(trigger)) {
                final PostResponseProcessingInfo li = this.createPostResponseProcessingInfo(trigger, dialogSession.getId(), latency);
                this.m_listenerInfos.add(li);
                this.m_listeners.put(trigger, li);
                List<PostResponseProcessingInfo> l = this.m_listenerInfosBySessionId.get(dialogSession.getId());
                if (l == null) {
                    l = new ArrayList<PostResponseProcessingInfo>();
                    this.m_listenerInfosBySessionId.put(dialogSession.getId(), l);
                }
                l.add(li);
                dialogSession.addListener(new ISessionAbstractionListener(){

                    @Override
                    public void reactOnClosed() {
                        PostResponseProcessing.this.removePostResponseProcessingOfDialogSession(li.getDialogSessionId());
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removePostResponseProcessingOfDialogSession(String dialogSessionId) {
        if (!this.m_isActive) {
            return;
        }
        Map<IProcessPostResponseTrigger, PostResponseProcessingInfo> map = this.m_listeners;
        synchronized (map) {
            List<PostResponseProcessingInfo> lis = this.m_listenerInfosBySessionId.get(dialogSessionId);
            if (lis == null) {
                return;
            }
            for (PostResponseProcessingInfo li : lis) {
                this.m_listeners.remove(li.getTrigger());
                this.m_listenerInfos.remove(li);
                li.i_trigger = null;
            }
            this.m_listenerInfosBySessionId.remove(dialogSessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activate() {
        Map<IProcessPostResponseTrigger, PostResponseProcessingInfo> map = this.m_listeners;
        synchronized (map) {
            if (this.m_isActive) {
                return;
            }
            this.m_isActive = true;
            this.m_listenerInfos.clear();
            this.m_listenerInfosBySessionId.clear();
            this.m_listeners.clear();
            this.m_observationThread = this.createObservationThread();
            this.m_observationThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deactivate() {
        Map<IProcessPostResponseTrigger, PostResponseProcessingInfo> map = this.m_listeners;
        synchronized (map) {
            this.m_isActive = false;
            if (this.m_observationThread != null) {
                this.m_observationThread.setStopped(true);
            }
            this.m_observationThread = null;
            this.m_listenerInfos.clear();
            this.m_listenerInfosBySessionId.clear();
            this.m_listeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processListenersInObservationThread() {
        ArrayList<PostResponseProcessingInfo> listToBeExecuted = new ArrayList<PostResponseProcessingInfo>();
        CLog.L.log(CLog.LL_INF, "PostResponseProcessing.processListenersInObservationThread: started, " + this.m_listeners.size());
        Map<IProcessPostResponseTrigger, PostResponseProcessingInfo> map = this.m_listeners;
        synchronized (map) {
            long now = System.currentTimeMillis();
            for (PostResponseProcessingInfo li : this.m_listenerInfos) {
                if (li.getTimeStampLastResponse() <= li.getTimeStampLastTrigger() || li.getTimeStampLastTrigger() + (long)li.getLatency() >= now) continue;
                listToBeExecuted.add(li);
            }
        }
        CLog.L.log(CLog.LL_INF, "PostResponseProcessing.processListenersInObservationThread: number of listeners to exectue: " + listToBeExecuted.size());
        this.executeListners(listToBeExecuted);
    }

    protected void executeListners(List<PostResponseProcessingInfo> listToBeExecuted) {
        for (PostResponseProcessingInfo li : listToBeExecuted) {
            this.executeListener(li);
        }
    }

    protected void executeListener(final PostResponseProcessingInfo li) {
        try {
            if (li.i_trigger == null) {
                return;
            }
            ThreadingSynchronization.instance().executeSynchronizedIfSessionIsAvailable(li.getDialogSessionId(), new Runnable(){

                @Override
                public void run() {
                    li.i_trigger.processPostResponse();
                    li.i_timeStampLastTrigger = System.currentTimeMillis();
                }
            });
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problem calling IProcessPostResponseTrigger: " + t, t);
        }
    }

    static {
        ResetBuffers.addListenerClassSwap(new IResetBuffer(){

            @Override
            public void reset() {
                s_instance.deactivate();
            }
        });
    }

    public class ObservationThread
    extends Thread {
        boolean i_stopped = false;

        @Override
        public void run() {
            block2: while (true) {
                try {
                    while (!this.i_stopped) {
                        ObservationThread.sleep(PostResponseProcessing.this.m_threadSleepDuration);
                        if (this.i_stopped) break block2;
                        PostResponseProcessing.this.processListenersInObservationThread();
                    }
                }
                catch (Throwable throwable) {
                    continue;
                }
                break;
            }
        }

        public void setStopped(boolean stopped) {
            this.i_stopped = stopped;
        }
    }

    public static interface IProcessPostResponseTrigger {
        public void processPostResponse();
    }

    class PostResponseProcessingInfo {
        IProcessPostResponseTrigger i_trigger;
        long i_timeStampCreation = System.currentTimeMillis();
        long i_timeStampLastResponse = System.currentTimeMillis();
        long i_timeStampLastTrigger = System.currentTimeMillis();
        String i_dialogSessionId;
        int i_latency;

        public PostResponseProcessingInfo(IProcessPostResponseTrigger listener, String dialogSessionId, int latency) {
            this.i_trigger = listener;
            this.i_dialogSessionId = dialogSessionId;
            this.i_latency = latency;
        }

        public long getTimeStampCreation() {
            return this.i_timeStampCreation;
        }

        public void setTimeStampCreation(long timeStampCreation) {
            this.i_timeStampCreation = timeStampCreation;
        }

        public long getTimeStampLastResponse() {
            return this.i_timeStampLastResponse;
        }

        public void setTimeStampLastResponse(long timeStampLastResponse) {
            this.i_timeStampLastResponse = timeStampLastResponse;
        }

        public long getTimeStampLastTrigger() {
            return this.i_timeStampLastTrigger;
        }

        public void setTimeStampLastTrigger(long timeStampLastListenerCall) {
            this.i_timeStampLastTrigger = timeStampLastListenerCall;
        }

        public IProcessPostResponseTrigger getTrigger() {
            return this.i_trigger;
        }

        public String getDialogSessionId() {
            return this.i_dialogSessionId;
        }

        public int getLatency() {
            return this.i_latency;
        }

        public void setLatency(int latency) {
            this.i_latency = latency;
        }
    }
}

