/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.elements.util;

import java.lang.reflect.Constructor;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclnt.jsfserver.base.faces.event.ActionEvent;
import org.eclnt.jsfserver.defaultscreens.Statusbar;
import org.eclnt.jsfserver.elements.impl.FIXGRIDListBinding;
import org.eclnt.jsfserver.elements.util.FIXGRIDBeanItem;
import org.eclnt.util.log.CLog;

public class FIXGRIDBeanListBinding<T>
extends FIXGRIDListBinding<FIXGRIDBeanItem<T>> {
    Set<T> m_removedBeans = new HashSet<T>();
    Set<T> m_addedBeans = new HashSet<T>();
    List<T> m_beanList;
    Class m_beanClass;
    Class m_rowItemClass = FIXGRIDBeanItem.class;
    Constructor m_rowItemClassConstructor;

    public FIXGRIDBeanListBinding() {
    }

    public FIXGRIDBeanListBinding(boolean changeInndexIsSupported) {
        super(changeInndexIsSupported);
    }

    public FIXGRIDBeanListBinding(Class beanClass) {
        this.m_beanClass = beanClass;
    }

    public FIXGRIDBeanListBinding(Class beanClass, Class rowItemClass) {
        try {
            this.m_beanClass = beanClass;
            this.m_rowItemClass = rowItemClass;
            this.m_rowItemClassConstructor = this.m_rowItemClass.getConstructor(beanClass);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public FIXGRIDBeanListBinding(Class beanClass, boolean changeInndexIsSupported) {
        super(changeInndexIsSupported);
        this.m_beanClass = beanClass;
    }

    public void showList(List<T> beanList) {
        this.m_beanList = beanList;
        this.getItems().clear();
        for (T bean : beanList) {
            this.getItems().add(this.wrapBean(bean));
        }
    }

    public FIXGRIDBeanItem<T> wrapBean(T bean) {
        try {
            if (this.m_rowItemClass == FIXGRIDBeanItem.class) {
                return new FIXGRIDBeanItem<T>(bean);
            }
            return (FIXGRIDBeanItem)this.m_rowItemClassConstructor.newInstance(bean);
        }
        catch (Throwable t) {
            throw new Error(t);
        }
    }

    public void onRemoveSelectedItems(ActionEvent ae) {
        Set selectedItems = this.getSelectedItems();
        for (FIXGRIDBeanItem selectedItem : selectedItems) {
            this.m_removedBeans.add(selectedItem.getBean());
            this.getItems().remove(selectedItem);
            this.m_beanList.remove(selectedItem.getBean());
        }
    }

    public void onAddItem(ActionEvent ae) {
        try {
            T bean = this.createBean();
            FIXGRIDBeanItem<T> item = this.wrapBean(bean);
            this.getItems().add(item);
            this.m_addedBeans.add(bean);
            this.m_beanList.add(bean);
            this.deselectCurrentSelection();
            this.selectItem(item);
            this.ensureItemToBeDisplayed(item);
        }
        catch (Throwable t) {
            Statusbar.outputError(t.toString());
        }
    }

    public Set<T> getRemovedBeans() {
        return this.m_removedBeans;
    }

    public Set<T> getAddedBeans() {
        return this.m_removedBeans;
    }

    public void reset() {
        this.m_removedBeans.clear();
        this.m_addedBeans.clear();
    }

    public T createBean() {
        try {
            if (this.m_beanClass == null) {
                throw new Error("Bean class was not passed via consturctor.");
            }
            return this.m_beanClass.newInstance();
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Problems when creating bean...", t);
            return null;
        }
    }

    public FIXGRIDBeanListBinding<T> getThis() {
        return this;
    }
}

