/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.monitoring.servertimeout;

import jakarta.servlet.ServletContext;
import java.util.HashSet;
import java.util.Set;
import org.eclnt.jsfserver.monitoring.servertimeout.IServerTimeOutListener;
import org.eclnt.jsfserver.monitoring.servertimeout.IServerTimeOutManager;
import org.eclnt.jsfserver.monitoring.servertimeout.ServerTimeOutInfo;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.util.file.FileManager;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.JAXBManager;

public class ServerTimeOutManager
implements IServerTimeOutManager {
    int m_cacheFileAccessDuration = 10000;
    String m_timeOutFileName;
    ServerTimeOutInfo m_lastServerTimeOutInfo = null;
    long m_lastServerTimeOutInfoReadTimestamp = 0L;
    Set<IServerTimeOutListener> m_listeners = new HashSet<IServerTimeOutListener>();

    @Override
    public void initialize(ServletContext servletContext) {
        this.m_timeOutFileName = HttpSessionAccess.getServletTempDirectory() + "/ccservertimeout/servertimeout.xml";
        this.removeCurrentServerTimeOut();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTimeOutListener(IServerTimeOutListener listener) {
        if (listener == null) {
            return;
        }
        Set<IServerTimeOutListener> set = this.m_listeners;
        synchronized (set) {
            this.m_listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTimeOutListener(IServerTimeOutListener listener) {
        if (listener == null) {
            return;
        }
        Set<IServerTimeOutListener> set = this.m_listeners;
        synchronized (set) {
            this.m_listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void triggerServerTimeout(ServerTimeOutInfo sti) {
        FileManager.ensureDirectoryForFileExists(this.m_timeOutFileName);
        String xml = JAXBManager.marshal(sti);
        FileManager.writeUTF8File(this.m_timeOutFileName, xml, true);
        this.m_lastServerTimeOutInfoReadTimestamp = 0L;
        Set<IServerTimeOutListener> set = this.m_listeners;
        synchronized (set) {
            for (IServerTimeOutListener listener : this.m_listeners) {
                try {
                    listener.onServerTimeoutRegistered(this);
                }
                catch (Throwable t) {
                    CLog.L.log(CLog.LL_WAR, "Error happened when executing server time out listener.\nThe error is ignored in order to continue the processing.\nName of listener: " + listener.getName(), t);
                }
            }
        }
    }

    @Override
    public void removeCurrentServerTimeOut() {
        try {
            FileManager.deleteFile(this.m_timeOutFileName);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public long findCurrentDurationUntilServerTimeOut() {
        try {
            long now = System.currentTimeMillis();
            if (now - this.m_lastServerTimeOutInfoReadTimestamp > (long)this.m_cacheFileAccessDuration) {
                ServerTimeOutInfo sti;
                this.m_lastServerTimeOutInfoReadTimestamp = now;
                String xml = FileManager.readUTF8File(this.m_timeOutFileName, true);
                this.m_lastServerTimeOutInfo = sti = (ServerTimeOutInfo)JAXBManager.unmarshal(xml, ServerTimeOutInfo.class);
            }
            if (this.m_lastServerTimeOutInfo == null) {
                return -1L;
            }
            long result = this.m_lastServerTimeOutInfo.m_timeOutAt.getTime() - now;
            if (result < 0L) {
                result = 0L;
            }
            return result;
        }
        catch (Throwable t) {
            this.m_lastServerTimeOutInfo = null;
            return -1L;
        }
    }
}

