/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.pagebean.component;

import java.util.Locale;
import java.util.ResourceBundle;
import org.eclnt.jsfserver.elements.ConfiguredByLayoutAddon;
import org.eclnt.jsfserver.elements.IBaseComponent;
import org.eclnt.jsfserver.elements.IConfiguredByLayoutListener;
import org.eclnt.jsfserver.managedbean.HotDeployManager;
import org.eclnt.jsfserver.pagebean.PageBean;
import org.eclnt.jsfserver.pagebean.component.PageBeanComponentRepository;
import org.eclnt.jsfserver.pagebean.component.PageBeanLiteralResolverOverride;
import org.eclnt.jsfserver.resources.ResourceUtil;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.util.file.ClassloaderReader;
import org.eclnt.util.log.CLog;
import org.eclnt.util.map.DelegatingStringMap;
import org.eclnt.util.valuemgmt.ValueManager;

public abstract class PageBeanComponentBase
extends PageBean {
    private boolean m_initialized = false;
    private ResourceBundle m_resourceBundle = null;
    private boolean m_resourceBundleInitialized = false;
    private Locale m_resourceBundleLocale = null;
    private boolean m_usedAsRow = false;
    private ILiteralResolver m_literalResolver = PageBeanLiteralResolverOverride.getLiteralResolverForPageBean(this.getClass());
    private ConfiguredByLayoutAddon m_configuredByLayoutAddon = null;

    public PageBeanComponentBase() {
    }

    public PageBeanComponentBase(boolean usedAsRow) {
        this();
        this.m_usedAsRow = usedAsRow;
    }

    public void initializePageBeanStarted() {
        this.m_initialized = true;
    }

    public void initializePageBeanPassComponent(IBaseComponent component) {
    }

    public boolean isInitialized() {
        return this.m_initialized;
    }

    public ILiteralResolver getLiteralResolver() {
        if (this.m_literalResolver != null) {
            return this.m_literalResolver;
        }
        return null;
    }

    public void setLiteralResolver(ILiteralResolver literalResolver) {
        this.m_literalResolver = literalResolver;
    }

    @Override
    public String getPageName() {
        if (!this.m_usedAsRow) {
            return "/ccclresource:" + this.getLayoutPath();
        }
        return "/ccclresourceasrow:" + this.getLayoutPath();
    }

    protected String getLayoutPath() {
        ClassloaderReader clr = new ClassloaderReader(true);
        String c = this.getClassDefiningPageBean().getName();
        String resultJSP = c.replace('.', '/') + ".jsp";
        boolean exist = clr.checkIfFileExists(resultJSP);
        if (exist) {
            return resultJSP;
        }
        String resultXML = c.replace('.', '/') + ".xml";
        exist = clr.checkIfFileExists(resultXML);
        if (exist) {
            return resultXML;
        }
        return resultXML;
    }

    protected Class getClassDefiningPageBean() {
        return PageBeanComponentRepository.readOriginalClass(this.getClass());
    }

    public void addConfiguredByLayoutListener(IConfiguredByLayoutListener listener) {
        if (listener == null) {
            return;
        }
        this.ensureConfiguredByLayoutAddonIsInitialized();
        this.m_configuredByLayoutAddon.addListener(listener);
    }

    public void removeConfiguredByLayoutListener(IConfiguredByLayoutListener listener) {
        if (this.m_configuredByLayoutAddon == null) {
            return;
        }
        this.m_configuredByLayoutAddon.removeListener(listener);
    }

    public void initializePageBeanFinished() {
        if (this.m_configuredByLayoutAddon != null) {
            this.m_configuredByLayoutAddon.triggerListeners();
        }
    }

    protected String readLiteral(String key) {
        String result;
        if (this.getLiteralResolver() != null && (result = this.getLiteralResolver().findLiteral(key)) != null) {
            result = ResourceUtil.updateResourceTextBeforeUsage(result);
            return result;
        }
        return this.readLiteralByOwnResourceBundle(key);
    }

    protected String findLiteralResourceName() {
        return this.getClassDefiningPageBean().getName();
    }

    private void ensureConfiguredByLayoutAddonIsInitialized() {
        if (this.m_configuredByLayoutAddon == null) {
            this.m_configuredByLayoutAddon = new ConfiguredByLayoutAddon();
        }
    }

    protected String readLiteralByOwnResourceBundle(String key) {
        Locale loc = HttpSessionAccess.getCurrentLocale();
        if (!(!this.m_resourceBundleInitialized || this.m_resourceBundle == null || loc == null || ValueManager.checkIfStringsAreEqual(loc.getLanguage(), this.m_resourceBundleLocale.getLanguage()) && ValueManager.checkIfStringsAreEqual(loc.getCountry(), this.m_resourceBundleLocale.getCountry()))) {
            this.m_resourceBundleInitialized = false;
        }
        if (!this.m_resourceBundleInitialized) {
            try {
                this.m_resourceBundleInitialized = true;
                String resourceName = this.findLiteralResourceName();
                this.m_resourceBundleLocale = loc = HttpSessionAccess.getCurrentFacesContext().getViewRoot().getLocale();
                this.m_resourceBundle = ResourceBundle.getBundle(resourceName, loc, HotDeployManager.currentClassLoader());
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_INF, "Problem when reading resource bundle", t);
            }
        }
        if (this.m_resourceBundle == null) {
            return null;
        }
        String result = this.m_resourceBundle.getString(key);
        result = ResourceUtil.updateResourceTextBeforeUsage(result);
        return result;
    }

    public static interface ILiteralResolver {
        public String findLiteral(String var1);
    }

    public class LitMap
    extends DelegatingStringMap {
        @Override
        public String get(Object key) {
            if (key == null) {
                return null;
            }
            return PageBeanComponentBase.this.readLiteral(key.toString());
        }
    }
}

