/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.polling;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import org.eclnt.jsfserver.base.faces.FactoryFinder;
import org.eclnt.jsfserver.base.faces.context.FacesContextFactory;
import org.eclnt.jsfserver.base.faces.lifecycle.Lifecycle;
import org.eclnt.jsfserver.base.faces.lifecycle.LifecycleFactory;
import org.eclnt.jsfserver.polling.DefaultLongPolling30API;
import org.eclnt.jsfserver.util.ServletUtil;
import org.eclnt.util.log.CLog;

public class LongPollingServlet30API
extends HttpServlet {
    private FacesContextFactory m_facesContextFactory;
    private Lifecycle m_lifecycle;

    public void init() throws ServletException {
        super.init();
        try {
            LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory("org.eclnt.jsfserver.base.faces.lifecycle.LifecycleFactory");
            this.m_facesContextFactory = (FacesContextFactory)FactoryFinder.getFactory("org.eclnt.jsfserver.base.faces.context.FacesContextFactory");
            this.m_lifecycle = lifecycleFactory.getLifecycle("DEFAULT");
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problems in init() of LongPollingServlet30API - only relevant if accessing FacesContext during servlet processing");
        }
    }

    public void service(ServletRequest req, final ServletResponse res) throws ServletException, IOException {
        HttpSession session = ((HttpServletRequest)req).getSession(false);
        ServletUtil.setResponseContentType((HttpServletResponse)res, "text/plain");
        if (session == null) {
            CLog.L.log(CLog.LL_INF, "No session for request found");
            res.getWriter().flush();
            res.getWriter().close();
            return;
        }
        CLog.L.log(CLog.LL_INF, "Session id: " + session.getId());
        String pollerId = this.getPollerId((HttpServletRequest)req);
        CLog.L.log(CLog.LL_INF, "Poller id: " + pollerId);
        if (pollerId == null) {
            res.getWriter().flush();
            res.getWriter().close();
            return;
        }
        try {
            final DefaultLongPolling30API poller = (DefaultLongPolling30API)session.getAttribute(pollerId);
            if (poller == null) {
                throw new Exception("No poller object found in session");
            }
            final AsyncContext ctx = req.startAsync();
            ctx.setTimeout(0L);
            ctx.addListener(new AsyncListener(){

                public void onTimeout(AsyncEvent arg0) throws IOException {
                }

                public void onStartAsync(AsyncEvent arg0) throws IOException {
                }

                public void onError(AsyncEvent arg0) throws IOException {
                }

                public void onComplete(AsyncEvent arg0) throws IOException {
                }
            });
            ctx.start(new Runnable(){

                @Override
                public void run() {
                    poller.waitForEvent(ctx, (HttpServletResponse)res);
                }
            });
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problem is server side long polling", t);
            res.getWriter().flush();
            res.getWriter().close();
            return;
        }
    }

    private String getPollerId(HttpServletRequest req) {
        String pollerId = req.getRequestURI();
        int index = pollerId.indexOf(".cclongpolling30API");
        if (index > 0) {
            pollerId = pollerId.substring(0, index);
            index = pollerId.lastIndexOf(47);
            pollerId = pollerId.substring(index + 1);
            pollerId = "cclongpolling_" + pollerId;
            return pollerId;
        }
        return null;
    }
}

