/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.polling.websocket;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpSession;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.OnClose;
import jakarta.websocket.OnError;
import jakarta.websocket.OnMessage;
import jakarta.websocket.OnOpen;
import jakarta.websocket.Session;
import jakarta.websocket.server.PathParam;
import jakarta.websocket.server.ServerContainer;
import jakarta.websocket.server.ServerEndpointConfig;
import java.io.IOException;
import org.eclnt.jsfserver.polling.websocket.DefaultLongPollingWebSocket;
import org.eclnt.jsfserver.polling.websocket.WebSocketSessionConfigurator;
import org.eclnt.util.log.CLog;

public class WebSocketPollingEndPoint {
    String m_pollerId;
    DefaultLongPollingWebSocket m_longPolling;
    Session m_webSocketSession;

    public static void init(ServletContext context) {
        try {
            CLog.L.log(CLog.LL_INF, "Initializing web socket end point. Begin...");
            ServerContainer container = (ServerContainer)context.getAttribute(ServerContainer.class.getName());
            ServerEndpointConfig config = ServerEndpointConfig.Builder.create(WebSocketPollingEndPoint.class, (String)"/ccwebsocketpolling/{pollerId}").configurator((ServerEndpointConfig.Configurator)new WebSocketSessionConfigurator()).build();
            container.addEndpoint(config);
            CLog.L.log(CLog.LL_INF, "Initializing web socket end point. ...End.");
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problem registering web socket end point", t);
            CLog.L.log(CLog.LL_INF, "Startup will be continued: but web socket polling is NOT available in this instance");
        }
    }

    @OnOpen
    public void onOpen(@PathParam(value="pollerId") String pollerId, Session webSocketSession, EndpointConfig config) {
        CLog.L.log(CLog.LL_INF, "ccwebsocketpolling - onOpen: pollerId = " + pollerId);
        this.m_pollerId = pollerId;
        this.m_webSocketSession = webSocketSession;
        HttpSession httpSession = (HttpSession)config.getUserProperties().get(HttpSession.class.getName());
        if (httpSession != null) {
            Object o = httpSession.getAttribute("cclongpolling_" + pollerId);
            if (o == null) {
                CLog.L.log(CLog.LL_ERR, "Could not find long polling object for id: " + this.m_pollerId);
                return;
            }
            if (o instanceof DefaultLongPollingWebSocket) {
                this.m_longPolling = (DefaultLongPollingWebSocket)o;
                this.m_longPolling.registerEndPoint(this);
            } else {
                CLog.L.log(CLog.LL_ERR, "Long polling object is of class: " + o.getClass().getName());
                CLog.L.log(CLog.LL_ERR, "Long polling object but must be: " + DefaultLongPollingWebSocket.class.getName());
            }
        } else {
            try {
                CLog.L.log(CLog.LL_INF, "Websocket: Could not find httpSession assigned to the web socket connection");
                CLog.L.log(CLog.LL_INF, "Websocket: Now sending signal to abort to client");
                this.sendMessage("false");
                CLog.L.log(CLog.LL_INF, "Websocket: Now closing connection");
                this.close();
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_INF, "Problem sending websocket to abort connection");
            }
        }
    }

    @OnClose
    public void onClose() {
        CLog.L.log(CLog.LL_INF, "ccwebsocketpolling - onClose");
        if (this.m_longPolling != null) {
            CLog.L.log(CLog.LL_INF, "ccwebsocketpolling - onClose: unregistering from long polling");
            try {
                this.m_longPolling.unregisterEndPoint(this);
            }
            catch (Throwable throwable) {}
        } else {
            CLog.L.log(CLog.LL_INF, "ccwebsocketpolling - onClose: no unregistering required, longpolling is null");
        }
    }

    @OnError
    public void onError(Throwable t) {
        CLog.L.log(CLog.LL_INF, "ccwebsocketpolling - on Error: " + t.getMessage());
    }

    @OnMessage
    public String onMessage(String message) {
        CLog.L.log(CLog.LL_INF, "ccwebsocketpolling - onMessage: " + message);
        return "";
    }

    public void sendMessage(String message) throws IOException {
        CLog.L.log(CLog.LL_INF, "ccwebsocketpolling - sendMessage: " + message);
        this.m_webSocketSession.getBasicRemote().sendText(message);
        CLog.L.log(CLog.LL_INF, "ccwebsocketpolling - sendMessage: finished");
    }

    public void close() {
        try {
            CLog.L.log(CLog.LL_INF, "ccwebsocketpolling - close");
            if (this.m_webSocketSession != null) {
                this.m_webSocketSession.close();
            }
            this.m_webSocketSession = null;
            this.m_longPolling = null;
            CLog.L.log(CLog.LL_INF, "ccwebsocketpolling - close finished");
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problem closing end point", t);
        }
    }
}

