/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.rttools;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import org.eclnt.jsfserver.elements.impl.FIXGRIDTreeBinding;
import org.eclnt.jsfserver.elements.impl.FIXGRIDTreeItem;
import org.eclnt.jsfserver.elements.util.Trigger;
import org.eclnt.jsfserver.pagebean.PageBean;
import org.eclnt.jsfserver.rttools.DynBeanUI;
import org.eclnt.jsfserver.util.BeanIntrospector;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.util.log.CLog;
import org.eclnt.workplace.WorkplaceFunctionTreeInfoNode;

public class DynBeanTreeUI
extends PageBean
implements Serializable {
    FIXGRIDTreeBinding<TreeNode> m_tree = new FIXGRIDTreeBinding();
    DynBeanUI m_dynBean;
    Trigger m_animationTriggerContent = new Trigger();
    Trigger m_animationTriggerTree = new Trigger();
    Object m_bean;

    public DynBeanTreeUI() {
        if (HttpSessionAccess.checkIfInLayoutEditorPreview()) {
            WorkplaceFunctionTreeInfoNode bean = new WorkplaceFunctionTreeInfoNode();
            this.prepare(bean);
        }
    }

    @Override
    public String getPageName() {
        return "/eclntjsfserver/includes/dynbeantree.jsp";
    }

    @Override
    public String getRootExpressionUsedInPage() {
        return "#{cctd.DynBeanTreeUI}";
    }

    public FIXGRIDTreeBinding<TreeNode> getTree() {
        return this.m_tree;
    }

    public DynBeanUI getDynBean() {
        return this.m_dynBean;
    }

    public Trigger getAnimationTriggerContent() {
        return this.m_animationTriggerContent;
    }

    public Trigger getAnimationTriggerTree() {
        return this.m_animationTriggerTree;
    }

    public Object getBean() {
        return this.m_bean;
    }

    public void prepare(Object bean) {
        this.m_bean = bean;
        this.m_tree.deselectCurrentSelection();
        this.m_tree.getRootNode().removeAllChildNodes(true);
        TreeNode tn = new TreeNode(this.m_tree.getRootNode(), bean);
        tn.setStatus(1);
        tn.setImage("/eclntjsfserver/images/package.png");
        tn.setText(bean.getClass().getSimpleName());
        this.m_tree.selectItem(tn);
        tn.toggleNode();
    }

    private void showBean(final TreeNode node, Object bean) {
        if (this.m_dynBean == null || this.m_dynBean.getBeanClass() != bean.getClass()) {
            this.m_dynBean = new DynBeanUI(bean.getClass(), false, null);
        }
        this.m_dynBean.setListener(new DynBeanUI.IListener(){

            @Override
            public void reactOnDataUpdate(Object bean) {
                node.refresh();
                if (node.getStatusInt() == 1) {
                    node.toggleNode();
                }
            }
        });
        this.m_dynBean.setBean(bean);
        this.m_animationTriggerContent.trigger();
    }

    public class TreeNode
    extends FIXGRIDTreeItem
    implements Serializable {
        Object i_bean;
        boolean i_subBeansRead;
        Method i_textGetter;

        public TreeNode(FIXGRIDTreeItem parentNode, Object bean) {
            super(parentNode);
            this.i_subBeansRead = false;
            this.i_textGetter = null;
            this.i_bean = bean;
            try {
                this.i_textGetter = BeanIntrospector.readProperties(this.i_bean.getClass()).get("text").getGetter();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        @Override
        public void onToggle() {
            if (!this.i_subBeansRead) {
                this.readSubBeans();
                this.i_subBeansRead = true;
            }
        }

        @Override
        public void onRowSelect() {
            DynBeanTreeUI.this.showBean(this, this.i_bean);
        }

        @Override
        public String getText() {
            String result = super.getText();
            try {
                String text;
                if (this.i_textGetter != null && (text = (String)this.i_textGetter.invoke(this.i_bean, null)) != null) {
                    result = result + " / " + text;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return result;
        }

        private void readSubBeans() {
            try {
                List<BeanIntrospector.PropertyIntrospectionInfo> piis = BeanIntrospector.readPropertiesAsList(this.i_bean.getClass());
                for (BeanIntrospector.PropertyIntrospectionInfo pii : piis) {
                    Object o;
                    if (BeanIntrospector.checkIfSimpleDataType(pii.getGetter().getReturnType()) || Collection.class.isAssignableFrom(pii.getGetter().getReturnType()) || "class".equals(pii.getPropertyName()) || (o = pii.getGetter().invoke(this.i_bean, null)) == null) continue;
                    TreeNode tn = new TreeNode(this, o);
                    tn.setImage("/eclntjsfserver/images/package.png");
                    tn.setStatus(1);
                    tn.setText(pii.getPropertyName());
                }
                for (BeanIntrospector.PropertyIntrospectionInfo pii : piis) {
                    if (BeanIntrospector.checkIfSimpleDataType(pii.getGetter().getReturnType()) || !Collection.class.isAssignableFrom(pii.getGetter().getReturnType())) continue;
                    List os = (List)pii.getGetter().invoke(this.i_bean, null);
                    int counter = 0;
                    for (Object o : os) {
                        if (o == null || BeanIntrospector.checkIfSimpleDataType(o.getClass())) continue;
                        TreeNode tn = new TreeNode(this, o);
                        tn.setImage("/eclntjsfserver/images/table.png");
                        tn.setStatus(1);
                        tn.setText(pii.getPropertyName() + " [" + counter + "]");
                        ++counter;
                    }
                }
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_ERR, "", t);
            }
        }

        private void refresh() {
            if (this.i_subBeansRead) {
                this.removeAllChildNodes(true);
                this.readSubBeans();
            }
        }
    }
}

