/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.rttools;

import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclnt.jsfserver.base.faces.event.ActionEvent;
import org.eclnt.jsfserver.defaultscreens.ISetId;
import org.eclnt.jsfserver.defaultscreens.IdTextSelection;
import org.eclnt.jsfserver.defaultscreens.YESNOPopup;
import org.eclnt.jsfserver.elements.BaseComponent;
import org.eclnt.jsfserver.elements.componentnodes.BUTTONNode;
import org.eclnt.jsfserver.elements.componentnodes.CHECKBOXNode;
import org.eclnt.jsfserver.elements.componentnodes.COLDISTANCENode;
import org.eclnt.jsfserver.elements.componentnodes.COMBOFIELDNode;
import org.eclnt.jsfserver.elements.componentnodes.FIELDNode;
import org.eclnt.jsfserver.elements.componentnodes.FIXGRIDNode;
import org.eclnt.jsfserver.elements.componentnodes.FOLDABLEPANENode;
import org.eclnt.jsfserver.elements.componentnodes.FORMATTEDFIELDNode;
import org.eclnt.jsfserver.elements.componentnodes.GRIDCOLNode;
import org.eclnt.jsfserver.elements.componentnodes.LABELNode;
import org.eclnt.jsfserver.elements.componentnodes.LINKNode;
import org.eclnt.jsfserver.elements.componentnodes.PANENode;
import org.eclnt.jsfserver.elements.componentnodes.ROWNode;
import org.eclnt.jsfserver.elements.componentnodes.ROWPAGEBEANINCLUDENode;
import org.eclnt.jsfserver.elements.events.BaseActionEventValueHelp;
import org.eclnt.jsfserver.elements.impl.FIXGRIDItem;
import org.eclnt.jsfserver.elements.impl.FIXGRIDListBinding;
import org.eclnt.jsfserver.elements.impl.ROWDYNAMICCONTENTBinding;
import org.eclnt.jsfserver.pagebean.PageBean;
import org.eclnt.jsfserver.rttools.CCPropertyInfo;
import org.eclnt.jsfserver.util.BeanIntrospector;
import org.eclnt.util.classresolver.CCClassResolver;
import org.eclnt.util.classresolver.ENUMCallerType;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.BeanWithParent;
import org.eclnt.util.valuemgmt.ValueManager;
import org.eclnt.workplace.WorkpageStartInfo;

public class DynBeanUI
extends PageBean
implements Serializable {
    static int GRIDTYPE_DEFAULT = 0;
    static int GRIDTYPE_SIMPLEDATATYPE = 1;
    static int GRIDTYPE_MAPSIMPLEDATATYPE = 2;
    ROWDYNAMICCONTENTBinding m_content = new ROWDYNAMICCONTENTBinding();
    Map<String, DynBeanUI> m_subDynBeans = new HashMap<String, DynBeanUI>();
    Map<String, Grid> m_grids = new HashMap<String, Grid>();
    Object m_bean;
    Class mm_beanClass;
    Map<String, BeanIntrospector.PropertyIntrospectionInfo> m_piis;
    Map<String, MapString> m_mapStrings = new HashMap<String, MapString>();
    List<String> m_properties = new ArrayList<String>();
    boolean m_onlyResolveFirstLevel = false;
    IListener m_listener;
    IExtension m_extension;

    public DynBeanUI() {
        WorkpageStartInfo bean = new WorkpageStartInfo();
        this.setBeanClass(bean.getClass());
        this.initExtension();
        this.renderContent();
        this.setBean(bean);
    }

    public DynBeanUI(Class beanClass, boolean onlyReolveFirstLevel, IListener listener) {
        this.m_onlyResolveFirstLevel = onlyReolveFirstLevel;
        this.setBeanClass(beanClass);
        this.initExtension();
        this.m_listener = listener;
        this.renderContent();
    }

    @Override
    public String getPageName() {
        return "/eclntjsfserver//includes/dynbean.jsp";
    }

    @Override
    public String getRootExpressionUsedInPage() {
        return "#{cctd.DynBeanUI}";
    }

    public ROWDYNAMICCONTENTBinding getContent() {
        return this.m_content;
    }

    public Object getBean() {
        return this.m_bean;
    }

    public Map<String, DynBeanUI> getSubDynBeans() {
        return this.m_subDynBeans;
    }

    public Map<String, Grid> getGrids() {
        return this.m_grids;
    }

    public Map<String, MapString> getMapStrings() {
        return this.m_mapStrings;
    }

    public Class getBeanClass() {
        return this.mm_beanClass;
    }

    public boolean isObjectNull() {
        return !this.isObjectAvailable();
    }

    public boolean isObjectAvailable() {
        return this.m_bean != null;
    }

    public void setListener(IListener listener) {
        this.m_listener = listener;
    }

    public void setBean(Object bean) {
        BeanIntrospector.PropertyIntrospectionInfo pii;
        this.m_bean = bean;
        this.m_extension.init(bean);
        for (String key : this.m_grids.keySet()) {
            try {
                pii = this.m_piis.get(key);
                List l = (List)pii.getGetter().invoke(this.m_bean, null);
                this.m_grids.get(key).prepare(l);
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_ERR, "", t);
            }
        }
        for (String key : this.m_subDynBeans.keySet()) {
            try {
                pii = this.m_piis.get(key);
                Object subBean = pii.getGetter().invoke(this.m_bean, null);
                this.m_subDynBeans.get(key).setBean(subBean);
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_ERR, "", t);
            }
        }
        for (String key : this.m_mapStrings.keySet()) {
            try {
                pii = this.m_piis.get(key);
                Map map = (Map)pii.getGetter().invoke(this.m_bean, null);
                this.m_mapStrings.get(key).setMap(map);
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_ERR, "", t);
            }
        }
    }

    public void onCreateSubBean(ActionEvent event) {
        String comment = ((BaseComponent)event.getComponent()).getAttributeValueAsString("comment");
        this.createSubBean(comment);
    }

    public void onRemoveSubBean(ActionEvent event) {
        final String comment = ((BaseComponent)event.getComponent()).getAttributeValueAsString("comment");
        YESNOPopup.createInstance("Removing...", "Do you really want to remove this instance?", new YESNOPopup.IYesNoListener(){

            @Override
            public void reactOnYes() {
                DynBeanUI.this.removeSubBean(comment);
            }

            @Override
            public void reactOnNo() {
            }
        });
    }

    public void onCreateGridItem(ActionEvent event) {
        String comment = ((BaseComponent)event.getComponent()).getAttributeValueAsString("comment");
        this.createGridItem(comment);
    }

    public void onMoveUpGridItem(ActionEvent event) {
        String comment = ((BaseComponent)event.getComponent()).getAttributeValueAsString("comment");
        this.moveUpSubBean(comment);
    }

    public void onMoveDownGridItem(ActionEvent event) {
        String comment = ((BaseComponent)event.getComponent()).getAttributeValueAsString("comment");
        this.moveDownSubBean(comment);
    }

    public void onPropertyAction(ActionEvent event) {
        if (event instanceof BaseActionEventValueHelp) {
            BaseActionEventValueHelp e = (BaseActionEventValueHelp)event;
            final String propertyName = e.getSourceComment();
            IdTextSelection idts = IdTextSelection.createInstance();
            for (IdText vv : this.m_extension.findValidValues(propertyName)) {
                idts.addLine(vv.getId(), vv.getText());
            }
            idts.setCallBack(new ISetId(){

                @Override
                public void setId(String id) {
                    DynBeanUI.passStringValueByReflection(DynBeanUI.this.m_bean, propertyName, id);
                }
            });
        }
    }

    private void setBeanClass(Class beanClass) {
        this.mm_beanClass = beanClass;
        this.m_piis = BeanIntrospector.readProperties(this.mm_beanClass);
        this.m_properties.clear();
        XmlType xmlType = this.mm_beanClass.getAnnotation(XmlType.class);
        if (xmlType != null) {
            String[] propOrder;
            for (String prop : propOrder = xmlType.propOrder()) {
                this.m_properties.add(prop);
            }
        } else {
            for (BeanIntrospector.PropertyIntrospectionInfo pii : this.m_piis.values()) {
                this.m_properties.add(pii.getPropertyName());
            }
        }
    }

    private void renderContent() {
        PANENode pane = new PANENode();
        pane.setRowdistance("5");
        pane.setWidth("100%");
        for (String property : this.m_properties) {
            COLDISTANCENode cd;
            FOLDABLEPANENode foldable;
            LABELNode label;
            ROWNode row;
            if ("class".equals(property)) continue;
            BeanIntrospector.PropertyIntrospectionInfo pii = this.m_piis.get(property);
            if (BeanIntrospector.checkIfSimpleDataType(pii.getGetter().getReturnType())) {
                row = new ROWNode();
                row.setRendered("#{cctd.DynBeanUI.objectAvailable}");
                pane.addSubNode(row);
                label = new LABELNode();
                row.addSubNode(label);
                label.setText(pii.getPropertyName());
                label.setWidth("120");
                ROWDYNAMICCONTENTBinding.ComponentNode propertyNode = this.createPropertyNode(pii, pii.getGetter().getReturnType(), "#{cctd.DynBeanUI.bean." + pii.getPropertyName() + "}", "#{cctd.DynBeanUI.onPropertyAction}", "100%;150");
                row.addSubNode(propertyNode);
                continue;
            }
            if (this.m_onlyResolveFirstLevel) continue;
            if (!Collection.class.isAssignableFrom(pii.getGetter().getReturnType()) && !Map.class.isAssignableFrom(pii.getGetter().getReturnType())) {
                row = new ROWNode();
                pane.addSubNode(row);
                row.setRendered("#{cctd.DynBeanUI.objectAvailable}");
                foldable = new FOLDABLEPANENode();
                row.addSubNode(foldable);
                foldable.setText(pii.getPropertyName());
                foldable.setWidth("100%");
                foldable.setStylevariant("CC_TITLE_ONLY");
                row = new ROWNode();
                foldable.addSubNode(row);
                cd = new COLDISTANCENode();
                row.addSubNode(cd);
                cd.setWidth("100%");
                LINKNode linkCreate = new LINKNode();
                row.addSubNode(linkCreate);
                linkCreate.setRendered("#{cctd.DynBeanUI.subDynBeans." + pii.getPropertyName() + ".objectNull}");
                linkCreate.setText("Create");
                linkCreate.setComment(pii.getPropertyName());
                linkCreate.setActionListener("#{cctd.DynBeanUI.onCreateSubBean}");
                LINKNode linkRemove = new LINKNode();
                row.addSubNode(linkRemove);
                linkRemove.setRendered("#{cctd.DynBeanUI.subDynBeans." + pii.getPropertyName() + ".objectAvailable}");
                linkRemove.setText("Remove");
                linkRemove.setComment(pii.getPropertyName());
                linkRemove.setActionListener("#{cctd.DynBeanUI.onRemoveSubBean}");
                Class<?> subClass = pii.getGetter().getReturnType();
                DynBeanUI dynBean = new DynBeanUI(pii.getGetter().getReturnType(), true, this.m_listener);
                this.m_subDynBeans.put(pii.getPropertyName(), dynBean);
                try {
                    dynBean.setBean(pii.getGetter().invoke(this.m_bean, null));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                ROWPAGEBEANINCLUDENode rpbinclude = new ROWPAGEBEANINCLUDENode();
                foldable.addSubNode(rpbinclude);
                rpbinclude.setPagebeanbinding("#{cctd.DynBeanUI.subDynBeans." + pii.getPropertyName() + "}");
                continue;
            }
            if (Map.class.isAssignableFrom(pii.getGetter().getReturnType())) {
                try {
                    row = new ROWNode();
                    row.setRendered("#{cctd.DynBeanUI.objectAvailable}");
                    pane.addSubNode(row);
                    label = new LABELNode();
                    row.addSubNode(label);
                    label.setText(pii.getPropertyName());
                    label.setWidth("120");
                    FIELDNode field = new FIELDNode();
                    field.setWidth("100%;150");
                    field.setText("#{cctd.DynBeanUI.mapStrings." + pii.getPropertyName() + ".oneString}");
                    row.addSubNode(field);
                    MapString mapString = new MapString();
                    this.m_mapStrings.put(pii.getPropertyName(), mapString);
                }
                catch (Throwable t) {
                    CLog.L.log(CLog.LL_ERR, "", t);
                }
                continue;
            }
            try {
                GRIDCOLNode gridCol;
                row = new ROWNode();
                pane.addSubNode(row);
                row.setRendered("#{cctd.DynBeanUI.objectAvailable}");
                foldable = new FOLDABLEPANENode();
                row.addSubNode(foldable);
                foldable.setText(pii.getPropertyName());
                foldable.setWidth("100%");
                foldable.setStylevariant("CC_TITLE_ONLY");
                row = new ROWNode();
                foldable.addSubNode(row);
                cd = new COLDISTANCENode();
                row.addSubNode(cd);
                cd.setWidth("120");
                FIXGRIDNode grid = new FIXGRIDNode();
                row.addSubNode(grid);
                grid.setWidth("100%");
                grid.setSbvisibleamount("10");
                grid.setBordercolor("#00000030");
                grid.setBorderwidth("1");
                grid.setBorderheight("1");
                grid.setObjectbinding("#{cctd.DynBeanUI.grids." + pii.getPropertyName() + "}");
                grid.setMultiselect("true");
                grid.setShowemptyrows("false");
                grid.setHorizontalscrollmode("autowithresize");
                Class genericType = this.findGenericClassInList(pii.getGetter());
                Grid gridBinding = null;
                if (!BeanIntrospector.checkIfSimpleDataType(genericType)) {
                    gridBinding = new Grid(GRIDTYPE_DEFAULT, pii.getPropertyName());
                    XmlType xt = genericType.getAnnotation(XmlType.class);
                    List<BeanIntrospector.PropertyIntrospectionInfo> itemPiis = BeanIntrospector.readPropertiesAsList(genericType);
                    if (xt != null && xt.propOrder() != null) {
                        itemPiis = new ArrayList<BeanIntrospector.PropertyIntrospectionInfo>();
                        Map<String, BeanIntrospector.PropertyIntrospectionInfo> itemPiisMap = BeanIntrospector.readProperties(genericType);
                        for (String propName : xt.propOrder()) {
                            itemPiis.add(itemPiisMap.get(propName));
                        }
                    }
                    for (BeanIntrospector.PropertyIntrospectionInfo itemPii : itemPiis) {
                        Class<?> itemPropertyClass = itemPii.getGetter().getReturnType();
                        if (!BeanIntrospector.checkIfSimpleDataType(itemPropertyClass)) continue;
                        GRIDCOLNode gridCol2 = new GRIDCOLNode();
                        grid.addSubNode(gridCol2);
                        gridCol2.setText(itemPii.getPropertyName());
                        ROWDYNAMICCONTENTBinding.ComponentNode propertyNode = this.createPropertyNode(itemPii, itemPii.getGetter().getReturnType(), ".{beanUI.bean." + itemPii.getPropertyName() + "}", ".{beanUI.onPropertyAction}", null);
                        gridCol2.addSubNode(propertyNode);
                        if (!"text".equals(itemPii.getPropertyName())) continue;
                        gridCol2.setWidth("100%;100");
                    }
                } else {
                    gridBinding = new Grid(GRIDTYPE_SIMPLEDATATYPE, pii.getPropertyName());
                    gridCol = new GRIDCOLNode();
                    grid.addSubNode(gridCol);
                    gridCol.setText("content");
                    gridCol.setWidth("100%");
                    ROWDYNAMICCONTENTBinding.ComponentNode propertyNode = this.createPropertyNode(pii, genericType, ".{value}", ".{onPropertyAction}", null);
                    gridCol.addSubNode(propertyNode);
                }
                gridCol = new GRIDCOLNode();
                grid.addSubNode(gridCol);
                gridCol.setWidth("50");
                BUTTONNode removeButton = new BUTTONNode();
                gridCol.addSubNode(removeButton);
                removeButton.setContentareafilled("false");
                removeButton.setText("Remove");
                removeButton.setActionListener(".{onRemove}");
                this.m_grids.put(pii.getPropertyName(), gridBinding);
                row = new ROWNode();
                foldable.addSubNode(row);
                cd = new COLDISTANCENode();
                row.addSubNode(cd);
                cd.setWidth("100%");
                LINKNode link = new LINKNode();
                row.addSubNode(link);
                link.setDoubleclickenabled("true");
                link.setText("Up");
                link.setComment(pii.getPropertyName());
                link.setActionListener("#{cctd.DynBeanUI.onMoveUpGridItem}");
                link.setImage("/eclntjsfserver/images/arrow_up_12.png");
                cd = new COLDISTANCENode();
                row.addSubNode(cd);
                cd.setWidth("5");
                link = new LINKNode();
                row.addSubNode(link);
                link.setDoubleclickenabled("true");
                link.setText("Down");
                link.setComment(pii.getPropertyName());
                link.setActionListener("#{cctd.DynBeanUI.onMoveDownGridItem}");
                link.setImage("/eclntjsfserver/images/arrow_down_12.png");
                cd = new COLDISTANCENode();
                row.addSubNode(cd);
                cd.setWidth("50");
                link = new LINKNode();
                row.addSubNode(link);
                link.setDoubleclickenabled("true");
                link.setText("Create Item");
                link.setComment(pii.getPropertyName());
                link.setActionListener("#{cctd.DynBeanUI.onCreateGridItem}");
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_ERR, "", t);
            }
        }
        this.m_content.setContentNode(pane);
    }

    private void removeSubBean(String propertyName) {
        try {
            BeanIntrospector.PropertyIntrospectionInfo pii = BeanIntrospector.readProperties(this.mm_beanClass).get(propertyName);
            pii.getSetter().invoke(this.m_bean, new Object[]{null});
            this.m_subDynBeans.get(propertyName).setBean(null);
            if (this.m_listener != null) {
                this.m_listener.reactOnDataUpdate(this.m_bean);
            }
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "", t);
        }
    }

    private void createSubBean(String propertyName) {
        try {
            BeanIntrospector.PropertyIntrospectionInfo pii = this.m_piis.get(propertyName);
            Class<?> propertyClass = pii.getGetter().getReturnType();
            Object bean = propertyClass.newInstance();
            if (bean instanceof BeanWithParent) {
                ((BeanWithParent)bean).passParent(this.m_bean);
            }
            pii.getSetter().invoke(this.m_bean, bean);
            this.m_subDynBeans.get(propertyName).setBean(bean);
            if (this.m_listener != null) {
                this.m_listener.reactOnDataUpdate(this.m_bean);
            }
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "", t);
        }
    }

    private void moveUpSubBean(String propertyName) {
        try {
            Grid grid = this.m_grids.get(propertyName);
            for (int i = 0; i < grid.getItems().size(); ++i) {
                GridItem gi = (GridItem)grid.getItems().get(i);
                if (!gi.getSelected()) continue;
                if (i == 0) {
                    return;
                }
                GridItem gim1 = (GridItem)grid.getItems().get(i - 1);
                grid.getItems().set(i - 1, gi);
                grid.getItems().set(i, gim1);
                Object bean = grid.i_list.get(i);
                Object beanm1 = grid.i_list.get(i - 1);
                grid.i_list.set(i - 1, bean);
                grid.i_list.set(i, beanm1);
            }
            if (this.m_listener != null) {
                this.m_listener.reactOnDataUpdate(this.m_bean);
            }
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, t.toString());
        }
    }

    private void moveDownSubBean(String propertyName) {
        try {
            Grid grid = this.m_grids.get(propertyName);
            for (int i = grid.getItems().size() - 1; i >= 0; --i) {
                GridItem gi = (GridItem)grid.getItems().get(i);
                if (!gi.getSelected()) continue;
                if (i == grid.getItems().size() - 1) {
                    return;
                }
                GridItem gip1 = (GridItem)grid.getItems().get(i + 1);
                grid.getItems().set(i + 1, gi);
                grid.getItems().set(i, gip1);
                Object bean = grid.i_list.get(i);
                Object beanp1 = grid.i_list.get(i + 1);
                grid.i_list.set(i + 1, bean);
                grid.i_list.set(i, beanp1);
            }
            if (this.m_listener != null) {
                this.m_listener.reactOnDataUpdate(this.m_bean);
            }
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, t.toString());
        }
    }

    private void createGridItem(String propertyName) {
        try {
            BeanIntrospector.PropertyIntrospectionInfo pii = BeanIntrospector.readProperties(this.mm_beanClass).get(propertyName);
            Class propertyClass = this.findGenericClassInList(pii.getGetter());
            Object bean = propertyClass.newInstance();
            if (bean instanceof BeanWithParent) {
                ((BeanWithParent)bean).passParent(this.m_bean);
            }
            List l = (List)pii.getGetter().invoke(this.m_bean, null);
            l.add(bean);
            Grid grid = this.m_grids.get(propertyName);
            GridItem gridItem = null;
            gridItem = grid.i_gridType == GRIDTYPE_DEFAULT ? new GridItem(grid, bean) : new GridItemSimpleDataType(grid, bean);
            grid.getItems().add(gridItem);
            grid.deselectCurrentSelection();
            grid.selectAndFocusItem(gridItem);
            if (this.m_listener != null && grid.i_gridType == GRIDTYPE_DEFAULT) {
                this.m_listener.reactOnDataUpdate(this.m_bean);
            }
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "", t);
        }
    }

    private Class findGenericClassInList(Method m) throws Exception {
        Type t = m.getGenericReturnType();
        if (t != null && t instanceof ParameterizedType) {
            Type[] types = ((ParameterizedType)t).getActualTypeArguments();
            return (Class)types[0];
        }
        return String.class;
    }

    private ROWDYNAMICCONTENTBinding.ComponentNode createPropertyNode(BeanIntrospector.PropertyIntrospectionInfo pii, Class c, String expression, String actionListenerExpression, String width) {
        if (c == Boolean.class || c == Boolean.TYPE) {
            CHECKBOXNode checkbox = new CHECKBOXNode();
            checkbox.setSelected(expression);
            return checkbox;
        }
        if (c == Integer.class || c == Integer.TYPE) {
            FORMATTEDFIELDNode node = new FORMATTEDFIELDNode();
            node.setValue(expression);
            node.setFormat("int");
            node.setAlign("right");
            if (width != null) {
                node.setWidth(width);
            } else {
                node.setWidth("100");
            }
            return node;
        }
        if (c == Long.class || c == Long.TYPE) {
            FORMATTEDFIELDNode node = new FORMATTEDFIELDNode();
            node.setValue(expression);
            node.setFormat("long");
            node.setAlign("right");
            if (width != null) {
                node.setWidth(width);
            } else {
                node.setWidth("100");
            }
            return node;
        }
        if (c == BigDecimal.class) {
            FORMATTEDFIELDNode node = new FORMATTEDFIELDNode();
            node.setValue(expression);
            node.setFormat("bigdecimal");
            node.setAlign("right");
            if (width != null) {
                node.setWidth(width);
            } else {
                node.setWidth("100");
            }
            return node;
        }
        boolean validValuesProvided = DynBeanUI.checkIfValidValuesAreProvided(pii);
        if (!validValuesProvided) {
            FIELDNode field = new FIELDNode();
            field.setText(expression);
            field.setConvertemptystringtonull("true");
            if (width != null) {
                field.setWidth(width);
            }
            return field;
        }
        COMBOFIELDNode field = new COMBOFIELDNode();
        field.setText(expression);
        field.setActionListener(actionListenerExpression);
        field.setComment(pii.getPropertyName());
        field.setConvertemptystringtonull("true");
        if (width != null) {
            field.setWidth(width);
        }
        return field;
    }

    private void initExtension() {
        try {
            String className = this.getBeanClass().getName();
            className = className + "UIExtension";
            Class c = CCClassResolver.resolveClass(className, ENUMCallerType.TOOLS);
            this.m_extension = (IExtension)c.newInstance();
        }
        catch (Throwable t) {
            this.m_extension = new DefaultExtension();
        }
    }

    private static void passStringValueByReflection(Object bean, String propertyName, String value) {
        try {
            BeanIntrospector.PropertyIntrospectionInfo pii = BeanIntrospector.readProperties(bean.getClass()).get(propertyName);
            pii.getSetter().invoke(bean, (Object[])new String[]{value});
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static boolean checkIfValidValuesAreProvided(BeanIntrospector.PropertyIntrospectionInfo pii) {
        CCPropertyInfo ccpi = pii.getGetter().getAnnotation(CCPropertyInfo.class);
        if (ccpi == null) {
            return false;
        }
        return ccpi.validValuesProvided();
    }

    public static interface IListener {
        public void reactOnDataUpdate(Object var1);
    }

    public static interface IExtension {
        public void init(Object var1);

        public List<IdText> findValidValues(String var1);
    }

    public class Grid
    extends FIXGRIDListBinding<GridItem> {
        List<Object> i_list;
        int i_gridType = 0;
        String i_propertyName;

        public Grid(int gridType, String propertyName) {
            this.i_gridType = gridType;
            this.i_propertyName = propertyName;
        }

        public void prepare(List<Object> list) {
            this.getItems().clear();
            this.i_list = list;
            for (Object o : list) {
                if (this.i_gridType == GRIDTYPE_DEFAULT) {
                    this.getItems().add(new GridItem(this, o));
                    continue;
                }
                this.getItems().add(new GridItemSimpleDataType(this, o));
            }
        }
    }

    public class MapString {
        Map<String, String> i_map;

        public void setMap(Map<String, String> map) {
            this.i_map = map;
        }

        public String getOneString() {
            if (this.i_map.size() == 0) {
                return "(Define parameters in the way: key1:value1;key2:value2)";
            }
            return ValueManager.encodeComplexValue(this.i_map);
        }

        public void setOneString(String value) {
            Map<String, String> newMap = ValueManager.decodeComplexValue(value);
            this.i_map.clear();
            for (String key : newMap.keySet()) {
                this.i_map.put(key, newMap.get(key));
            }
        }
    }

    public static class IdText {
        String i_id;
        String i_text;

        public IdText(String id, String text) {
            this.i_id = id;
            this.i_text = text;
        }

        public String getId() {
            return this.i_id;
        }

        public String getText() {
            return this.i_text;
        }
    }

    public class GridItem
    extends FIXGRIDItem {
        GridItem i_this = this;
        Grid i_grid;
        Object i_bean;
        DynBeanUI i_beanUI;

        public GridItem(Grid grid, Object bean) {
            this.i_grid = grid;
            this.i_bean = bean;
            if (this.i_bean != null) {
                this.i_beanUI = new DynBeanUI(this.i_bean.getClass(), true, null);
                this.i_beanUI.setBean(this.i_bean);
            }
        }

        public Object getBean() {
            return this.i_bean;
        }

        public DynBeanUI getBeanUI() {
            return this.i_beanUI;
        }

        public void onRemove(ActionEvent event) {
            YESNOPopup.createInstance("Removing...", "Do you really want to remove this instance?", new YESNOPopup.IYesNoListener(){

                @Override
                public void reactOnYes() {
                    GridItem.this.i_grid.getItems().remove(GridItem.this.i_this);
                    GridItem.this.i_grid.i_list.remove(GridItem.this.i_bean);
                    if (DynBeanUI.this.m_listener != null) {
                        DynBeanUI.this.m_listener.reactOnDataUpdate(DynBeanUI.this.m_bean);
                    }
                }

                @Override
                public void reactOnNo() {
                }
            });
        }
    }

    public class GridItemSimpleDataType
    extends GridItem {
        GridItem i_this;
        Grid i_grid;
        Object i_value;

        public GridItemSimpleDataType(Grid grid, Object value) {
            super(null, null);
            this.i_this = this;
            this.i_grid = grid;
            this.i_value = value;
        }

        public Object getValue() {
            return this.i_value;
        }

        public void setValue(Object value) {
            this.i_value = value;
            int index = this.i_grid.getItems().indexOf(this);
            this.i_grid.i_list.set(index, this.i_value);
        }

        @Override
        public void onRemove(ActionEvent event) {
            YESNOPopup.createInstance("Removing...", "Do you really want to remove this instance?", new YESNOPopup.IYesNoListener(){

                @Override
                public void reactOnYes() {
                    GridItemSimpleDataType.this.i_grid.getItems().remove(GridItemSimpleDataType.this.i_this);
                    GridItemSimpleDataType.this.i_grid.i_list.remove(GridItemSimpleDataType.this.i_value);
                }

                @Override
                public void reactOnNo() {
                }
            });
        }

        public void onPropertyAction(ActionEvent event) {
            if (event instanceof BaseActionEventValueHelp) {
                String propertyName = this.i_grid.i_propertyName;
                IdTextSelection idts = IdTextSelection.createInstance();
                for (IdText vv : DynBeanUI.this.m_extension.findValidValues(propertyName)) {
                    idts.addLine(vv.getId(), vv.getText());
                }
                idts.setCallBack(new ISetId(){

                    @Override
                    public void setId(String id) {
                        GridItemSimpleDataType.this.i_value = id;
                    }
                });
            }
        }
    }

    public static class DefaultExtension
    implements IExtension {
        @Override
        public void init(Object bean) {
        }

        @Override
        public List<IdText> findValidValues(String propertyName) {
            ArrayList<IdText> result = new ArrayList<IdText>();
            result.add(new IdText("notSupported", "Not supported"));
            return result;
        }
    }
}

