/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.session;

import org.eclnt.jsfserver.elements.ThreadData;
import org.eclnt.jsfserver.session.SessionInfo;
import org.eclnt.jsfserver.session.UsageWithoutSessionContext;
import org.eclnt.util.log.CLog;

public class RequestFocusManager {
    public static final String REQFOCUS_CREATION = "creation";
    public static final long REQFOCUS_CREATION_LONG = -100L;

    public static void blockFocusMgmtForThisRequest() {
        try {
            ThreadData td = ThreadData.getInstance();
            td.setRequestFocusMgmtBlocked(true);
        }
        catch (Throwable t) {
            if (UsageWithoutSessionContext.isUsedWithoutSessionContext()) {
                return;
            }
            CLog.L.log(CLog.LL_ERR, "Could not block focus management for this request", t);
        }
    }

    public static long getNewRequestFocusCounter() {
        try {
            ThreadData td = ThreadData.getInstance();
            if (td.isRequestFocusMgmtBlocked()) {
                return -1L;
            }
        }
        catch (Throwable t) {
            if (UsageWithoutSessionContext.isUsedWithoutSessionContext()) {
                return 0L;
            }
            CLog.L.log(CLog.LL_ERR, "Could not get to ThreadData within request processing", t);
        }
        return SessionInfo.getSessionInstance().getNewRequestFocusCounter();
    }

    public static long getNewRequestFocusInWindowCounter() {
        return RequestFocusManager.getNewRequestFocusCounter() + 1L;
    }

    public static long getCreationRequestFocusCounter() {
        return -100L;
    }
}

