/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.starter;

import com.veracode.annotation.XSSCleanser;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import org.eclnt.jsfserver.managedbean.HotDeployManager;
import org.eclnt.jsfserver.starter.RISCStarter;
import org.eclnt.jsfserver.util.CCServletBase;
import org.eclnt.jsfserver.util.ServletUtil;
import org.eclnt.jsfserver.util.SystemXml;
import org.eclnt.util.file.ClassloaderReader;
import org.eclnt.util.log.CLog;
import org.eclnt.util.mitigation.CCMitigation;
import org.eclnt.util.valuemgmt.UniqueIdCreator;
import org.eclnt.util.valuemgmt.ValueManager;
import org.owasp.esapi.ESAPI;

@CCMitigation(cweIds={}, comment="This class is only used when using the \"old\" Java Swing client as rendering client. If not using the Swing client, then you should use the \"slim\" version of CaptainCasa Enterprise Client, that only provides the HTML client. In this \"slim\" version this class is not delivered anymore.")
public class AppletStarter
extends CCServletBase {
    private static boolean ESAPI_SWITCHED_ON = false;
    private static final int PAGETYPE_APPLET = 0;
    private static final int PAGETYPE_WEBSTART = 1;
    private static final int PAGETYPE_WEBSTARTFX = 3;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String method = req.getMethod();
        if ("GET".equals(method)) {
            ServletUtil.ensureServletGetIsAllowed(((Object)((Object)this)).getClass());
        }
        CLog.L.log(CLog.LL_INF, "Applet/Webstart request is started");
        CLog.L.log(CLog.LL_INF, "The http session id is: " + req.getSession().getId());
        RISCStarter.resetBuffers(req);
        String cctemplate = req.getParameter("cctemplate");
        String ccsamesession = req.getParameter("ccsamesession");
        String cclibs = req.getParameter("cclibs");
        String cctransfercookies = req.getParameter("cctransfercookies");
        String req_codebase = req.getParameter("cccodebase");
        if (cclibs == null && SystemXml.getCcappletccwebstartcclibs() != null) {
            cclibs = SystemXml.getCcappletccwebstartcclibs();
        }
        String ccstyle = req.getParameter("ccstyle");
        String ccsplashimage = req.getParameter("ccsplashimage");
        String ccclientid = null;
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals("eclnt-id")) continue;
                ccclientid = cookie.getValue();
                break;
            }
        }
        if (ccclientid == null) {
            ccclientid = UniqueIdCreator.createUUID();
            ServletUtil.writeEclntIdCookie(resp, ccclientid);
        }
        if (ccsplashimage == null) {
            ccsplashimage = SystemXml.getCcappletccwebstartsplashimage();
        }
        if (ccsplashimage == null) {
            ccsplashimage = "eclnt/images/splash.png";
        }
        String appletlibs = "";
        String webstartlibs = "";
        ArrayList<String> libs = new ArrayList<String>();
        ArrayList<String> nativelibs = new ArrayList<String>();
        if (cclibs != null) {
            if (cclibs.contains("swt") || cclibs.equals("all")) {
                libs.add("eclnt/lib/swt.jar");
                nativelibs.add("eclnt/lib/swt.jar");
            }
            if (cclibs.contains("pdf") || cclibs.equals("all")) {
                libs.add("eclnt/lib/PDFRenderer.jar");
            }
            if (cclibs.contains("jasperreports") || cclibs.equals("all")) {
                libs.add("eclnt/lib/jasperreports.jar");
                libs.add("eclnt/lib/commons-beanutils.jar");
                libs.add("eclnt/lib/commons-collections.jar");
                libs.add("eclnt/lib/commons-digester.jar");
                libs.add("eclnt/lib/commons-javaflow.jar");
                libs.add("eclnt/lib/commons-logging.jar");
                libs.add("eclnt/lib/commons-logging-api.jar");
            }
            if (cclibs.contains("jasperreportsall") || cclibs.equals("all")) {
                libs.add("eclnt/lib/iText.jar");
                libs.add("eclnt/lib/poi.jar");
            }
            if (cclibs.contains("simplehtmleditor")) {
                libs.add("eclnt/lib/eclnt_simplyhtml.jar");
            }
            if (cclibs.contains("comm") || cclibs.equals("all")) {
                libs.add("eclnt/lib/commapi.jar");
            }
            if (cclibs.contains("jssc") || cclibs.equals("all")) {
                libs.add("eclnt/lib/jssc.jar");
            }
            if (cclibs.contains("osm") || cclibs.equals("all")) {
                libs.add("eclnt/lib/swingx-core.jar");
                libs.add("eclnt/lib/swingx-ws.jar");
            }
            if (cclibs.contains("jfreechart") || cclibs.equals("all")) {
                libs.add("eclnt/lib/jfreechart.jar");
                libs.add("eclnt/lib/jcommon.jar");
            }
            if (cclibs.contains("batik") || cclibs.equals("all")) {
                libs.add("eclnt/lib/batikcc.jar");
            }
            if (cclibs.contains("jpedal") || cclibs.equals("all")) {
                libs.add("eclnt/lib/jpedal.jar");
            }
        }
        for (String lib : libs) {
            appletlibs = appletlibs + "," + lib;
            webstartlibs = webstartlibs + "<jar href=\"" + this.ESAPIencodeForXMLAttribute(lib) + "\"/>\n";
        }
        for (String lib : nativelibs) {
            webstartlibs = webstartlibs + "<nativelib href=\"" + this.ESAPIencodeForXMLAttribute(lib) + "\"/>\n";
        }
        StringBuffer clientparamsApplet = new StringBuffer();
        StringBuffer clientparamsWebstart = new StringBuffer();
        for (SystemXml.ClientParam cp : SystemXml.getCcappletccwebstartclientparams()) {
            clientparamsApplet.append("<param name='" + this.ESAPIencodeForXMLAttribute(cp.getName()) + "' value='" + this.ESAPIencodeForXMLAttribute(cp.getValue()) + "'>");
            clientparamsWebstart.append("<argument>" + this.ESAPIencodeForXMLAttribute(cp.getName()) + "=" + this.ESAPIencodeForXMLAttribute(cp.getValue()) + "</argument>");
        }
        if ("true".equals(cctransfercookies) && cookies != null) {
            for (Cookie cookie : cookies) {
                String name = "http-cookie:" + cookie.getName();
                if (name.toLowerCase().contains("jsessionid")) continue;
                String value = cookie.getValue();
                clientparamsApplet.append("<param name='" + this.ESAPIencodeForXMLAttribute(name) + "' value='" + this.ESAPIencodeForXMLAttribute(value) + "'>");
                clientparamsWebstart.append("<argument>" + this.ESAPIencodeForXMLAttribute(name) + "=" + this.ESAPIencodeForXMLAttribute(value) + "</argument>");
            }
        }
        try {
            Enumeration paramNames = req.getParameterNames();
            while (paramNames.hasMoreElements()) {
                String paramName = (String)paramNames.nextElement();
                String paramValue = req.getParameter(paramName);
                if (paramValue == null) continue;
                if (paramName.startsWith("http-cookie:")) {
                    clientparamsApplet.append("<param name='" + this.ESAPIencodeForXMLAttribute(paramName) + "' value='" + this.ESAPIencodeForXMLAttribute(paramValue) + "'>");
                    clientparamsWebstart.append("<argument>" + this.ESAPIencodeForXMLAttribute(paramName) + "=" + this.ESAPIencodeForXMLAttribute(paramValue) + "</argument>");
                }
                if (!paramName.startsWith("client-param:")) continue;
                String clientParamName = paramName.substring("client-param:".length());
                clientparamsApplet.append("<param name='" + this.ESAPIencodeForXMLAttribute(clientParamName) + "' value='" + this.ESAPIencodeForXMLAttribute(paramValue) + "'>");
                clientparamsWebstart.append("<argument>" + this.ESAPIencodeForXMLAttribute(clientParamName) + "=" + this.ESAPIencodeForXMLAttribute(paramValue) + "</argument>");
            }
        }
        catch (Throwable paramNames) {
            // empty catch block
        }
        int pageType = 0;
        String uri = req.getRequestURI();
        if (uri.endsWith(".ccapplet")) {
            uri = uri.substring(0, uri.length() - ".ccapplet".length());
            pageType = 0;
        } else if (uri.endsWith(".ccwebstart")) {
            uri = uri.substring(0, uri.length() - ".ccwebstart".length());
            pageType = 1;
        } else if (uri.endsWith(".ccwebstartfx")) {
            uri = uri.substring(0, uri.length() - ".ccwebstartfx".length());
            pageType = 3;
        }
        int uriLastSlashIndex = uri.lastIndexOf(47);
        String page = uri = uri.substring(0, uriLastSlashIndex) + uri.substring(uriLastSlashIndex).replace('.', '/');
        int secondSlash = page.indexOf(47, 1);
        page = page.substring(secondSlash + 1);
        page = page + ".jsp";
        page = ValueManager.encodeIntoValidURL(page);
        if (pageType == 0) {
            ServletUtil.setResponseContentType(resp, "text/html");
        } else {
            ServletUtil.setResponseContentType(resp, "application/x-java-jnlp-file");
        }
        if (cctemplate == null) {
            switch (pageType) {
                case 0: {
                    cctemplate = SystemXml.getStarttemplateCcapplet();
                    break;
                }
                case 1: {
                    cctemplate = SystemXml.getStarttemplateCcwebstart();
                    break;
                }
                case 3: {
                    cctemplate = SystemXml.getStarttemplateCcwebstartFX();
                }
            }
        }
        CLog.L.log(CLog.LL_INF, "Template that is used: " + cctemplate);
        String template = new ClassloaderReader(HotDeployManager.currentClassLoader()).readUTF8File(cctemplate, true);
        if (req.getQueryString() != null && req.getQueryString().length() > 0) {
            String qs = req.getQueryString();
            qs = qs.replace("&", "&amp;");
            page = page + "?" + qs;
        }
        if (page.startsWith("/")) {
            page = page.substring(1);
        }
        if (ccstyle != null) {
            page = req.getQueryString() != null && req.getQueryString().length() > 0 ? page + "&amp;ccstyle=" + ccstyle : page + "?ccstyle=" + ccstyle;
        }
        if ("true".equals(ccsamesession)) {
            HttpSession ses = req.getSession();
            page = ServletUtil.encodeURL(page, req, resp);
            ses.setAttribute("ccsamesession", (Object)"true");
        }
        template = pageType == 1 || pageType == 3 ? template.replace("@@pagename@@", this.ESAPIencodeForXML(page)) : template.replace("@@pagename@@", this.ESAPIencodeForHTMLAttribute(page));
        template = template.replace("@@appletlibs@@", this.ESAPIencodeForHTMLAttribute(appletlibs));
        template = template.replace("@@webstartlibs@@", webstartlibs);
        template = template.replace("@@splashimage@@", this.ESAPIencodeForHTMLAttribute(ccsplashimage));
        template = template.replace("@@clientid@@", this.ESAPIencodeForHTMLAttribute(ccclientid));
        template = pageType == 0 ? template.replace("@@clientparams@@", clientparamsApplet.toString()) : template.replace("@@clientparams@@", clientparamsWebstart.toString());
        if (pageType == 1 || pageType == 3) {
            if (req_codebase == null) {
                req_codebase = this.calculateCodeBase(req);
            }
            template = template.replace("$$codebase", this.ESAPIencodeForHTMLAttribute(req_codebase));
        }
        CLog.L.log(CLog.LL_INF, "HTML for applet / web start is:\n\n" + template + "\n\n");
        this.writeUpdatedTemplateToRespone(resp, template);
    }

    protected String calculateCodeBase(HttpServletRequest req) {
        String url = req.getRequestURL().toString();
        int index = url.lastIndexOf(63);
        if (index > 0) {
            url = url.substring(0, index);
        }
        index = url.lastIndexOf(47);
        String codeBase = url.substring(0, index + 1);
        return codeBase;
    }

    private String ESAPIencodeForXML(String value) {
        if (!ESAPI_SWITCHED_ON) {
            return value;
        }
        return ESAPI.encoder().encodeForXML(value);
    }

    private String ESAPIencodeForXMLAttribute(String value) {
        if (!ESAPI_SWITCHED_ON) {
            return value;
        }
        return ESAPI.encoder().encodeForXMLAttribute(value);
    }

    private String ESAPIencodeForHTMLAttribute(String value) {
        if (!ESAPI_SWITCHED_ON) {
            return value;
        }
        return ESAPI.encoder().encodeForHTMLAttribute(value);
    }

    @XSSCleanser(userComment="The HTML page that is returned is based on a template in which certain replacements are done. The template must be part of the resources of the own application - it is not e.g. possible to use some extenral template (e.g. by referecning a URL). Each of the replacements that is done, is using ESAPI.encoder().encodeForHTMLAttribute() or ESAPI.encoder().encodeForHTMLAttribute() so that only encoded content is passed into the template.")
    private void writeUpdatedTemplateToRespone(HttpServletResponse resp, String template) throws IOException {
        resp.getWriter().write(template);
    }
}

