/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.starter;

import jakarta.servlet.http.HttpServletRequest;
import java.util.HashSet;
import java.util.Set;
import org.eclnt.jsfserver.starter.IStartPageChecker;
import org.eclnt.jsfserver.util.ServletUtil;
import org.eclnt.jsfserver.util.SystemXml;
import org.eclnt.util.valuemgmt.ValueManager;

public class DefaultStartPageChecker
implements IStartPageChecker {
    Set<String> m_excludedPages = new HashSet<String>();
    Set<String> m_allowedPages = new HashSet<String>();

    public DefaultStartPageChecker() {
        this.addExcludedPages();
        this.addAllowedPages();
    }

    @Override
    public boolean checkIfPageCanBeDirectlyStarted(HttpServletRequest startRequest, String page) {
        if (ServletUtil.checkIfRISCUrlStartedInDevelopmentMode(startRequest)) {
            return this.checkPageInDevMode(startRequest, page);
        }
        return this.checkPageInProductionMode(startRequest, page);
    }

    protected void addExcludedPages() {
        this.addFixExcludedPages();
        this.addSystemXmlExcludedPages();
    }

    protected void addFixExcludedPages() {
        this.m_excludedPages.add("/eclntjsfserver/includes/");
        this.m_excludedPages.add("/eclntjsfserver/popups/");
    }

    protected void addSystemXmlExcludedPages() {
        for (SystemXml.PageInfo pi : SystemXml.getExcludeStartPages()) {
            this.m_excludedPages.add(pi.getPage());
        }
    }

    protected void addAllowedPages() {
        this.addFixAllowedPages();
        this.addSystemXmlAllowedPages();
    }

    protected void addSystemXmlAllowedPages() {
        for (SystemXml.PageInfo pi : SystemXml.getAllowStartPages()) {
            this.m_allowedPages.add(pi.getPage());
        }
    }

    protected void addFixAllowedPages() {
    }

    protected boolean checkPageInProductionMode(HttpServletRequest startRequest, String page) {
        if (this.m_allowedPages.size() > 0) {
            boolean result = false;
            for (String allowedPage : this.m_allowedPages) {
                if (!ValueManager.checkIfStringMatchesAsteriskExpression(page, allowedPage, false)) continue;
                result = true;
            }
            if (!result) {
                return false;
            }
        }
        for (String excludedPage : this.m_excludedPages) {
            if (!ValueManager.checkIfStringMatchesAsteriskExpression(page, excludedPage, false)) continue;
            return false;
        }
        return true;
    }

    protected boolean checkPageInDevMode(HttpServletRequest startRequest, String page) {
        return true;
    }
}

