/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.streamstore.personalization;

import java.util.HashMap;
import java.util.Map;
import org.eclnt.jsfserver.streamstore.personalization.PersonalizedValue;
import org.eclnt.jsfserver.util.IPropertyTypeResolver;

public class PersonalizedValueMap
extends HashMap<String, String>
implements IPropertyTypeResolver {
    String m_valuePrefix;
    Map<String, PersonalizedValue> m_personalizedValues = new HashMap<String, PersonalizedValue>();

    public PersonalizedValueMap(String valuePrefix) {
        this.m_valuePrefix = valuePrefix;
    }

    @Override
    public String get(Object key) {
        PersonalizedValue pv = this.m_personalizedValues.get(key.toString());
        if (pv == null) {
            pv = new PersonalizedValue(this.m_valuePrefix + key.toString(), null);
            this.m_personalizedValues.put(key.toString(), pv);
        }
        return pv.getValue();
    }

    @Override
    public String put(String key, String value) {
        String previousValue = null;
        PersonalizedValue pv = this.m_personalizedValues.get(key.toString());
        if (pv == null) {
            pv = new PersonalizedValue(this.m_valuePrefix + key, null);
            this.m_personalizedValues.put(key, pv);
        } else {
            previousValue = pv.getValue();
        }
        pv.setValue(value);
        return previousValue;
    }

    @Override
    public Class resolveType(String propertyName) {
        return String.class;
    }
}

