/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.tools;

import java.io.StringReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.SAXParser;
import org.eclnt.jsfserver.elements.ComponentRepository;
import org.eclnt.jsfserver.elements.ICCComponentProperties;
import org.eclnt.jsfserver.session.UsageWithoutSessionContext;
import org.eclnt.jsfserver.util.parse.SAXParserCreator;
import org.eclnt.util.file.ClassloaderReader;
import org.eclnt.util.file.FileManager;
import org.eclnt.util.valuemgmt.ValueManager;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CreateComponentNodeClasses
implements ICCComponentProperties {
    static Map<String, TagInfo> ATTRIBUTES = new HashMap<String, TagInfo>();
    static String s_workspace = "C:/bmu_jtc/git/";
    static String s_prefix = "t";
    static String s_tldFile = s_workspace + "eclnt_jsfserver/WebContent/WEB-INF/eclnt.tld";
    static String s_controlAttributeInfoFile = s_workspace + "eclnt_jsfserver/src/org/eclnt/jsfserver/elements/impl/resources/controlattributeinfo.xml";
    static String s_basedirWS = s_workspace + "eclnt_jsfserver/src/org/eclnt/jsfserver/elements/componentnodes/";
    static String s_packageNodeClasses = "org.eclnt.jsfserver.elements.componentnodes";
    static Set<String> s_alwaysIntAttributes = new HashSet<String>();
    static String s_basedirScWS = s_workspace + "eclnt_jsfserver/src/org/eclnt/jsfserver/elements/impl/selfcontaining/";

    private static void parseControlAttributeInfoFile() {
        try {
            String xml = FileManager.readUTF8File(s_controlAttributeInfoFile, true);
            SAXParser parser = SAXParserCreator.createSAXParser();
            InputSource is = new InputSource(new StringReader(xml));
            parser.parse(is, (DefaultHandler)new ControAttributeInfoParser());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            if (args != null && args.length == 5) {
                s_prefix = args[0];
                s_tldFile = args[1];
                s_controlAttributeInfoFile = args[2];
                s_basedirWS = args[3];
                s_packageNodeClasses = args[4];
            } else if (args != null && args.length > 0) {
                throw new Error("5 parameters to be passed!");
            }
            UsageWithoutSessionContext.initUsageWithoutSessionContext();
            CreateComponentNodeClasses.parseControlAttributeInfoFile();
            ComponentRepository.TLDInfo tldInfo = new ComponentRepository.TLDInfo(s_prefix, s_tldFile, "dummy", "dummy");
            ComponentRepository.registerLibrary(tldInfo);
            Collection<ComponentRepository.ComponentInfo> cis = ComponentRepository.getInstance(s_prefix).getComponentInfos();
            for (ComponentRepository.ComponentInfo ci : cis) {
                CreateComponentNodeClasses.generateComponentNodeClass(ci);
            }
            System.out.println("FINISHED");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static void generateComponentNodeClass(ComponentRepository.ComponentInfo ci) {
        System.out.println("Processing component: " + ci.getTagName());
        String TEMPLATE_SET = "    public @@Class@@ set@@Attribute@@(String value) { addAttribute(\"@@attribute@@\",value); return this; }\n";
        String TEMPLATE_SET_INT = "    public @@Class@@ set@@Attribute@@(int value) { addAttribute(\"@@attribute@@\",\"\"+value); return this; }\n";
        String TEMPLATE_SET_BOOLEAN = "    public @@Class@@ set@@Attribute@@(boolean value) { addAttribute(\"@@attribute@@\",\"\"+value); return this; }\n";
        String cnTemplate = CreateComponentNodeClasses.generateComponentNodeClassBody(ci);
        StringBuffer cnContent = new StringBuffer();
        List<String> attributes = ci.getAttibutesInclActions(true);
        if (!attributes.contains("id")) {
            attributes.add(0, "id");
        }
        for (String attribute : attributes) {
            TagInfo ti;
            String Attribute = ValueManager.toUpperCaseId(attribute.substring(0, 1)) + attribute.substring(1);
            String s = TEMPLATE_SET;
            s = s.replace("@@Attribute@@", Attribute);
            s = s.replace("@@attribute@@", attribute);
            cnContent.append(s);
            if (!(attribute.equals(ATT_ID) || attribute.equals(ATT_attributemacro) || attribute.equals(ATT_REFERENCE) || attribute.equals(ATT_COMPONENTBINDING))) {
                s = s.replace(" set", " bind");
                s = attribute.equals(ATT_ACTIONLISTENER) ? s.replace("(String value)", "(IActionListenerDelegation value)") : (attribute.equals(ATT_ADAPTERBINDING) ? s.replace("(String value)", "(IComponentAdapterBinding value)") : (attribute.equals(ATT_pagebeanbinding) ? s.replace("(String value)", "(IPageBean value)") : (attribute.equals(ATT_OBJECTBINDING) && ci.getTagName().contains("grid") ? s.replace("(String value)", "(IFIXGRIDBinding value)") : s.replace("(String value)", "(IDynamicContentBindingObject value)"))));
                cnContent.append(s);
            }
            if ((ti = ATTRIBUTES.get(attribute)) != null) {
                String s2;
                ti = CreateComponentNodeClasses.resolveInheritance(ti);
                if (ti.i_regex != null && ti.i_regex.contains("[\\d]")) {
                    s2 = TEMPLATE_SET_INT;
                    s2 = s2.replace("@@Attribute@@", Attribute);
                    s2 = s2.replace("@@attribute@@", attribute);
                    cnContent.append(s2);
                }
                if (ti.i_regex != null && ti.i_regex.contains("true|false")) {
                    s2 = TEMPLATE_SET_BOOLEAN;
                    s2 = s2.replace("@@Attribute@@", Attribute);
                    s2 = s2.replace("@@attribute@@", attribute);
                    cnContent.append(s2);
                }
            }
            cnContent.append("\n");
        }
        cnTemplate = cnTemplate.replace("@@setget@@", cnContent.toString());
        String className = CreateComponentNodeClasses.findComponentNodeClassName(ci);
        cnTemplate = cnTemplate.replace("@@Class@@", className);
        FileManager.writeUTF8File(s_basedirWS + className + ".java", cnTemplate, true);
    }

    private static String generateComponentNodeClassBody(ComponentRepository.ComponentInfo ci) {
        String template = new ClassloaderReader().readUTF8File("org/eclnt/jsfserver/tools/CreateComponentNodeClassesTemplate.java_template", true);
        String className = CreateComponentNodeClasses.findComponentNodeClassName(ci);
        template = template.replace("@@classname@@", className);
        template = template.replace("@@tagname@@", ci.getTagName());
        template = template.replace("@@package@@", s_packageNodeClasses);
        template = template.replace("@@prefix@@", s_prefix);
        return template;
    }

    private static String findComponentNodeClassName(ComponentRepository.ComponentInfo ci) {
        String result = ValueManager.toUpperCaseId(ci.getTagName()) + "Node";
        if (!"t".equals(s_prefix)) {
            result = s_prefix.toUpperCase() + "_" + result;
        }
        return result;
    }

    private static TagInfo resolveInheritance(TagInfo ti) {
        if (ti.i_inheritFrom == null) {
            return ti;
        }
        TagInfo parent = ATTRIBUTES.get(ti.i_inheritFrom);
        return CreateComponentNodeClasses.resolveInheritance(parent);
    }

    static {
        s_alwaysIntAttributes.add("x");
        s_alwaysIntAttributes.add("y");
        s_alwaysIntAttributes.add("width");
        s_alwaysIntAttributes.add("height");
    }

    static class ControAttributeInfoParser
    extends DefaultHandler {
        ControAttributeInfoParser() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("attribute")) {
                TagInfo tagInfo = new TagInfo(attributes.getValue("name"), attributes.getValue("inheritfrom"), attributes.getValue("regex"));
            }
        }
    }

    static class TagInfo {
        String i_tagName;
        String i_inheritFrom;
        String i_regex;

        public TagInfo(String tagName, String inheritFrom, String regex) {
            this.i_tagName = tagName;
            this.i_inheritFrom = inheritFrom;
            this.i_regex = regex;
            ATTRIBUTES.put(tagName, this);
        }
    }
}

