/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletResponse;
import org.eclnt.jsfserver.util.CCInitialize;
import org.eclnt.jsfserver.util.ServletUtil;

public abstract class CCServletBase
extends HttpServlet {
    public void init() throws ServletException {
        super.init();
        if (this.checkIfToInitializeCCEnvironment()) {
            CCInitialize.initializeCCEnvironment(this.getServletContext());
        }
    }

    protected boolean checkIfToInitializeCCEnvironment() {
        return true;
    }

    protected void setContentType(String uri, HttpServletResponse resp) {
        String extension = null;
        int index = uri.lastIndexOf(".");
        if (index >= 0) {
            extension = uri.substring(index + 1);
        }
        String contentType = this.proposeContentType(extension);
        this.setContentTypeInResponse(contentType, resp);
    }

    protected void setContentTypeInResponse(String contentType, HttpServletResponse resp) {
        if (contentType == null) {
            return;
        }
        ServletUtil.setResponseContentType(resp, contentType);
        if (contentType.contains("application/octet")) {
            ServletUtil.setResponseHeader(resp, "Content-Disposition", "attachment");
        }
    }

    protected String proposeContentType(String extension) {
        return ServletUtil.proposeContentType(extension);
    }
}

