/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import org.eclnt.jsfserver.base.faces.FactoryFinder;
import org.eclnt.jsfserver.base.faces.context.FacesContext;
import org.eclnt.jsfserver.base.faces.context.FacesContextFactory;
import org.eclnt.jsfserver.base.faces.lifecycle.Lifecycle;
import org.eclnt.jsfserver.base.faces.lifecycle.LifecycleFactory;
import org.eclnt.jsfserver.elements.ThreadData;
import org.eclnt.jsfserver.util.CCServletBase;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.ICCServerConstants;
import org.eclnt.jsfserver.util.ServletUtil;
import org.eclnt.util.log.CLog;

public abstract class CCServletBaseWithContextMgmt
extends CCServletBase
implements ICCServerConstants {
    private FacesContextFactory m_facesContextFactory;
    private Lifecycle m_lifecycle;

    @Override
    public final void init() throws ServletException {
        super.init();
        try {
            LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory("org.eclnt.jsfserver.base.faces.lifecycle.LifecycleFactory");
            this.m_facesContextFactory = (FacesContextFactory)FactoryFinder.getFactory("org.eclnt.jsfserver.base.faces.context.FacesContextFactory");
            this.m_lifecycle = lifecycleFactory.getLifecycle("DEFAULT");
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problems in init() of BufferedContentServlet - only relevant if accessing FacesContext during servlet processing", t);
        }
    }

    protected final void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.manageRequest(req, resp);
    }

    protected final void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.manageRequest(req, resp);
    }

    private void manageRequest(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HttpSession session = req.getSession(false);
        if (session == null && this.checkIfToAbortOnMissingHttpSession(req)) {
            CLog.L.log(CLog.LL_WAR, "Server side processing not possible without http session being associated: " + this.getClass().getName());
            throw new Error("Server side processing not possible without http session being associated: " + this.getClass().getName());
        }
        FacesContext context = null;
        try {
            ThreadData threadData = ThreadData.getInstance();
            threadData.initHttpSession(session);
            if (session != null) {
                String method = req.getMethod();
                if ("GET".equals(method)) {
                    ServletUtil.ensureServletGetIsAllowed(this.getClass());
                }
                threadData.initHttpSession(session);
                try {
                    context = this.m_facesContextFactory.getFacesContext(this.getServletContext(), req, resp, this.m_lifecycle);
                    FacesContext facesContext = HttpSessionAccess.getCurrentFacesContext();
                }
                catch (Throwable t) {
                    CLog.L.log(CLog.LL_INF, "Problems in init() of BufferedContentServlet - only relevant if accessing FacesContext during servlet processing", t);
                }
                String subpageId = req.getParameter("cc_subpageId");
                if (subpageId == null) {
                    subpageId = (String)session.getAttribute("urlencodingsubpageid");
                }
                if (subpageId != null) {
                    threadData.initSubpageId(subpageId);
                }
            }
            this.processRequest(req, resp);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problem during servlet processing", t);
            if (t instanceof ServletException) {
                throw (ServletException)t;
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new Error(t);
        }
        finally {
            if (context != null) {
                context.release();
            }
        }
    }

    protected abstract void processRequest(HttpServletRequest var1, HttpServletResponse var2) throws ServletException, IOException;

    protected abstract boolean checkIfToAbortOnMissingHttpSession(HttpServletRequest var1);
}

