/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import org.eclnt.jsfserver.base.faces.application.StateManager;
import org.eclnt.jsfserver.base.faces.component.UIViewRoot;
import org.eclnt.jsfserver.base.faces.context.FacesContext;
import org.eclnt.jsfserver.elements.ThreadData;
import org.eclnt.jsfserver.util.CCSessionState;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.SystemXml;
import org.eclnt.util.log.CLog;

public class CCStateManager
extends StateManager {
    StateManager m_parent;

    public CCStateManager(StateManager parent) {
        this.m_parent = parent;
    }

    @Override
    public UIViewRoot restoreView(FacesContext context, String viewId, String renderKitId) {
        if (SystemXml.getSessionStateManagementUseContainer()) {
            return this.m_parent.restoreView(context, viewId, renderKitId);
        }
        UIViewRoot currentRoot = null;
        CCSessionState css = (CCSessionState)HttpSessionAccess.getCurrentHttpSession(context).getAttribute(this.getClass().getName() + "/" + viewId + "/" + ThreadData.getInstance().getSubpageId());
        if (css != null && css.getViewRoot() != null) {
            currentRoot = css.getViewRoot();
            CLog.L.log(CLog.LL_INF, "View root was directly available within session context");
        }
        if (currentRoot == null) {
            CLog.L.log(CLog.LL_WAR, "----- Rebuilding view root ----- begin");
            CLog.L.log(CLog.LL_WAR, "The view root object was not found in the session context");
            CLog.L.log(CLog.LL_WAR, "Maybe the session context was dumped or it was migrated betweeen various server instances");
            CLog.L.log(CLog.LL_WAR, "Consequence: the view is rendered from the scratch");
            CLog.L.log(CLog.LL_WAR, "If this happens too frequently then the configuration of the application server environment should be checked: by default sessions should remain stable within one application server instance - and should not be migrated permanently");
            currentRoot = context.getApplication().getViewHandler().createView(context, viewId);
            CLog.L.log(CLog.LL_WAR, "----- Rebuilding view root ----- end");
        }
        return currentRoot;
    }

    @Override
    public Object saveView(FacesContext context) {
        if (SystemXml.getSessionStateManagementUseContainer()) {
            return this.m_parent.saveView(context);
        }
        UIViewRoot currentRoot = context.getViewRoot();
        HttpSession session = HttpSessionAccess.getCurrentHttpSession(context);
        CCSessionState css = new CCSessionState();
        css.setViewRoot(currentRoot);
        session.setAttribute(this.getClass().getName() + "/" + currentRoot.getViewId() + "/" + ThreadData.getInstance().getSubpageId(), (Object)css);
        CLog.L.log(CLog.LL_INF, "View root was stored in session context");
        return new Object[]{"dummy", null};
    }

    @Override
    public boolean isSavingStateInClient(FacesContext context) {
        return false;
    }

    @Override
    public void writeState(FacesContext context, Object state) throws IOException {
        this.m_parent.writeState(context, state);
    }

    @Override
    public void writeState(FacesContext context, StateManager.SerializedView state) throws IOException {
        this.m_parent.writeState(context, state);
    }

    @Override
    public StateManager.SerializedView saveSerializedView(FacesContext context) {
        if (SystemXml.getSessionStateManagementUseContainer()) {
            return this.m_parent.saveSerializedView(context);
        }
        return super.saveSerializedView(context);
    }

    @Override
    protected Object getTreeStructureToSave(FacesContext context) {
        return super.getTreeStructureToSave(context);
    }

    @Override
    protected Object getComponentStateToSave(FacesContext context) {
        return super.getComponentStateToSave(context);
    }

    @Override
    protected UIViewRoot restoreTreeStructure(FacesContext context, String viewId, String renderKitId) {
        return super.restoreTreeStructure(context, viewId, renderKitId);
    }

    @Override
    protected void restoreComponentState(FacesContext context, UIViewRoot viewRoot, String renderKitId) {
        if (SystemXml.getSessionStateManagementUseContainer()) {
            super.restoreComponentState(context, viewRoot, renderKitId);
        } else {
            super.restoreComponentState(context, viewRoot, renderKitId);
        }
    }
}

