/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import org.eclnt.jsfserver.util.ServletUtil;

public class NoCacheNoStoreFilter
implements Filter {
    public void doFilter(ServletRequest servletrequest, ServletResponse servletresponse, FilterChain filterchain) throws IOException, ServletException {
        if (servletrequest instanceof HttpServletRequest) {
            HttpServletRequest httpservletrequest = (HttpServletRequest)servletrequest;
            HttpServletResponse httpservletresponse = (HttpServletResponse)servletresponse;
            MyResponseWrapper responsewrapper = new MyResponseWrapper(httpservletresponse);
            filterchain.doFilter(servletrequest, (ServletResponse)responsewrapper);
        } else {
            filterchain.doFilter(servletrequest, servletresponse);
        }
    }

    public void init(FilterConfig filterconfig) {
    }

    public void destroy() {
    }

    class MyResponseWrapper
    extends HttpServletResponseWrapper {
        HttpServletResponse i_response;

        public MyResponseWrapper(HttpServletResponse response) {
            super(response);
            this.i_response = response;
        }

        public void setContentType(String contentType) {
            ServletUtil.setResponseHeader(this.i_response, "Expires", "-1");
            ServletUtil.setResponseHeader(this.i_response, "Cache-Control", "no-store, no-cache");
            ServletUtil.setResponseHeader(this.i_response, "Pragma", "no-cache");
            ServletUtil.setResponseContentType(this.i_response, contentType);
        }
    }
}

