/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import jakarta.servlet.http.HttpServletRequest;
import org.eclnt.jsfserver.base.faces.context.FacesContext;
import org.eclnt.jsfserver.configuration.CCConfigurationObject;
import org.eclnt.jsfserver.dynamicpages.DynamicPageMgmt;
import org.eclnt.jsfserver.managedbean.HotDeployManager;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.ICCServerConstants;
import org.eclnt.jsfserver.util.ILayoutXMLModifierAfterRead;
import org.eclnt.jsfserver.util.SystemXml;
import org.eclnt.jsfserver.util.WebResourceClassloaderReader;
import org.eclnt.util.file.ClassloaderReader;
import org.eclnt.util.log.CLog;

public class PageReader
implements ICCServerConstants {
    private static final Object SYNCHER = new Object();
    private static boolean s_initialized = false;
    private static CCConfigurationObject<ILayoutXMLModifierAfterRead> s_layoutModifierAfterRead = new CCConfigurationObject<Object>(null);

    public static String readXMLForAbsolutePageName(String fullPageName) {
        String xml = PageReader.readLayoutXML(fullPageName);
        if (xml != null) {
            xml = PageReader.isolateXML(xml, false);
        }
        if (xml != null && s_layoutModifierAfterRead != null && s_layoutModifierAfterRead.instance() != null) {
            xml = s_layoutModifierAfterRead.instance().updateLayoutXML(fullPageName, xml);
        }
        return xml;
    }

    public static String isolateXML(String layoutContent, boolean withError) {
        String result = PageReader.isolateXMLContent(layoutContent);
        if (result == null && withError) {
            throw new Error("The content that was passed could not be interpreted as layout definition:\n" + layoutContent);
        }
        result = "<t:page>\n" + result + "\n</t:page>";
        return result;
    }

    private static String isolateXMLContent(String layoutContent) {
        String result = PageReader.isolateXMLContent_JSPtraditional(layoutContent);
        if (result != null) {
            return result;
        }
        result = PageReader.isolateXMLContent_XML(layoutContent);
        if (result != null) {
            return result;
        }
        return layoutContent;
    }

    private static String isolateXMLContent_XML(String jsp) {
        int index1 = jsp.indexOf("<t:layoutdefinition");
        if (index1 >= 0) {
            int index2 = jsp.indexOf(">", index1 + 19);
            int index3 = jsp.indexOf("</t:layoutdefinition");
            if (index3 < 0) {
                throw new Error("Problem in loaded content: could not find closing tag \"</t:layoutdefinition\", the content is: " + jsp);
            }
            jsp = jsp.substring(index2 + 1, index3);
            return jsp;
        }
        return null;
    }

    private static String isolateXMLContent_JSPtraditional(String jsp) {
        int index1 = jsp.indexOf("<f:subview");
        if (index1 >= 0) {
            int index2 = jsp.indexOf(">", index1 + 10);
            int index3 = jsp.indexOf("</f:subview");
            if (index3 < 0) {
                throw new Error("Problem in loaded content: could not find closing tag \"</f:subview\", the content is: " + jsp);
            }
            jsp = jsp.substring(index2 + 1, index3);
            return jsp;
        }
        return null;
    }

    private static String readLayoutXML(String fullPageName) {
        String xml = PageReader.readUnmodifiedLayoutXML(fullPageName);
        return xml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initialize() {
        if (s_initialized) {
            return;
        }
        Object object = SYNCHER;
        synchronized (object) {
            if (s_initialized) {
                return;
            }
            s_initialized = true;
            PageReader.initializeExecute();
        }
    }

    private static void initializeExecute() {
        String className = SystemXml.getLayoutXMLModifierAfterRead();
        if (className == null) {
            return;
        }
        try {
            s_layoutModifierAfterRead = new CCConfigurationObject(className, null);
        }
        catch (Throwable t) {
            throw new Error("Problem when creating instance of: " + className, t);
        }
    }

    private static String readUnmodifiedLayoutXML(String fullPageName) {
        String jsp;
        CLog.L.log(CLog.LL_INF, "PageReader: reading layoutXML for page: " + fullPageName);
        if ("/ccempty:ccempty".equals(fullPageName)) {
            jsp = "<f:subview id=\"ccempty\"></f:subview>";
        } else if (fullPageName.startsWith("/ccclresource:")) {
            if (CLog.L.isLoggable(CLog.LL_DBG)) {
                CLog.L.log(CLog.LL_DBG, "included page is referenced by class loader resource path: " + fullPageName);
            }
            String path = fullPageName.substring("/ccclresource:".length());
            jsp = PageReader.readJspForPageBeanComponent(path);
        } else if (fullPageName.startsWith("/ccclresourceasrow:")) {
            if (CLog.L.isLoggable(CLog.LL_DBG)) {
                CLog.L.log(CLog.LL_DBG, "included page is referenced by class loader resource path: " + fullPageName);
            }
            ClassloaderReader cr = new ClassloaderReader(HotDeployManager.currentClassLoader());
            String path = fullPageName.substring("/ccclresourceasrow:".length());
            jsp = PageReader.readJspForPageBeanComponent(path);
            jsp = jsp == null ? null : "<t:row>" + jsp + "</t:row>";
        } else if (!fullPageName.startsWith("/")) {
            if (CLog.L.isLoggable(CLog.LL_DBG)) {
                CLog.L.log(CLog.LL_DBG, "included page is referenced in relative way");
            }
            FacesContext context = HttpSessionAccess.getCurrentFacesContext();
            HttpServletRequest request = (HttpServletRequest)context.getExternalContext().getRequest();
            String requestURI = request.getRequestURI();
            CLog.L.log(CLog.LL_DBG, "request URI used for finding absolute address: " + requestURI);
            int lastSlash = requestURI.lastIndexOf(47);
            String currentPageRoot = requestURI.substring(1, lastSlash + 1) + fullPageName;
            int firstSlash = currentPageRoot.indexOf(47);
            currentPageRoot = currentPageRoot.substring(firstSlash);
            if (currentPageRoot.startsWith("/faces/")) {
                currentPageRoot = currentPageRoot.substring(6);
            } else {
                int facesIndex = currentPageRoot.indexOf("/faces/");
                if (facesIndex >= 0) {
                    currentPageRoot = currentPageRoot.substring(facesIndex + 6);
                    CLog.L.log(CLog.LL_WAR, "/faces/ was deteceted within the page root - page root adapted correspondingly");
                }
            }
            if (CLog.L.isLoggable(CLog.LL_DBG)) {
                CLog.L.log(CLog.LL_DBG, "absolute page address is: " + currentPageRoot);
            }
            jsp = PageReader.readJspFromProject(currentPageRoot);
        } else {
            jsp = DynamicPageMgmt.checkIfPageIsManagedDynamically(fullPageName) ? DynamicPageMgmt.readDynamicPage(fullPageName) : PageReader.readJspFromProject(fullPageName);
        }
        return jsp;
    }

    private static String readJspForPageBeanComponent(String path) {
        ClassloaderReader cr = new ClassloaderReader(true);
        String jsp = cr.readUTF8File(path, false);
        if (jsp == null || jsp.trim().length() == 0) {
            if (path.endsWith(".xml")) {
                path = path.substring(0, path.length() - 4) + ".jsp";
                jsp = cr.readUTF8File(path, false);
            } else if (path.endsWith(".jsp")) {
                path = path.substring(0, path.length() - 4) + ".xml";
                jsp = cr.readUTF8File(path, false);
            }
        }
        return jsp;
    }

    private static String readJspFromProject(String fullPageName) {
        String jsp = WebResourceClassloaderReader.readUTF8File(fullPageName);
        return jsp;
    }

    static {
        PageReader.initialize();
    }
}

