/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.ProfileLogInfo;
import org.eclnt.util.file.FileManager;
import org.eclnt.util.valuemgmt.ValueManager;

public class ProfileLogWriter {
    public static void writeProfileLogMessages(List<ProfileLogInfo> logInfos, long totalNanos) {
        StringBuffer sb = new StringBuffer();
        for (ProfileLogInfo pli : logInfos) {
            String duration = "          " + pli.getDuration();
            duration = duration.substring(duration.length() - 10);
            sb.append(pli.getType());
            sb.append(";");
            sb.append(duration);
            sb.append("; ");
            sb.append(pli.getComment());
            sb.append("\n");
        }
        sb.append("TOTAL;         0; // total time (nanos): " + totalNanos + "\n");
        sb.append("TOTAL;         0; // total time (ms): " + totalNanos / 1000000L + "\n");
        String fileName = HttpSessionAccess.getServletTempDirectory() + "/profilelogs/pl_" + System.currentTimeMillis() + ".csv";
        FileManager.ensureDirectoryForFileExists(fileName);
        FileManager.writeUTF8File(fileName, sb.toString(), false);
    }

    public static String getProfileLogDirectory() {
        String dirName = HttpSessionAccess.getServletTempDirectory() + "/profilelogs/";
        return dirName;
    }

    public List<String> getProfileLogFileNames() {
        String dirName = HttpSessionAccess.getServletTempDirectory() + "/profilelogs/";
        List<String> fileNames = FileManager.getFilesOfDirectoryByPattern(dirName, ".csv");
        for (int i = fileNames.size() - 1; i >= 0; --i) {
            try {
                String fileName = fileNames.get(i);
                fileName = ValueManager.encodeIntoValidFileName(fileName, false);
                int index = fileName.lastIndexOf(47);
                String simpleFileName = fileName.substring(index + 1);
                if (simpleFileName.startsWith("pl_")) continue;
                fileNames.remove(i);
                continue;
            }
            catch (Throwable t) {
                fileNames.remove(i);
            }
        }
        Collections.sort(fileNames);
        return fileNames;
    }

    public static List<ProfileLogInfo> readProfileLogMessages(String fileName) {
        ArrayList<ProfileLogInfo> result = new ArrayList<ProfileLogInfo>();
        String content = FileManager.readUTF8File(fileName, false);
        if (content != null) {
            StringTokenizer st = new StringTokenizer(content, "\n");
            while (st.hasMoreTokens()) {
                String line = st.nextToken();
                if (line.length() == 0) continue;
                String[] values = ValueManager.decodeCSV(line);
                String type = null;
                long nanos = 0L;
                String comment = null;
                if (values.length >= 1) {
                    type = values[0];
                }
                if (values.length >= 2) {
                    nanos = ValueManager.decodeLong(values[1].trim(), 0L);
                }
                if (values.length >= 3) {
                    comment = values[2].trim();
                }
                ProfileLogInfo pli = new ProfileLogInfo(type, nanos, comment);
                result.add(pli);
            }
        }
        return result;
    }
}

