/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import com.veracode.annotation.CRLFCleanser;
import com.veracode.annotation.XSSCleanser;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.eclnt.jsfserver.elements.ThreadData;
import org.eclnt.jsfserver.util.ClientToBeReloadedException;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.ICCServerConstants;
import org.eclnt.jsfserver.util.SystemXml;
import org.eclnt.jsfserver.util.TypeOfSessionMgmt;
import org.eclnt.util.log.CLog;
import org.eclnt.util.mitigation.CCMitigation;
import org.eclnt.util.valuemgmt.ValueManager;
import org.owasp.encoder.Encode;
import org.owasp.esapi.StringUtilities;

public class ServletUtil
implements ICCServerConstants {
    public static final String ECLNTID_COOKIE_NAME = "eclnt-id";
    private static boolean ECLNTID_COOKIE_HTTPONLY = true;
    private static String ECLNTID_COOKIE_SECURE = "false";
    private static String ECLNTID_COOKIE_SAMESITE = "Strict";
    static final String COMMENT_writeTrustedDataToResponseOutputStream = "This method is explicitly designed to write any content to the output stream without any sanitzizing of the content. It must only be used of the caller can ensure that the data is coming from trusted sources and that the data is not directly related to user input.";

    public static void initialize() {
        ServletUtil.createSimpleDateFormatForExpirationDate();
        ServletUtil.initClientIdCookieParamHttpOnly(SystemXml.getClientIdManagementCookieHttpOnly());
        ServletUtil.initClientIdCookieParamSecure(SystemXml.getClientIdManagementCookieSecure());
        ServletUtil.initClientIdCookieParamSameSite(SystemXml.getClientIdManagementCookieSameSite());
    }

    public static void initClientIdCookieParamHttpOnly(boolean httpOnly) {
        ECLNTID_COOKIE_HTTPONLY = httpOnly;
    }

    public static void initClientIdCookieParamSecure(boolean secure) {
        ECLNTID_COOKIE_SECURE = "" + secure;
    }

    public static void initClientIdCookieParamSecure(String secure) {
        ECLNTID_COOKIE_SECURE = secure;
    }

    public static void initClientIdCookieParamSameSite(String sameSite) {
        ECLNTID_COOKIE_SAMESITE = sameSite;
    }

    public static String encodeURL(String url, HttpServletRequest req, HttpServletResponse resp) {
        return ServletUtil.encodeURLExecute(url, req, resp, true);
    }

    public static String encodeURLWithoutURLEncoding(String url, HttpServletRequest req, HttpServletResponse resp) {
        return ServletUtil.encodeURLExecute(url, req, resp, false);
    }

    private static String encodeURLExecute(String url, HttpServletRequest req, HttpServletResponse resp, boolean withURLEncoding) {
        if (!TypeOfSessionMgmt.getSessionMgmtViaCookie()) {
            if (withURLEncoding) {
                url = req.isRequestedSessionIdFromCookie() || SystemXml.getEncodeEnforceOwnEncoding() ? ServletUtil.toEncoded(url, req.getSession().getId()) : resp.encodeURL(url);
            }
        } else {
            try {
                String subpageId = ThreadData.getInstance().getSubpageId();
                url = ServletUtil.addQueryParameterToURL(url, "cc_subpageId", subpageId);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return url;
    }

    public static String decodeURL(String url) {
        try {
            if (url == null) {
                return null;
            }
            return URLDecoder.decode(url, "UTF-8");
        }
        catch (Throwable t) {
            throw new Error("Problem decoding URL " + url, t);
        }
    }

    public static String addQueryParameterToURL(String url, String name, String value) {
        int qmIndex = url.indexOf("?");
        url = qmIndex > 0 ? url.substring(0, qmIndex + 1) + name + "=" + value + "&" + url.substring(qmIndex + 1) : url + "?" + name + "=" + value;
        return url;
    }

    public static void ensureServletGetIsAllowed(Class clazz) {
        SystemXml.ServletConfiguration sc = SystemXml.getServletConfiguration(clazz);
        if (sc == null) {
            return;
        }
        if (sc.getBlockget()) {
            throw new GetRequestBlockedByConfigurationException(clazz.getName());
        }
    }

    public static String isolateResourcePath(HttpServletRequest req) {
        String contextPath;
        int index2;
        String uri = req.getRequestURI();
        int indexSemicolon = uri.indexOf(";");
        if (indexSemicolon > 0) {
            uri = uri.substring(0, indexSemicolon);
        }
        if ((uri = uri.substring((index2 = uri.indexOf(contextPath = req.getContextPath())) + contextPath.length())).startsWith("/")) {
            uri = uri.substring(1);
        }
        return uri;
    }

    public static String findWebappCookiePath(HttpServletRequest req) {
        String result = ServletUtil.isolateOriginalUrlWebappContextPath(req);
        if (result == null) {
            return "/";
        }
        return result;
    }

    public static String isolateOriginalUrlWebappContextPath(HttpServletRequest req) {
        try {
            String originalUrl;
            String result = originalUrl = req.getHeader("eclnt-originalurl");
            int facesIndex = result.indexOf("/faces/");
            result = result.substring(0, facesIndex);
            int index1 = result.indexOf("://");
            int index2 = result.indexOf("/", index1 + 3);
            result = result.substring(index2);
            return result;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static String isolateOriginalProtocol(HttpServletRequest req, boolean withError) {
        try {
            String originalUrl = req.getHeader("eclnt-originalurl");
            if (originalUrl == null) {
                throw new Exception("Could not find header attribute in URL: eclnt-originalurl");
            }
            int index = originalUrl.indexOf("://");
            return originalUrl.substring(0, index);
        }
        catch (Throwable t) {
            if (withError) {
                throw new Error("The original protocol is not visible in the request passed: " + req.getRequestURI(), t);
            }
            return null;
        }
    }

    public static String isolateOriginalServer(HttpServletRequest req, boolean withError) {
        try {
            int index3;
            String originalUrl = req.getHeader("eclnt-originalurl");
            if (originalUrl == null) {
                throw new Exception("Could not find header attribute in URL: eclnt-originalurl");
            }
            int index = originalUrl.indexOf("://");
            int index2 = originalUrl.indexOf(":", index + 3);
            int indexEndServer = index3 = originalUrl.indexOf("/", index + 3);
            if (index2 >= 0 && index2 < index3) {
                indexEndServer = index2;
            }
            return originalUrl.substring(index + 3, indexEndServer);
        }
        catch (Throwable t) {
            if (withError) {
                throw new Error("The original protocol is not visible in the request passed: " + req.getRequestURI(), t);
            }
            return null;
        }
    }

    private static String toEncoded(String url, String sessionId) {
        StringBuffer sb;
        int pound;
        if (url == null || sessionId == null) {
            return url;
        }
        String path = url;
        String query = "";
        String anchor = "";
        int question = url.indexOf(63);
        if (question >= 0) {
            path = url.substring(0, question);
            query = url.substring(question);
        }
        if ((pound = path.indexOf(35)) >= 0) {
            anchor = path.substring(pound);
            path = path.substring(0, pound);
        }
        if ((sb = new StringBuffer(path)).length() > 0) {
            sb.append(";");
            sb.append(SystemXml.getEncodenamejsessionid());
            sb.append("=");
            sb.append(sessionId);
        }
        sb.append(anchor);
        sb.append(query);
        return sb.toString();
    }

    public static String updateResource(HttpServletRequest req, String resource) {
        return resource;
    }

    public static String proposeContentType(String extension) {
        if (extension == null || extension.trim().length() == 0) {
            return "application/octet-stream";
        }
        if ("html".equals(extension = ValueManager.toLowerCaseId(extension))) {
            return "text/html";
        }
        if ("htm".equals(extension)) {
            return "text/html";
        }
        if ("css".equals(extension)) {
            return "text/css";
        }
        if ("js".equals(extension)) {
            return "text/javascript";
        }
        if ("txt".equals(extension)) {
            return "text/plain";
        }
        if ("jpg".equals(extension)) {
            return "image/jpg";
        }
        if ("jpeg".equals(extension)) {
            return "image/jpg";
        }
        if ("png".equals(extension)) {
            return "image/png";
        }
        if ("gif".equals(extension)) {
            return "image/gif";
        }
        if ("giff".equals(extension)) {
            return "image/giff";
        }
        if ("svg".equals(extension)) {
            return "image/svg+xml";
        }
        if ("tif".equals(extension)) {
            return "image/tif";
        }
        if ("tiff".equals(extension)) {
            return "image/tif";
        }
        if ("pdf".equals(extension)) {
            return "application/pdf";
        }
        if ("mp3".equals(extension)) {
            return "audio/mpeg";
        }
        if ("mp4".equals(extension)) {
            return "video/mp4";
        }
        if ("webm".equals(extension)) {
            return "video/webm";
        }
        if ("xlsx".equals(extension)) {
            return "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
        }
        if ("xml".equals(extension)) {
            return "application/xml";
        }
        if ("json".equals(extension)) {
            return "application/json";
        }
        if ("odt".equals(extension)) {
            return "application/vnd.oasis.opendocument.text";
        }
        if ("ods".equals(extension)) {
            return "application/vnd.oasis.opendocument.spreadsheet";
        }
        if ("odp".equals(extension)) {
            return "application/vnd.oasis.opendocument.presentation";
        }
        return "application/" + extension;
    }

    public static void writeEclntIdCookie(HttpServletResponse resp, String id) {
        String secureString = ECLNTID_COOKIE_SECURE;
        boolean secure = false;
        secure = "auto".equals(secureString) ? HttpSessionAccess.checkIfCurrentSessionWasStartedByHttps() : ValueManager.decodeBoolean(secureString, false);
        ServletUtil.writeCookie(resp, ECLNTID_COOKIE_NAME, null, id, ECLNTID_COOKIE_HTTPONLY, ECLNTID_COOKIE_SAMESITE, secure);
    }

    public static void writeCookie(HttpServletResponse resp, String name, String path, String value, boolean httponly, String samesite, boolean secure) {
        if (resp == null) {
            return;
        }
        value = ServletUtil.sanitizeCookieValue(value);
        path = ServletUtil.sanitizeCookieValue(path);
        samesite = ServletUtil.sanitizeCookieValue(samesite);
        String cookie = name + "=" + value + ";";
        if (path != null) {
            cookie = cookie + " Path=" + path + ";";
        }
        if (httponly) {
            cookie = cookie + " HttpOnly;";
        }
        if (samesite != null) {
            cookie = cookie + " SameSite=" + samesite + ";";
        }
        if (secure) {
            cookie = cookie + " secure;";
        }
        cookie = cookie + " Expires=" + ServletUtil.calculateExpirationDateForever();
        resp.addHeader("Set-Cookie", cookie);
    }

    public static String calculateExpirationDateForever() {
        SimpleDateFormat sdf = ServletUtil.createSimpleDateFormatForExpirationDate();
        long timeStampFarAway = System.currentTimeMillis() + 864000000000L;
        return sdf.format(new Date(timeStampFarAway));
    }

    public static void ensureSessionIsAvailableAndValid(HttpServletRequest req) throws SessionIsNotAvailableOrInvalidException {
        try {
            HttpSession session = req.getSession(false);
            if (session != null) {
                session.setAttribute("cctestsession", (Object)"cctestsession");
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        throw new SessionIsNotAvailableOrInvalidException();
    }

    public static boolean checkIfRISCUrlStartedInDevelopmentMode(HttpServletRequest startRequest) {
        String prodMode = startRequest.getParameter("ccprodmode");
        if ("true".equals(prodMode)) {
            return false;
        }
        String url = startRequest.getRequestURL().toString();
        if (url.startsWith("http://localhost")) {
            return true;
        }
        return url.startsWith("https://localhost");
    }

    public static String getPathBehindContextPath(HttpServletRequest request) {
        String contextPath = request.getContextPath();
        String uri = request.getRequestURI();
        String path = uri.substring(contextPath.length());
        return path;
    }

    public static void setResponseContentType(HttpServletResponse response, String contentType) {
        if (response == null) {
            return;
        }
        if (contentType == null) {
            return;
        }
        contentType = ServletUtil.sanitizeContentType(contentType);
        response.setContentType(contentType);
    }

    public static void setResponseHeader(HttpServletResponse response, String fieldName, String attributeValue) {
        if (response == null) {
            return;
        }
        if (fieldName == null) {
            return;
        }
        if (attributeValue == null) {
            return;
        }
        ServletUtil.addHeaderByESAPICode(response, fieldName, attributeValue);
    }

    private static void addHeaderByESAPICode(HttpServletResponse response, String fieldName, String attributeValue) {
        try {
            String strippedName = StringUtilities.replaceLinearWhiteSpace((String)fieldName);
            String strippedValue = StringUtilities.replaceLinearWhiteSpace((String)attributeValue);
            String regex1 = "^[a-zA-Z0-9\\\\\\-_]{1,256}$";
            boolean match1 = ValueManager.checkIfStringMatchesRegularExpression(strippedName, regex1);
            String regex2 = "^[a-zA-Z0-9()'\\\\\\-=\\*\\.\\?;,+\\/:&_ ]*$";
            boolean match2 = ValueManager.checkIfStringMatchesRegularExpression(strippedValue, regex2);
            if (!match1) {
                throw new Exception("Name does not meet regex: " + regex1);
            }
            if (!match2) {
                throw new Exception("Value does not meet regex" + regex2);
            }
            response.setHeader(strippedName, strippedValue);
        }
        catch (Throwable t) {
            throw new Error("ESAPI does not accept header: " + fieldName + ": " + attributeValue, t);
        }
    }

    public static String sanitizeContentType(String contentType) {
        String result = Encode.forJava((String)contentType);
        return result;
    }

    public static String sanitizeCookieValue(String value) {
        String result = Encode.forJava((String)value);
        return result;
    }

    public static String readRequestParameterFromDesignTimeRequest(HttpServletRequest req, String parameterName) {
        if (ServletUtil.checkIfRequestIsDesignTimerRequest(req)) {
            return req.getParameter(parameterName);
        }
        return null;
    }

    public static void ensureRequestIsDesignTimeRequest(HttpServletRequest req) {
        if (!ServletUtil.checkIfRequestIsDesignTimerRequest(req)) {
            throw new Error("The request must only be executed in a design time environment of the server.");
        }
    }

    public static boolean checkIfRequestIsDesignTimerRequest(HttpServletRequest req) {
        String url = req.getRequestURL().toString();
        return url.startsWith("http://localhost") || url.startsWith("https://localhost");
    }

    private static SimpleDateFormat createSimpleDateFormatForExpirationDate() {
        try {
            TimeZone timeZone = TimeZone.getTimeZone("GMT");
            SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss zzz", new Locale("en", "EN"));
            dateFormat.setTimeZone(timeZone);
            return dateFormat;
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Problem occurred createing SimpleDateFormat", t);
            throw new Error("Problem occurred createing SimpleDateFormat", t);
        }
    }

    public static void setSessionAttributeWithTrustedName(HttpSession session, String attributeName, Object data) {
        session.setAttribute(attributeName, data);
    }

    @CRLFCleanser(userComment="This method is explicitly designed to write any content to the output stream without any sanitzizing of the content. It must only be used of the caller can ensure that the data is coming from trusted sources and that the data is not directly related to user input.")
    @XSSCleanser(userComment="This method is explicitly designed to write any content to the output stream without any sanitzizing of the content. It must only be used of the caller can ensure that the data is coming from trusted sources and that the data is not directly related to user input.")
    @CCMitigation(cweIds={"113"}, comment="This method is explicitly designed to write any content to the output stream without any sanitzizing of the content. It must only be used of the caller can ensure that the data is coming from trusted sources and that the data is not directly related to user input.")
    public static void writeTrustedDataToResponseOutputStream(HttpServletResponse resp, byte[] data) throws IOException {
        resp.getOutputStream().write(data);
    }

    public static String addFileNameAdviceIntoURL(String url, String fileName) {
        int qmIndex;
        if (fileName == null || fileName.trim().length() == 0) {
            return url;
        }
        int lastSlash = fileName.lastIndexOf("/");
        if (lastSlash >= 0) {
            fileName = fileName.substring(lastSlash + 1);
        }
        if ((lastSlash = fileName.lastIndexOf("\\")) >= 0) {
            fileName = fileName.substring(lastSlash + 1);
        }
        url = (qmIndex = url.indexOf(63)) < 0 ? url + ";filename=/" + fileName : url.substring(0, qmIndex) + ";filename=/" + fileName + url.substring(qmIndex);
        return url;
    }

    public static Map<String, String> readCookieValuesFromRequest(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        HashMap<String, String> result = new HashMap<String, String>();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (cookie.getName() == null || cookie.getValue() == null) continue;
                result.put(cookie.getName(), cookie.getValue());
            }
        }
        return result;
    }

    public static class GetRequestBlockedByConfigurationException
    extends RuntimeException {
        public GetRequestBlockedByConfigurationException(String message) {
            super(message);
        }
    }

    public static class SessionIsNotAvailableOrInvalidException
    extends ClientToBeReloadedException {
    }
}

