/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.MethodExpression;
import jakarta.el.MethodInfo;
import jakarta.el.MethodNotFoundException;
import jakarta.el.PropertyNotFoundException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclnt.jsfserver.base.faces.application.Application;
import org.eclnt.jsfserver.base.faces.event.AbortProcessingException;
import org.eclnt.jsfserver.base.faces.event.ActionEvent;
import org.eclnt.jsfserver.base.faces.event.ActionListener;
import org.eclnt.jsfserver.elements.BaseActionEvent;
import org.eclnt.jsfserver.util.CCELResolver;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.StackedValueExpression;
import org.eclnt.jsfserver.util.StackedValueKeeper;
import org.eclnt.util.log.CLog;
import org.eclnt.util.logdt.DTLogFactory;
import org.eclnt.util.logdt.ENUMLogCategory;

public class StackedMethodExpression
extends MethodExpression
implements ActionListener {
    int m_hashCode = 0;
    String m_methodName;
    StackedValueExpression m_valueExpression;

    public StackedMethodExpression(Application app, String mbString) {
        int lastDot = mbString.lastIndexOf(46);
        this.m_valueExpression = new StackedValueExpression(app, mbString.substring(0, lastDot) + "}");
        this.m_methodName = mbString.substring(lastDot + 1, mbString.length() - 1);
        Integer methodNameId = StackedValueKeeper.getIdForName(this.m_methodName);
        this.m_methodName = StackedValueKeeper.getUniqueNameForId(methodNameId, this.m_methodName);
    }

    public MethodInfo getMethodInfo(ELContext elContext) throws NullPointerException, PropertyNotFoundException, MethodNotFoundException, ELException {
        return null;
    }

    public Object invoke(ELContext elContext, Object[] args) throws NullPointerException, PropertyNotFoundException, MethodNotFoundException, ELException {
        return this.invoke(elContext, args, false);
    }

    public Object invoke(ELContext elContext, Object[] args, boolean throwErrorIfNotReached) throws NullPointerException, PropertyNotFoundException, MethodNotFoundException, ELException {
        try {
            Method m;
            CCELResolver.passCurrentMethodExpressionBegin(this);
            Object o = this.m_valueExpression.getValue(elContext);
            if (o == null) {
                throw new NotReachedError("");
            }
            boolean calledMethod = false;
            if (args.length == 1 && args[0] instanceof BaseActionEvent) {
                m = null;
                try {
                    m = o.getClass().getMethod(this.m_methodName, BaseActionEvent.class);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (m != null) {
                    m.invoke(o, args);
                    calledMethod = true;
                }
            }
            if (!calledMethod && args.length == 1 && args[0] instanceof ActionEvent) {
                m = null;
                try {
                    m = o.getClass().getMethod(this.m_methodName, ActionEvent.class);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (m != null) {
                    m.invoke(o, args);
                    calledMethod = true;
                }
            }
            if (!calledMethod && args.length == 1 && args[0] != null) {
                m = null;
                try {
                    m = o.getClass().getMethod(this.m_methodName, args[0].getClass());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (m != null) {
                    m.invoke(o, args);
                    calledMethod = true;
                }
            }
            if (!calledMethod && args.length == 0) {
                m = null;
                try {
                    m = o.getClass().getMethod(this.m_methodName, null);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (m != null) {
                    m.invoke(o, null);
                    calledMethod = true;
                }
            }
            if (!calledMethod) {
                CLog.L.log(CLog.LL_INF, "COULD NOT RESOLVE RIGHT METHOD for " + this.getExpressionString());
                throw new NoSuchMethodException("Method could not be found: " + this.getExpressionString());
            }
        }
        catch (NotReachedError nre) {
            if (!throwErrorIfNotReached) {
                CLog.L.log(CLog.LL_INF, "Object for execution of method \"" + this.m_methodName + "\" is null. ValueBinding is: " + this.m_valueExpression.getExpressionString());
                CLog.L.log(CLog.LL_INF, "Method \"" + this.m_methodName + "\" is not executed as consequence.");
                DTLogFactory.getLog().log(ENUMLogCategory.METHODERROR_NULL, this.getExpressionString(), "Method  not reached", null);
                Object var5_11 = null;
                return var5_11;
            }
            throw new Error(nre);
        }
        catch (InvocationTargetException itexc) {
            CLog.L.log(CLog.LL_INF, "Invocation target exception: " + this.m_methodName + ", " + itexc.toString());
            DTLogFactory.getLog().log(ENUMLogCategory.METHODERROR_IMPL, this.getExpressionString(), null, itexc);
            if (itexc.getCause() != null) {
                throw new Error(itexc.getCause());
            }
            throw new Error(itexc);
        }
        catch (NoSuchMethodException nsme) {
            DTLogFactory.getLog().log(ENUMLogCategory.METHODERROR_IMPL, this.getExpressionString(), null, nsme);
            if (this.m_methodName != null && this.m_methodName.startsWith("onApplicationError")) {
                CLog.L.log(CLog.LL_INF, "Method not available: " + this.m_methodName);
            } else {
                CLog.L.log(CLog.LL_INF, "Method not available: " + this.m_methodName);
            }
            throw new MethodNotFoundException((Throwable)nsme);
        }
        catch (ArrayIndexOutOfBoundsException exc) {
            CLog.L.log(CLog.LL_ERR, "Array index not available: " + this.m_methodName);
            DTLogFactory.getLog().log(ENUMLogCategory.METHODERROR_IMPL, this.getExpressionString(), null, exc);
            throw new Error(exc);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Invoke failed: " + this.m_methodName, t);
            DTLogFactory.getLog().log(ENUMLogCategory.METHODERROR_IMPL, this.getExpressionString(), null, t);
            throw new Error(t);
        }
        finally {
            CCELResolver.passCurrentMethodExpressionEnd();
        }
        return null;
    }

    public boolean equals(Object arg0) {
        if (arg0 == null) {
            return false;
        }
        if (arg0 == this) {
            return true;
        }
        if (!(arg0 instanceof StackedMethodExpression)) {
            return false;
        }
        StackedMethodExpression smearg0 = (StackedMethodExpression)arg0;
        return this.getExpressionString().equals(smearg0.getExpressionString());
    }

    public String getExpressionString() {
        String result = this.m_valueExpression.getExpressionString();
        result = result.substring(0, result.length() - 1) + "." + this.m_methodName + "}";
        return result;
    }

    public int hashCode() {
        if (this.m_hashCode == 0) {
            this.m_hashCode = this.getExpressionString().hashCode();
        }
        return this.m_hashCode;
    }

    public boolean isLiteralText() {
        return false;
    }

    @Override
    public void processAction(ActionEvent event) throws AbortProcessingException {
        this.invoke(HttpSessionAccess.getCurrentFacesContext().getELContext(), new Object[]{event});
    }

    public String toString() {
        return this.getExpressionString();
    }

    class NotReachedError
    extends Error {
        String i_nullProperty;

        public NotReachedError(String nullProperty) {
            this.i_nullProperty = nullProperty;
        }
    }
}

