/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclnt.jsfserver.util.ENUMFileMode;
import org.eclnt.jsfserver.util.WebResourceReader;
import org.eclnt.jsfserver.util.security.ResourceSecurity;
import org.eclnt.jsfserver.util.webappfiles.WebappDirectoryManager;
import org.eclnt.util.file.ClassloaderReader;
import org.eclnt.util.file.StreamUtil;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.ValueManager;

public class WebResourceClassloaderReader {
    static Map<String, Boolean> s_bufferCheckIfFileExists = new Hashtable<String, Boolean>();
    static Map<String, ENUMFileMode> s_fileModes = new Hashtable<String, ENUMFileMode>();
    static Set<String> s_pathsToIgnore = new HashSet<String>();
    static Set<String> s_pathsWebResourceFirst = new HashSet<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetBuffers() {
        s_fileModes.clear();
        Map<String, Boolean> map = s_bufferCheckIfFileExists;
        synchronized (map) {
            s_bufferCheckIfFileExists.clear();
        }
    }

    public static void registerPathWithReadingWebResourceFirst(String path) {
        path = ValueManager.encodeIntoValidWebResourcePath(path, false);
        s_pathsWebResourceFirst.add(path);
    }

    public static void registerPathToIgore(String path) {
        s_pathsToIgnore.add(path);
    }

    public static String readUTF8FileIntoString(String resourcePath, boolean withError) {
        return WebResourceClassloaderReader.readUTF8FileIntoResultString(resourcePath, withError).getResult();
    }

    public static List<String> readUTF8FilesIntoStrings(String resourcePath, boolean withError) {
        List<String> l;
        ArrayList<String> result = new ArrayList<String>();
        String s = WebResourceReader.readUTF8FileIntoString(resourcePath = ValueManager.encodeIntoValidWebResourcePath(resourcePath, false), withError);
        if (s != null && s.length() > 0) {
            result.add(s);
            CLog.L.log(CLog.LL_INF, "Added content from web-content: " + resourcePath);
        }
        if ((l = new ClassloaderReader(true).readUTF8Files(resourcePath, withError)) != null) {
            result.addAll(l);
        }
        return result;
    }

    public static String readUTF8FileIntoStringForExternalUsage(String resourcePath, boolean withError) {
        try {
            ResultString rs = WebResourceClassloaderReader.readUTF8FileIntoResultString(resourcePath, withError);
            if (rs.getResult() == null) {
                throw new Exception("No content found");
            }
            if (rs.getFileMode() == ENUMFileMode.SOURCES) {
                ResourceSecurity.checkClassloaderPathForOutsideUsage(resourcePath);
            }
            return rs.getResult();
        }
        catch (Throwable t) {
            if (!withError) {
                return null;
            }
            throw new Error("No content found: " + resourcePath, t);
        }
    }

    public static ResultString readUTF8FileIntoResultString(String resourcePath, boolean withError) {
        try {
            ResultBytes content = WebResourceClassloaderReader.readFileIntoResultBytes(resourcePath);
            if (content.getResult() == null) {
                throw new Exception("No content found");
            }
            String s = new String(content.getResult(), "UTF-8");
            return new ResultString(s, content.getFileMode());
        }
        catch (Throwable t) {
            if (!withError) {
                return new ResultString(null, null);
            }
            throw new Error("No content found: " + resourcePath, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkIfFileExists(String resourcePath) {
        Boolean result = s_bufferCheckIfFileExists.get(resourcePath);
        if (result == null) {
            Map<String, Boolean> map = s_bufferCheckIfFileExists;
            synchronized (map) {
                result = s_bufferCheckIfFileExists.get(resourcePath);
                if (result == null) {
                    result = false;
                    try {
                        String s = WebResourceClassloaderReader.readUTF8FileIntoString(resourcePath, true);
                        if (s != null) {
                            result = true;
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    s_bufferCheckIfFileExists.put(resourcePath, result);
                }
            }
        }
        return result;
    }

    public static String readUTF8File(String resourcePath) {
        return WebResourceClassloaderReader.readUTF8FileIntoString(resourcePath, false);
    }

    public static byte[] readFileIntoByteArray(String resourcePath) {
        return WebResourceClassloaderReader.readFileIntoResultBytes(resourcePath).getResult();
    }

    public static ResultBytes readFileIntoResultBytes(String resourcePath) {
        try {
            ResultInputStream ris = WebResourceClassloaderReader.readFileIntoResultInputStream(resourcePath);
            if (ris.getResult() == null) {
                return new ResultBytes(null, null);
            }
            byte[] result = StreamUtil.transferStreamContentIntoBytes(ris.getResult());
            return new ResultBytes(result, ris.getFileMode());
        }
        catch (Throwable t) {
            return new ResultBytes(null, null);
        }
    }

    public static InputStream readFileIntoInputStream(String resourcePath) {
        return WebResourceClassloaderReader.readFileIntoResultInputStream(resourcePath).getResult();
    }

    public static ResultInputStream readFileIntoResultInputStream(String resourcePath) {
        if (WebResourceClassloaderReader.checkIfResourceMustNotBeReaad(resourcePath = ValueManager.encodeIntoValidWebResourcePath(resourcePath, false))) {
            return new ResultInputStream(null, null);
        }
        InputStream result = null;
        int indexLastSlash = resourcePath.lastIndexOf(47);
        int indexLastPoint = resourcePath.lastIndexOf(46);
        if (indexLastPoint <= indexLastSlash) {
            return new ResultInputStream(null, null);
        }
        ENUMFileMode fileMode = s_fileModes.get(resourcePath);
        if (fileMode != null) {
            if (fileMode == ENUMFileMode.WEBCONTENT) {
                InputStream is = WebResourceReader.readFileIntoInputStream(resourcePath, false);
                return new ResultInputStream(is, ENUMFileMode.WEBCONTENT);
            }
            InputStream is = new ClassloaderReader(true).readFileIntoInputStream(WebResourceClassloaderReader.updateResourcePathForClassLoader(resourcePath), false);
            return new ResultInputStream(is, ENUMFileMode.SOURCES);
        }
        boolean webResourceFirst = WebResourceClassloaderReader.checkIfResourceMustBeLoadedWebContentFirst(resourcePath);
        if (!webResourceFirst) {
            try {
                result = new ClassloaderReader(true).readFileIntoInputStream(WebResourceClassloaderReader.updateResourcePathForClassLoader(resourcePath), false);
                if (result != null) {
                    s_fileModes.put(resourcePath, ENUMFileMode.SOURCES);
                    return new ResultInputStream(result, ENUMFileMode.SOURCES);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                result = WebResourceReader.readFileIntoInputStream(resourcePath, false);
                if (result != null) {
                    s_fileModes.put(resourcePath, ENUMFileMode.WEBCONTENT);
                    return new ResultInputStream(result, ENUMFileMode.WEBCONTENT);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return new ResultInputStream(null, null);
        }
        try {
            result = WebResourceReader.readFileIntoInputStream(resourcePath, false);
            if (result != null) {
                s_fileModes.put(resourcePath, ENUMFileMode.WEBCONTENT);
                return new ResultInputStream(result, ENUMFileMode.WEBCONTENT);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            result = new ClassloaderReader(true).readFileIntoInputStream(WebResourceClassloaderReader.updateResourcePathForClassLoader(resourcePath), false);
            if (result != null) {
                s_fileModes.put(resourcePath, ENUMFileMode.SOURCES);
                return new ResultInputStream(result, ENUMFileMode.SOURCES);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new ResultInputStream(null, null);
    }

    private static String updateResourcePathForClassLoader(String resourcePath) {
        return resourcePath;
    }

    public static List<String> getFileNameVariantsInPathDirectoryByPattern(String path, String pattern, String extension) {
        path = ValueManager.encodeIntoValidWebResourcePath(path, true);
        ArrayList<String> result = new ArrayList<String>();
        Set<String> fileNames = WebResourceClassloaderReader.getFilesInPathDirectory(path, extension);
        for (String fileName : fileNames) {
            if (!fileName.startsWith(pattern + ".")) continue;
            result.add(fileName);
        }
        return result;
    }

    public static Set<String> getFilesInPathDirectory(String path) {
        return WebResourceClassloaderReader.getFilesInPathDirectory(path, null);
    }

    public static Set<String> getFilesInPathDirectory(String path, String extension) {
        List<String> l = WebappDirectoryManager.getFiles(path);
        HashSet<String> result = new HashSet<String>();
        if (extension == null) {
            result.addAll(l);
        } else {
            for (String s : l) {
                if (!s.endsWith(extension)) continue;
                result.add(s);
            }
        }
        return result;
    }

    public static List<String> getDirectoriesInPathDirectory(String path) {
        return WebappDirectoryManager.getDirectories(path);
    }

    private static boolean checkIfResourceMustNotBeReaad(String resourcePath) {
        return WebResourceClassloaderReader.checkIfPathMatches(resourcePath, s_pathsToIgnore);
    }

    private static boolean checkIfResourceMustBeLoadedWebContentFirst(String resourcePath) {
        return WebResourceClassloaderReader.checkIfPathMatches(resourcePath, s_pathsWebResourceFirst);
    }

    private static boolean checkIfPathMatches(String resourcePath, Set<String> paths) {
        for (String path : paths) {
            if (!ValueManager.checkIfStringMatchesAsteriskExpression(resourcePath, path, true)) continue;
            return true;
        }
        return false;
    }

    public static class ResultString {
        String i_result;
        ENUMFileMode i_fileMode;

        public ResultString(String result, ENUMFileMode fileMode) {
            this.i_result = result;
            this.i_fileMode = fileMode;
        }

        public String getResult() {
            return this.i_result;
        }

        public ENUMFileMode getFileMode() {
            return this.i_fileMode;
        }
    }

    public static class ResultBytes {
        byte[] i_result;
        ENUMFileMode i_fileMode;

        public ResultBytes(byte[] result, ENUMFileMode fileMode) {
            this.i_result = result;
            this.i_fileMode = fileMode;
        }

        public byte[] getResult() {
            return this.i_result;
        }

        public ENUMFileMode getFileMode() {
            return this.i_fileMode;
        }
    }

    public static class ResultInputStream {
        InputStream i_result;
        ENUMFileMode i_fileMode;

        public ResultInputStream(InputStream result, ENUMFileMode fileMode) {
            this.i_result = result;
            this.i_fileMode = fileMode;
        }

        public InputStream getResult() {
            return this.i_result;
        }

        public ENUMFileMode getFileMode() {
            return this.i_fileMode;
        }
    }
}

