/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util.tempfile;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.eclnt.jsfserver.util.CCServletBaseWithContextMgmt;
import org.eclnt.jsfserver.util.ICCServerConstants;
import org.eclnt.jsfserver.util.ServletUtil;
import org.eclnt.jsfserver.util.SystemXml;
import org.eclnt.jsfserver.util.tempfile.TempFileManager;
import org.eclnt.util.file.FileManager;
import org.eclnt.util.valuemgmt.ValueManager;

public class TempFileAccessServlet
extends CCServletBaseWithContextMgmt
implements ICCServerConstants {
    @Override
    protected boolean checkIfToAbortOnMissingHttpSession(HttpServletRequest req) {
        String uri = req.getRequestURI();
        return !uri.contains("CROSS_SESSION");
    }

    @Override
    protected void processRequest(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HttpSession session = req.getSession(false);
        String path = req.getRequestURI();
        int index = path.indexOf(";");
        if (index >= 0) {
            path = path.substring(0, index);
        }
        if ((index = path.indexOf("/cctempfileaccess/")) < 0) {
            throw new Error("Could not find /cctempfileaccess/ in URI. " + path);
        }
        path = path.substring(index + "/cctempfileaccess/".length());
        path = ServletUtil.decodeURL(path);
        String sessionId4Access = null;
        if (path.contains("CROSS_SESSION")) {
            sessionId4Access = "CROSS_SESSION";
        } else if (session != null) {
            sessionId4Access = session.getId();
        } else {
            throw new Error("Could not resolve session information for access to TempFileManager");
        }
        String filePath = TempFileManager.findTempFilePath(sessionId4Access, path);
        String dirOfFilePath = new File(filePath).getParentFile().getAbsolutePath();
        if (!FileManager.checkIfFileExists(dirOfFilePath) && !ValueManager.checkIfStringsAreEqual(sessionId4Access, "CROSS_SESSION")) {
            sessionId4Access = "CROSS_SESSION";
            filePath = TempFileManager.findTempFilePath(sessionId4Access, path);
            dirOfFilePath = new File(filePath).getParentFile().getAbsolutePath();
        }
        if (!FileManager.checkIfFileExists(dirOfFilePath)) {
            throw new Error("Could not find temp file for path: " + filePath);
        }
        String contentTypeStored = TempFileManager.findTempFileContentType(filePath = TempFileManager.updateFilePathToOverComeDifferentFileNames(filePath));
        if (contentTypeStored != null) {
            this.setContentTypeInResponse(contentTypeStored, resp);
        } else {
            this.setContentType(path, resp);
        }
        ServletUtil.setResponseHeader(resp, "X-Frame-Options", SystemXml.getCcembeddedcontentTempfilecontentXframeoptions());
        InputStream fis = null;
        ServletOutputStream sos = null;
        try {
            fis = FileManager.readFileInputStream(filePath, true);
            sos = resp.getOutputStream();
            byte[] buffer = new byte[1024];
            int length = 0;
            while ((length = fis.read(buffer)) > 0) {
                sos.write(buffer, 0, length);
            }
        }
        catch (Throwable t) {
            throw new Error("Problem processing path: " + path, t);
        }
        finally {
            try {
                fis.close();
            }
            catch (Throwable buffer) {}
        }
    }
}

