/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util.useraccess;

import org.eclnt.jsfserver.util.useraccess.ITenantAccess;
import org.eclnt.jsfserver.util.useraccess.impl.DummyTenantInfoProviderImpl;
import org.eclnt.util.classloaderaccess.ClassLoaderAccess;
import org.eclnt.util.log.ULog;

public class TenantAccessMgr {
    static IInfoProvider s_infoProvider = new DummyTenantInfoProviderImpl();
    static Object s_syncher = new Object();
    static ITenantAccess s_instance;
    static ClassLoader s_lastClassLoader;

    public static void initializeInfoProvider(IInfoProvider infoProvider) {
        s_infoProvider = infoProvider;
        s_instance = null;
        s_lastClassLoader = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ITenantAccess getInstance() {
        if (s_infoProvider == null) {
            throw new Error("TenantAccessMgr not yet configured - info provider not set.");
        }
        if (s_instance != null && s_lastClassLoader == ClassLoaderAccess.currentClassLoader()) {
            return s_instance;
        }
        Object object = s_syncher;
        synchronized (object) {
            if (s_instance != null && s_lastClassLoader == ClassLoaderAccess.currentClassLoader()) {
                return s_instance;
            }
            try {
                s_instance = s_infoProvider.createTenantAccess();
                s_lastClassLoader = ClassLoaderAccess.currentClassLoader();
                return s_instance;
            }
            catch (Throwable t) {
                ULog.logERR("Problems creating the tenant access management", t);
                s_lastClassLoader = ClassLoaderAccess.currentClassLoader();
                return null;
            }
        }
    }

    public static String getCurrentTenant() {
        ITenantAccess ta = TenantAccessMgr.getInstance();
        if (ta == null) {
            return "undefined";
        }
        return ta.getCurrentTenant();
    }

    public static interface IInfoProvider {
        public ITenantAccess createTenantAccess();
    }
}

