/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util.useraccess;

import org.eclnt.jsfserver.util.useraccess.IUserAccess;
import org.eclnt.jsfserver.util.useraccess.impl.DummyUserInfoProviderImpl;
import org.eclnt.util.classloaderaccess.ClassLoaderAccess;
import org.eclnt.util.log.ULog;

public class UserAccessMgr {
    static IInfoProvider s_infoProvider = new DummyUserInfoProviderImpl();
    static Object s_syncher = new Object();
    static IUserAccess s_instance;
    static ClassLoader s_lastClassLoader;

    public static void initializeInfoProvider(IInfoProvider infoProvider) {
        s_infoProvider = infoProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IUserAccess getInstance() {
        if (s_infoProvider == null) {
            throw new Error("UserAccessMgr not yet configured - info provider not set.");
        }
        if (s_lastClassLoader == ClassLoaderAccess.currentClassLoader()) {
            return s_instance;
        }
        Object object = s_syncher;
        synchronized (object) {
            if (s_lastClassLoader == ClassLoaderAccess.currentClassLoader()) {
                return s_instance;
            }
            try {
                s_instance = s_infoProvider.createUserAccess();
                s_lastClassLoader = ClassLoaderAccess.currentClassLoader();
                return s_instance;
            }
            catch (Throwable t) {
                ULog.logERR("Problems creating the user access management", t);
                s_lastClassLoader = ClassLoaderAccess.currentClassLoader();
                return null;
            }
        }
    }

    public static String getCurrentUser() {
        IUserAccess ua = UserAccessMgr.getInstance();
        if (ua == null) {
            return "undefined";
        }
        return ua.getCurrentUser();
    }

    public static interface IInfoProvider {
        public IUserAccess createUserAccess();
    }
}

