/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.tool;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclnt.util.file.ClassloaderReader;

public class BuildCSSViaXMLTransfer {
    public static void main(String[] args) {
        try {
            String css = new ClassloaderReader().readUTF8File("org/eclnt/tool/BuildCSSViaXMLTransfer.txt", true);
            css = css.replace("\r", "");
            ArrayList<String> lines = new ArrayList<String>();
            StringTokenizer t = new StringTokenizer(css, "\n");
            while (t.hasMoreTokens()) {
                lines.add(t.nextToken());
            }
            BuildCSSViaXMLTransfer.processLines(lines);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static void processLines(List<String> lines) {
        StringBuffer sb = new StringBuffer();
        ArrayList<String> classLines = new ArrayList<String>();
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i).trim();
            if (line.length() == 0) continue;
            classLines.add(line);
            if (!line.equals("}")) continue;
            BuildCSSViaXMLTransfer.processClass(classLines, sb);
            classLines.clear();
        }
        System.out.println("\n\n\n==========================\n\n\n");
        System.out.println(sb);
    }

    private static void processClass(List<String> lines, StringBuffer sb) {
        try {
            System.out.println("---------------------------------------------");
            for (String line : lines) {
                System.out.println(line);
            }
            String name = lines.get(0).trim().substring(1);
            sb.append("    <class n=\"" + name + "\">\n");
            int lastRISCLine = BuildCSSViaXMLTransfer.processClassRisc(lines, sb);
            BuildCSSViaXMLTransfer.processClassStyle(lines, lastRISCLine, sb);
            sb.append("    </class>\n");
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new Error(t);
        }
    }

    private static int processClassRisc(List<String> lines, StringBuffer sb) {
        String line1 = lines.get(1).trim();
        if ("/*{RISC".equals(line1)) {
            String condition = null;
            for (int i = 2; i < lines.size(); ++i) {
                String line = lines.get(i).trim();
                if ("RISC}*/".equals(line)) {
                    return i;
                }
                if ("@rounded_begin@".equals(line)) {
                    condition = "@rounded@";
                    continue;
                }
                if ("@edged_begin@".equals(line)) {
                    condition = "@edged@";
                    continue;
                }
                if ("@rounded_end@".equals(line)) {
                    condition = null;
                    continue;
                }
                if ("@edged_end@".equals(line)) {
                    condition = null;
                    continue;
                }
                List<String> nvps = BuildCSSViaXMLTransfer.findNameValuePairs(line);
                for (String nvp : nvps) {
                    int colIndex = nvp.indexOf(58);
                    String left = nvp.substring(0, colIndex).trim();
                    String right = nvp.substring(colIndex + 1).replace(";", "").replace("\"", "&quot;").trim();
                    sb.append("        <risc");
                    if (condition != null) {
                        sb.append(" condition=\"" + condition + "\"");
                    }
                    sb.append(" n=\"" + left + "\" v=\"" + right + "\"/>\n");
                }
            }
            return lines.size();
        }
        return -1;
    }

    private static void processClassStyle(List<String> lines, int lastRISCline, StringBuffer sb) {
        int startIndex = lastRISCline + 2;
        if (startIndex <= 1) {
            startIndex = 2;
        }
        String condition = null;
        for (int i = startIndex; i < lines.size(); ++i) {
            String line = lines.get(i).trim();
            System.out.println("Processing line: >" + line + "<");
            if ("}".equals(line)) {
                return;
            }
            if ("@rounded_begin@".equals(line)) {
                condition = "@rounded@";
                continue;
            }
            if ("@edged_begin@".equals(line)) {
                condition = "@edged@";
                continue;
            }
            if ("@rounded_end@".equals(line)) {
                condition = null;
                continue;
            }
            if ("@edged_end@".equals(line)) {
                condition = null;
                continue;
            }
            List<String> nvps = BuildCSSViaXMLTransfer.findNameValuePairs(line);
            for (String nvp : nvps) {
                int colIndex = nvp.indexOf(58);
                String left = nvp.substring(0, colIndex).trim();
                String right = nvp.substring(colIndex + 1).replace(";", "").replace("\"", "&quot;").trim();
                sb.append("        <style");
                if (condition != null) {
                    sb.append(" condition=\"" + condition + "\"");
                }
                sb.append(" n=\"" + left + "\" v=\"" + right + "\"/>\n");
            }
        }
    }

    private static List<String> findNameValuePairs(String line) {
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer t = new StringTokenizer(line, ";");
        while (t.hasMoreTokens()) {
            String nvp = t.nextToken().trim();
            if (nvp.length() <= 0) continue;
            result.add(nvp);
        }
        return result;
    }
}

