/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.util.buffermgmt;

import java.beans.Introspector;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclnt.jsfserver.util.BeanIntrospector;
import org.eclnt.util.buffermgmt.IResetBuffer;
import org.eclnt.util.log.ULog;

public class ResetBuffers {
    static long s_lastHotSwapChangeIndex = 0L;
    static Set<IResetBuffer> s_resetBuffersClasses = new HashSet<IResetBuffer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListenerClassSwap(IResetBuffer resetBuffer) {
        Set<IResetBuffer> set = s_resetBuffersClasses;
        synchronized (set) {
            s_resetBuffersClasses.add(resetBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeListenerClassSwap(IResetBuffer resetBuffer) {
        Set<IResetBuffer> set = s_resetBuffersClasses;
        synchronized (set) {
            s_resetBuffersClasses.remove(resetBuffer);
        }
    }

    public static void resetBuffers() {
        if (ResetBuffers.checkIfClassesWereHotSwapped()) {
            ResetBuffers.resetClassRelatedBuffers();
        }
    }

    private static void resetClassRelatedBuffers() {
        System.out.println("***** HOTSWAP: CCResetBuffers: reset class related buffers was triggered, " + s_lastHotSwapChangeIndex);
        try {
            Introspector.flushCaches();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            BeanIntrospector.resetBuffers();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ArrayList<IResetBuffer> l = new ArrayList<IResetBuffer>(s_resetBuffersClasses);
        for (IResetBuffer rb : l) {
            try {
                rb.reset();
            }
            catch (Throwable t) {
                ULog.logWAR("Problem occurred when resetting buffer: " + rb.getClass().getName(), t);
            }
        }
    }

    private static boolean checkIfClassesWereHotSwapped() {
        try {
            String pluginClassName = "org.eclnt.eclnthotswap.CCHotswapPlugin";
            Class<?> c = Class.forName(pluginClassName);
            if (c != null) {
                long l;
                Object mResult;
                System.out.println("CCResetBuffers.checkIfClassesWereHotSwapped: " + c.getClassLoader());
                Method m = c.getMethod("getCurrentChangeIndex", new Class[0]);
                if (m != null && (mResult = m.invoke(null, new Object[0])) != null && mResult instanceof Long && (l = ((Long)mResult).longValue()) != s_lastHotSwapChangeIndex) {
                    System.out.println("CCResetBuffers.checkIfClassesWereHotSwapped: " + l);
                    s_lastHotSwapChangeIndex = l;
                    return true;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }
}

