/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.util.chart.util;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.eclnt.util.chart.CategoryChart;
import org.eclnt.util.chart.CategoryChartAnnotation;
import org.eclnt.util.chart.CategoryChartDataPoint;
import org.eclnt.util.chart.CategoryChartInfo;
import org.eclnt.util.chart.CategoryChartLine;
import org.eclnt.util.chart.Chart;
import org.eclnt.util.chart.ChartAnnotation;
import org.eclnt.util.chart.ChartInfo;
import org.eclnt.util.chart.ChartLine;
import org.eclnt.util.chart.ChartMarker;
import org.eclnt.util.chart.ChartYMarker;
import org.eclnt.util.chart.IChartConstants;
import org.eclnt.util.chart.PieChart;
import org.eclnt.util.chart.PieChartDataPoint;
import org.eclnt.util.chart.PieChartInfo;
import org.eclnt.util.chart.PieChartLine;
import org.eclnt.util.chart.TimeBasedChart;
import org.eclnt.util.chart.TimeBasedChartAnnotation;
import org.eclnt.util.chart.TimeBasedChartDataPoint;
import org.eclnt.util.chart.TimeBasedChartInfo;
import org.eclnt.util.chart.TimeBasedChartLine;
import org.eclnt.util.chart.TimeBasedChartXMarker;
import org.eclnt.util.chart.XYChart;
import org.eclnt.util.chart.XYChartAnnotation;
import org.eclnt.util.chart.XYChartDataPoint;
import org.eclnt.util.chart.XYChartInfo;
import org.eclnt.util.chart.XYChartLine;
import org.eclnt.util.chart.XYChartXMarker;
import org.eclnt.util.chart.clientutil.CCChartPanel;
import org.eclnt.util.chart.util.CylinderRenderer;
import org.eclnt.util.chart.util.LegendItem;
import org.eclnt.util.chart.util.LegendUtil;
import org.eclnt.util.chart.util.ReferencedCategoryDataset;
import org.eclnt.util.chart.util.ReferencedTimeSeriesCollection;
import org.eclnt.util.chart.util.ReferencedTimeSeriesDataItem;
import org.eclnt.util.chart.util.ReferencedXYDataItem;
import org.eclnt.util.chart.util.ReferencedXYSeriesCollection;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.ValueManager;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardChartTheme;
import org.jfree.chart.annotations.CategoryAnnotation;
import org.jfree.chart.annotations.CategoryPointerAnnotation;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYPointerAnnotation;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.StandardEntityCollection;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.MultiplePiePlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.AreaRenderer;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.BarRenderer3D;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.renderer.category.LineRenderer3D;
import org.jfree.chart.renderer.category.StackedAreaRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLine3DRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.renderer.xy.XYSplineRenderer;
import org.jfree.chart.renderer.xy.XYStepRenderer;
import org.jfree.chart.urls.CategoryURLGenerator;
import org.jfree.chart.urls.StandardCategoryURLGenerator;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesDataItem;
import org.jfree.data.xy.XYDataItem;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.ui.Layer;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.TextAnchor;
import org.jfree.util.TableOrder;

public class JFreeChartRenderer
implements IChartConstants {
    String[] m_defaultColors = new String[]{"#800000", "#008000", "#000080", "#808000", "#008080", "#800080", "#808080", "#FF0000", "#00FF00", "#0000FF", "#FFFF00", "#00FFFF", "#FF00FF"};
    int m_defaultColorCounter = 0;
    int m_markerCounter = 0;
    List<List<LegendItem>> m_legends = new ArrayList<List<LegendItem>>();
    ChartInfo m_renderedChartInfo;
    JFreeChart m_renderedChart;

    public List<List<LegendItem>> getLegends() {
        return this.m_legends;
    }

    public CCChartPanel renderChart(ChartInfo chartInfo) {
        try {
            JFreeChart chart = null;
            if (chartInfo instanceof TimeBasedChartInfo) {
                chart = this.renderTimeBasedChart((TimeBasedChartInfo)chartInfo);
            } else if (chartInfo instanceof CategoryChartInfo) {
                chart = this.renderCategoryChart((CategoryChartInfo)chartInfo);
            } else if (chartInfo instanceof PieChartInfo) {
                chart = this.renderPieChart((PieChartInfo)chartInfo);
            } else if (chartInfo instanceof XYChartInfo) {
                chart = this.renderXYChart((XYChartInfo)chartInfo);
            }
            if (chart == null) {
                throw new Exception();
            }
            chart.setBackgroundPaint((Paint)ValueManager.decodeColor("#FFFFFF"));
            CCChartPanel result = new CCChartPanel(chart);
            result.setRangeZoomable(chartInfo.getYZoom());
            result.setDomainZoomable(chartInfo.getXZoom());
            this.m_renderedChart = chart;
            this.m_renderedChartInfo = chartInfo;
            return result;
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "", t);
            this.m_renderedChart = null;
            this.m_renderedChartInfo = null;
            return null;
        }
    }

    private JFreeChart renderTimeBasedChart(TimeBasedChartInfo chartInfo) {
        ArrayList<ReferencedTimeSeriesCollection> dataSets = new ArrayList<ReferencedTimeSeriesCollection>();
        int chartCounter = 0;
        for (TimeBasedChart chart : chartInfo.getCharts()) {
            ReferencedTimeSeriesCollection tsc = this.buildReferencedTimeSeriesCollection(chart);
            dataSets.add(tsc);
            ++chartCounter;
        }
        if (chartCounter == 0) {
            throw new Error("No chart contained");
        }
        JFreeChart result = ChartFactory.createTimeSeriesChart((String)chartInfo.getName(), (String)chartInfo.getXAxisName(), (String)"", (XYDataset)((XYDataset)dataSets.get(0)), (boolean)chartInfo.getWithLegend(), (boolean)chartInfo.getWithTooltips(), (boolean)false);
        XYPlot plot = (XYPlot)result.getPlot();
        JFreeChartRenderer.applyPlotInfo(chartInfo, (Plot)plot);
        DateAxis dateAxis = (DateAxis)plot.getDomainAxis();
        if (chartInfo.getDateFormat() != null) {
            dateAxis.setDateFormatOverride((DateFormat)new SimpleDateFormat(chartInfo.getDateFormat()));
        }
        if (chartInfo.getLowerBound() != null) {
            dateAxis.setLowerBound((double)chartInfo.getLowerBound().getTime());
        }
        if (chartInfo.getUpperBound() != null) {
            dateAxis.setUpperBound((double)chartInfo.getUpperBound().getTime());
        }
        dateAxis.setVerticalTickLabels(true);
        for (int i = 0; i < chartCounter; ++i) {
            ValueAxis axis;
            TimeBasedChart chart = chartInfo.getCharts().get(i);
            if (i >= 1) {
                axis = new NumberAxis();
                plot.setRangeAxis(i, axis);
                plot.setRangeAxisLocation(1, AxisLocation.BOTTOM_OR_RIGHT);
                plot.setDataset(i, (XYDataset)dataSets.get(i));
                plot.mapDatasetToRangeAxis(i, i);
                this.applyAxisInfo(chart, axis);
            } else {
                axis = plot.getRangeAxis();
                this.applyAxisInfo(chart, axis);
            }
            XYLineAndShapeRenderer renderer = JFreeChartRenderer.createLineRenderer(chart);
            for (int j = 0; j < chart.getLines().size(); ++j) {
                TimeBasedChartLine line = (TimeBasedChartLine)chart.getLines().get(j);
                this.applyLineInfo(renderer, line, j, i);
            }
            plot.setRenderer(i, (XYItemRenderer)renderer);
            List<ChartYMarker> ymarkers = chart.getYmarkers();
            this.applyYmarkers(ymarkers, (Plot)plot, i);
            List<TimeBasedChartAnnotation> annotations = chart.getAnnotations();
            for (TimeBasedChartAnnotation annotation : annotations) {
                XYPointerAnnotation a = new XYPointerAnnotation(annotation.getText(), (double)annotation.getTime().getTime(), annotation.getY().doubleValue(), 2.356194490192345);
                this.applyAnnotationInfo(annotation, a);
                renderer.addAnnotation((XYAnnotation)a);
            }
        }
        for (TimeBasedChartXMarker marker : chartInfo.getXmarkers()) {
            Second markedSecond = new Second(marker.getTime());
            ValueMarker vm = new ValueMarker((double)markedSecond.getFirstMillisecond());
            this.applyMarkerInfo((Marker)vm, marker, true);
            plot.addDomainMarker((Marker)vm, Layer.FOREGROUND);
        }
        return result;
    }

    private ReferencedTimeSeriesCollection buildReferencedTimeSeriesCollection(TimeBasedChart chart) {
        TimeZone tz = TimeZone.getDefault();
        if (chart.getTimeZone() != null) {
            tz = TimeZone.getTimeZone(chart.getTimeZone());
        }
        ReferencedTimeSeriesCollection result = new ReferencedTimeSeriesCollection(tz, chart.getId());
        for (TimeBasedChartLine line : chart.getLines()) {
            String lineKey = line.getLineCategory();
            if (lineKey == null) {
                lineKey = line.getName();
            }
            TimeSeries ts = new TimeSeries((Comparable)((Object)lineKey));
            for (TimeBasedChartDataPoint point : line.getPoints()) {
                Millisecond s = new Millisecond(point.getTime());
                ts.add((TimeSeriesDataItem)new ReferencedTimeSeriesDataItem(point.getId(), (RegularTimePeriod)s, point.getValue()));
            }
            result.addSeries(ts);
        }
        return result;
    }

    private JFreeChart renderXYChart(XYChartInfo chartInfo) {
        ArrayList<ReferencedXYSeriesCollection> dataSets = new ArrayList<ReferencedXYSeriesCollection>();
        int chartCounter = 0;
        for (XYChart chart : chartInfo.getCharts()) {
            ReferencedXYSeriesCollection tsc = this.buildReferencedXYSeriesCollection(chart);
            dataSets.add(tsc);
            ++chartCounter;
        }
        if (chartCounter == 0) {
            throw new Error("No chart contained");
        }
        JFreeChart result = ChartFactory.createXYLineChart((String)chartInfo.getName(), (String)chartInfo.getXAxisName(), (String)"", (XYDataset)((XYDataset)dataSets.get(0)), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)chartInfo.getWithLegend(), (boolean)chartInfo.getWithTooltips(), (boolean)false);
        XYPlot plot = (XYPlot)result.getPlot();
        ValueAxis domainAxis = plot.getDomainAxis();
        if (chartInfo.getLowerBound() != null) {
            domainAxis.setLowerBound(chartInfo.getLowerBound().doubleValue());
        }
        if (chartInfo.getUpperBound() != null) {
            domainAxis.setUpperBound(chartInfo.getUpperBound().doubleValue());
        }
        JFreeChartRenderer.applyPlotInfo(chartInfo, (Plot)plot);
        for (int i = 0; i < chartCounter; ++i) {
            ValueAxis axis;
            XYChart chart = chartInfo.getCharts().get(i);
            if (i >= 1) {
                axis = new NumberAxis(chart.getName());
                plot.setRangeAxis(i, axis);
                plot.setRangeAxisLocation(1, AxisLocation.BOTTOM_OR_RIGHT);
                plot.setDataset(i, (XYDataset)dataSets.get(i));
                plot.mapDatasetToRangeAxis(i, i);
                this.applyAxisInfo(chart, axis);
            } else {
                axis = plot.getRangeAxis(i);
                this.applyAxisInfo(chart, axis);
            }
            XYLineAndShapeRenderer renderer = JFreeChartRenderer.createLineRenderer(chart);
            for (int j = 0; j < chart.getLines().size(); ++j) {
                XYChartLine line = (XYChartLine)chart.getLines().get(j);
                this.applyLineInfo(renderer, line, j, i);
            }
            plot.setRenderer(i, (XYItemRenderer)renderer);
            List<ChartYMarker> ymarkers = chart.getYmarkers();
            this.applyYmarkers(ymarkers, (Plot)plot, i);
            List<XYChartAnnotation> annotations = chart.getAnnotations();
            for (XYChartAnnotation annotation : annotations) {
                XYPointerAnnotation a = new XYPointerAnnotation(annotation.getText(), annotation.getX().doubleValue(), annotation.getY().doubleValue(), 2.356194490192345);
                this.applyAnnotationInfo(annotation, a);
                renderer.addAnnotation((XYAnnotation)a);
            }
        }
        for (XYChartXMarker marker : chartInfo.getXmarkers()) {
            ValueMarker vm = new ValueMarker(marker.getX().doubleValue());
            this.applyMarkerInfo((Marker)vm, marker, true);
            plot.addDomainMarker((Marker)vm, Layer.FOREGROUND);
        }
        return result;
    }

    private void applyYmarkers(List<ChartYMarker> ymarkers, Plot plot, int chartIndex) {
        for (ChartYMarker ymarker : ymarkers) {
            ValueMarker vm = new ValueMarker(ymarker.getY().doubleValue());
            this.applyMarkerInfo((Marker)vm, ymarker, false);
            if (plot instanceof XYPlot) {
                ((XYPlot)plot).addRangeMarker(chartIndex, (Marker)vm, Layer.FOREGROUND);
            }
            if (!(plot instanceof CategoryPlot)) continue;
            ((CategoryPlot)plot).addRangeMarker(chartIndex, (Marker)vm, Layer.FOREGROUND);
        }
    }

    private void applyMarkerInfo(Marker vm, ChartMarker marker, boolean xMarker) {
        vm.setStroke((Stroke)new BasicStroke(marker.getStroke()));
        vm.setLabel(marker.getText());
        vm.setLabelFont(new Font("Dialog", 1, 11));
        vm.setLabelTextAnchor(TextAnchor.TOP_LEFT);
        if (marker.getColor() == null) {
            vm.setLabelPaint((Paint)Color.RED);
            vm.setPaint((Paint)Color.RED);
        } else {
            vm.setLabelPaint((Paint)ValueManager.decodeColor(marker.getColor(), "#FF0000"));
            vm.setPaint((Paint)ValueManager.decodeColor(marker.getColor(), "#FF0000"));
        }
        if (xMarker) {
            vm.setLabelOffset(new RectangleInsets((double)(this.m_markerCounter * 13), -2.0, 0.0, 0.0));
            ++this.m_markerCounter;
        } else {
            vm.setLabelOffset(new RectangleInsets(0.0, -2.0, 0.0, 0.0));
        }
        vm.setAlpha(0.5f);
    }

    private ReferencedXYSeriesCollection buildReferencedXYSeriesCollection(XYChart chart) {
        ReferencedXYSeriesCollection result = new ReferencedXYSeriesCollection(chart.getId());
        for (XYChartLine line : chart.getLines()) {
            String lineKey = line.getLineCategory();
            if (lineKey == null) {
                lineKey = line.getName();
            }
            XYSeries ts = new XYSeries((Comparable)((Object)lineKey));
            for (XYChartDataPoint point : line.getPoints()) {
                ts.add((XYDataItem)new ReferencedXYDataItem(point.getId(), point.getX(), point.getY()));
            }
            result.addSeries(ts);
        }
        return result;
    }

    private JFreeChart renderCategoryChart(CategoryChartInfo chartInfo) {
        ArrayList<ReferencedCategoryDataset> dataSets = new ArrayList<ReferencedCategoryDataset>();
        int chartCounter = 0;
        for (CategoryChart chart : chartInfo.getCharts()) {
            ReferencedCategoryDataset tsc = this.buildCategoryDataset(chart);
            dataSets.add(tsc);
            ++chartCounter;
        }
        if (chartCounter == 0) {
            throw new Error("No chart contained");
        }
        JFreeChart result = this.createCategoryFreeChart(chartInfo.getName(), chartInfo.getXAxisName(), "", (CategoryDataset)dataSets.get(0), PlotOrientation.VERTICAL, chartInfo.getWithLegend(), chartInfo.getWithTooltips(), false, chartInfo.getCharts().get(0).getLineType());
        CategoryPlot plot = (CategoryPlot)result.getPlot();
        JFreeChartRenderer.applyPlotInfo(chartInfo, (Plot)plot);
        for (int i = 0; i < chartCounter; ++i) {
            ValueAxis axis;
            CategoryChart chart = chartInfo.getCharts().get(i);
            if (i >= 1) {
                axis = new NumberAxis(chart.getName());
                plot.setRangeAxis(i, axis);
                plot.setRangeAxisLocation(1, AxisLocation.BOTTOM_OR_RIGHT);
                plot.setDataset(i, (CategoryDataset)dataSets.get(i));
                plot.mapDatasetToRangeAxis(i, i);
                plot.setDatasetRenderingOrder(DatasetRenderingOrder.FORWARD);
                this.applyAxisInfo(chart, axis);
            } else {
                axis = plot.getRangeAxis();
                this.applyAxisInfo(chart, axis);
            }
            CategoryItemRenderer renderer = i >= 1 ? this.createRenderer(chart.getLineType()) : plot.getRenderer(0);
            for (int j = 0; j < chart.getLines().size(); ++j) {
                CategoryChartLine line = (CategoryChartLine)chart.getLines().get(j);
                this.applyLineInfo(renderer, line, j, i);
            }
            plot.setRenderer(i, renderer);
            List<ChartYMarker> ymarkers = chart.getYmarkers();
            this.applyYmarkers(ymarkers, (Plot)plot, i);
            List<CategoryChartAnnotation> annotations = chart.getAnnotations();
            for (CategoryChartAnnotation annotation : annotations) {
                CategoryPointerAnnotation a = new CategoryPointerAnnotation(annotation.getText(), (Comparable)((Object)annotation.getPointCategory()), annotation.getY().doubleValue(), 2.356194490192345);
                this.applyAnnotationInfo(annotation, a);
                plot.addAnnotation((CategoryAnnotation)a);
            }
        }
        return result;
    }

    private ReferencedCategoryDataset buildCategoryDataset(CategoryChart chart) {
        ReferencedCategoryDataset result = new ReferencedCategoryDataset(chart.getId());
        for (CategoryChartLine line : chart.getLines()) {
            for (CategoryChartDataPoint point : line.getPoints()) {
                result.addValue(point.getValue(), (Comparable)((Object)line.getLineCategory()), (Comparable)((Object)point.getPointCategory()));
            }
        }
        return result;
    }

    private JFreeChart renderPieChart(PieChartInfo chartInfo) {
        boolean chartCounter = false;
        PieChart chart = chartInfo.getChart();
        ReferencedCategoryDataset dataSet = this.buildPieDataset(chart);
        JFreeChart result = ChartFactory.createMultiplePieChart((String)chartInfo.getName(), (CategoryDataset)dataSet, (TableOrder)TableOrder.BY_ROW, (boolean)chartInfo.getWithLegend(), (boolean)chartInfo.getWithTooltips(), (boolean)false);
        MultiplePiePlot plot = (MultiplePiePlot)result.getPlot();
        JFreeChartRenderer.applyPlotInfo(chartInfo, (Plot)plot);
        JFreeChart subchart = plot.getPieChart();
        PiePlot piePlot = (PiePlot)subchart.getPlot();
        JFreeChartRenderer.applyPlotInfo(chartInfo, (Plot)piePlot);
        int numberOfPoints = dataSet.getColumnCount();
        for (int i = 0; i < numberOfPoints; ++i) {
            Comparable sectionKey = dataSet.getColumnKey(i);
            piePlot.setSectionPaint(sectionKey, (Paint)this.nextDefaultColor(null));
            piePlot.setExplodePercent(sectionKey, (double)0.1f);
        }
        return result;
    }

    private ReferencedCategoryDataset buildPieDataset(PieChart chart) {
        ReferencedCategoryDataset result = new ReferencedCategoryDataset(chart.getId());
        for (PieChartLine line : chart.getLines()) {
            for (PieChartDataPoint point : line.getPoints()) {
                result.addValue(point.getValue(), (Comparable)((Object)line.getLineCategory()), (Comparable)((Object)point.getPointCategory()));
            }
        }
        return result;
    }

    private Color nextDefaultColor(String colorString) {
        if (colorString != null) {
            return ValueManager.decodeColor(colorString);
        }
        Color result = Color.GRAY;
        if (this.m_defaultColorCounter < this.m_defaultColors.length) {
            result = ValueManager.decodeColor(this.m_defaultColors[this.m_defaultColorCounter]);
            ++this.m_defaultColorCounter;
        }
        return result;
    }

    public JFreeChart createCategoryFreeChart(String title, String categoryAxisLabel, String valueAxisLabel, CategoryDataset dataset, PlotOrientation orientation, boolean legend, boolean tooltips, boolean urls, String lineType) {
        ItemLabelPosition position2;
        ItemLabelPosition position1;
        StandardChartTheme currentTheme = new StandardChartTheme("JFree");
        if (orientation == null) {
            throw new IllegalArgumentException("Null 'orientation' argument.");
        }
        CategoryAxis categoryAxis = new CategoryAxis(categoryAxisLabel);
        NumberAxis valueAxis = new NumberAxis(valueAxisLabel);
        this.applyCategoryAxisInfo(categoryAxis, lineType);
        this.applyValueAxisInfo((ValueAxis)valueAxis, lineType);
        CategoryItemRenderer renderer = this.createRenderer(lineType);
        if (orientation == PlotOrientation.HORIZONTAL) {
            position1 = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE3, TextAnchor.CENTER_LEFT);
            renderer.setBasePositiveItemLabelPosition(position1);
            position2 = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE9, TextAnchor.CENTER_RIGHT);
            renderer.setBaseNegativeItemLabelPosition(position2);
        } else if (orientation == PlotOrientation.VERTICAL) {
            position1 = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.BOTTOM_CENTER);
            renderer.setBasePositiveItemLabelPosition(position1);
            position2 = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE6, TextAnchor.TOP_CENTER);
            renderer.setBaseNegativeItemLabelPosition(position2);
        }
        if (tooltips) {
            renderer.setBaseToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
        }
        if (urls) {
            renderer.setBaseItemURLGenerator((CategoryURLGenerator)new StandardCategoryURLGenerator());
        }
        CategoryPlot plot = new CategoryPlot(dataset, categoryAxis, (ValueAxis)valueAxis, renderer);
        plot.setOrientation(orientation);
        this.applyPlotInfo(plot, lineType);
        JFreeChart chart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, legend);
        currentTheme.apply(chart);
        return chart;
    }

    private void applyAnnotationInfo(ChartAnnotation annotation, Object a) {
        if (a instanceof XYPointerAnnotation) {
            ((XYPointerAnnotation)a).setArrowPaint((Paint)ValueManager.decodeColor(annotation.getColor(), "#000000"));
            ((XYPointerAnnotation)a).setPaint((Paint)ValueManager.decodeColor(annotation.getColor(), "#000000"));
            ((XYPointerAnnotation)a).setLabelOffset(10.0);
            if (annotation.getAngle() != 0.0) {
                ((XYPointerAnnotation)a).setAngle(annotation.getAngle());
            }
        }
        if (a instanceof CategoryPointerAnnotation) {
            ((CategoryPointerAnnotation)a).setArrowPaint((Paint)ValueManager.decodeColor(annotation.getColor(), "#000000"));
            ((CategoryPointerAnnotation)a).setPaint((Paint)ValueManager.decodeColor(annotation.getColor(), "#000000"));
            ((CategoryPointerAnnotation)a).setLabelOffset(10.0);
            if (annotation.getAngle() != 0.0) {
                ((CategoryPointerAnnotation)a).setAngle(annotation.getAngle());
            }
        }
    }

    private void applyPlotInfo(CategoryPlot plot, String lineType) {
        if ("barcylinder".equals(lineType)) {
            plot.setForegroundAlpha(0.75f);
        }
    }

    private void applyValueAxisInfo(ValueAxis axis, String lineType) {
    }

    private void applyCategoryAxisInfo(CategoryAxis axis, String lineType) {
        if ("area".equals(lineType)) {
            axis.setCategoryMargin(0.0);
        }
    }

    private CategoryItemRenderer createRenderer(String lineType) {
        Object renderer = new BarRenderer();
        if ("bar".equals(lineType)) {
            renderer = new BarRenderer();
        } else if ("bar3d".equals(lineType)) {
            renderer = new BarRenderer3D();
        } else if ("barcylinder".equals(lineType)) {
            renderer = new CylinderRenderer();
        } else if ("line".equals(lineType)) {
            renderer = new LineAndShapeRenderer();
        } else if ("line3d".equals(lineType)) {
            renderer = new LineRenderer3D();
        } else if ("area".equals(lineType)) {
            renderer = new AreaRenderer();
        } else if ("stackedbar".equals(lineType)) {
            renderer = new StackedBarRenderer();
        } else if ("stackedarea".equals(lineType)) {
            renderer = new StackedAreaRenderer();
        }
        return renderer;
    }

    private static void applyPlotInfo(ChartInfo chartInfo, Plot plot) {
        Color background = ValueManager.decodeColor(chartInfo.getBackgroundColor(), "#00000020");
        plot.setBackgroundPaint((Paint)background);
        if (plot instanceof XYPlot) {
            if ("forward".equals(chartInfo.getRenderingOrder())) {
                ((XYPlot)plot).setDatasetRenderingOrder(DatasetRenderingOrder.FORWARD);
            } else if ("reverse".equals(chartInfo.getRenderingOrder())) {
                ((XYPlot)plot).setDatasetRenderingOrder(DatasetRenderingOrder.REVERSE);
            }
            ((XYPlot)plot).setRangeGridlinePaint((Paint)ValueManager.decodeColor(chartInfo.getRangeGridlineColorY(), "#00000060"));
            ((XYPlot)plot).setDomainGridlinePaint((Paint)ValueManager.decodeColor(chartInfo.getRangeGridlineColorX(), "#00000060"));
            ((XYPlot)plot).setDomainCrosshairVisible(true);
            ((XYPlot)plot).setRangeCrosshairVisible(true);
            ((XYPlot)plot).setDomainCrosshairLockedOnData(false);
            ((XYPlot)plot).setRangeCrosshairLockedOnData(false);
        }
        if (plot instanceof CategoryPlot) {
            if ("forward".equals(chartInfo.getRenderingOrder())) {
                ((CategoryPlot)plot).setDatasetRenderingOrder(DatasetRenderingOrder.FORWARD);
            } else if ("reverse".equals(chartInfo.getRenderingOrder())) {
                ((CategoryPlot)plot).setDatasetRenderingOrder(DatasetRenderingOrder.REVERSE);
            }
            ((CategoryPlot)plot).setRangeGridlinePaint((Paint)ValueManager.decodeColor(chartInfo.getRangeGridlineColorY(), "#00000060"));
            ((CategoryPlot)plot).setDomainGridlinePaint((Paint)ValueManager.decodeColor(chartInfo.getRangeGridlineColorX(), "#00000060"));
        }
    }

    private static XYLineAndShapeRenderer createLineRenderer(Chart chart) {
        String lineType = null;
        if (chart instanceof TimeBasedChart) {
            lineType = ((TimeBasedChart)chart).getLineType();
        } else if (chart instanceof XYChart) {
            lineType = ((XYChart)chart).getLineType();
        }
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        if ("step".equals(lineType)) {
            renderer = new XYStepRenderer();
        } else if ("line3d".equals(lineType)) {
            renderer = new XYLine3DRenderer();
        } else if ("spline".equals(lineType)) {
            renderer = new XYSplineRenderer();
        }
        return renderer;
    }

    private static Shape buildShape(int shapeType) {
        if (shapeType == 0) {
            return null;
        }
        if (shapeType == 1) {
            return new Rectangle(-2, -2, 5, 5);
        }
        if (shapeType == 2) {
            return new Rectangle(-3, -3, 7, 7);
        }
        if (shapeType == 3) {
            return new Rectangle(-4, -4, 9, 9);
        }
        if (shapeType == 11) {
            return new Ellipse2D.Float(-2.0f, -2.0f, 5.0f, 5.0f);
        }
        if (shapeType == 12) {
            return new Ellipse2D.Float(-3.0f, -3.0f, 7.0f, 7.0f);
        }
        if (shapeType == 13) {
            return new Ellipse2D.Float(-4.0f, -4.0f, 9.0f, 9.0f);
        }
        if (shapeType == 21) {
            return new Polygon(new int[]{0, 2, -2}, new int[]{-2, 2, 2}, 3);
        }
        if (shapeType == 22) {
            return new Polygon(new int[]{0, 3, -3}, new int[]{-3, 3, 3}, 3);
        }
        if (shapeType == 23) {
            return new Polygon(new int[]{0, 4, -4}, new int[]{-4, 4, 4}, 3);
        }
        return null;
    }

    private void applyLineInfo(Object abstractRenderer, ChartLine line, int lineIndex, int chartIndex) {
        XYLineAndShapeRenderer renderer;
        LegendItem legendItem = new LegendItem();
        legendItem.setTexts(line.getExtLegendTexts());
        if (abstractRenderer instanceof XYLineAndShapeRenderer) {
            renderer = (XYLineAndShapeRenderer)abstractRenderer;
            Color color = this.nextDefaultColor(line.getColor());
            legendItem.setColor(ValueManager.encodeColor(color));
            renderer.setSeriesPaint(lineIndex, (Paint)color);
            renderer.setSeriesStroke(lineIndex, (Stroke)new BasicStroke(line.getStroke()), false);
            Shape shape = JFreeChartRenderer.buildShape(line.getShapeType());
            if (shape != null) {
                renderer.setSeriesShape(lineIndex, shape);
            }
            renderer.setSeriesShapesVisible(lineIndex, line.getWithShapes());
            renderer.setSeriesLinesVisible(lineIndex, line.getWithLines());
            if (line instanceof TimeBasedChartLine) {
                renderer.setBaseToolTipGenerator((XYToolTipGenerator)StandardXYToolTipGenerator.getTimeSeriesInstance());
            } else if (line instanceof XYChartLine) {
                renderer.setBaseToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator());
            }
        } else if (abstractRenderer instanceof CategoryItemRenderer) {
            renderer = (CategoryItemRenderer)abstractRenderer;
            Color color = this.nextDefaultColor(line.getColor());
            legendItem.setColor(ValueManager.encodeColor(color));
            renderer.setSeriesPaint(lineIndex, (Paint)color);
            if (renderer instanceof LineAndShapeRenderer) {
                ((LineAndShapeRenderer)renderer).setSeriesStroke(lineIndex, (Stroke)new BasicStroke(line.getStroke()), false);
                Shape shape = JFreeChartRenderer.buildShape(line.getShapeType());
                if (shape != null) {
                    ((LineAndShapeRenderer)renderer).setSeriesShape(lineIndex, shape);
                }
                ((LineAndShapeRenderer)renderer).setSeriesShapesVisible(lineIndex, line.getWithShapes());
                ((LineAndShapeRenderer)renderer).setSeriesLinesVisible(lineIndex, line.getWithLines());
            }
            renderer.setBaseToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
        }
        if (this.m_legends.size() <= chartIndex) {
            this.m_legends.add(new ArrayList());
        }
        List<LegendItem> legend = this.m_legends.get(chartIndex);
        legend.add(legendItem);
    }

    private void applyAxisInfo(Chart chart, ValueAxis axis) {
        if (chart.getName() != null) {
            axis.setLabel(chart.getName());
        }
        axis.setAutoRange(true);
        if (axis instanceof NumberAxis) {
            ((NumberAxis)axis).setAutoRangeIncludesZero(false);
        }
        if (chart.getAxisLowerBound() != null) {
            axis.setLowerBound(chart.getAxisLowerBound().doubleValue());
        }
        if (chart.getAxisUpperBound() != null) {
            axis.setUpperBound(chart.getAxisUpperBound().doubleValue());
        }
    }

    public byte[] renderPNGImage(int width, int height) throws IOException {
        return this.renderPNGImage(width, height, null, null);
    }

    public byte[] renderPNGImage(int width, int height, Double lowerX, Double upperX) throws IOException {
        if (lowerX != null) {
            try {
                ((XYPlot)this.m_renderedChart.getPlot()).getDomainAxis().setLowerBound(lowerX.doubleValue());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (upperX != null) {
            try {
                ((XYPlot)this.m_renderedChart.getPlot()).getDomainAxis().setUpperBound(upperX.doubleValue());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (!this.m_renderedChartInfo.getExtendedLegend()) {
            return this.renderPNGImageChartOnly(width, height);
        }
        int legendWidth = 100;
        int chartX = 0;
        int chartWidth = width - this.m_legends.size() * legendWidth;
        BufferedImage bim = new BufferedImage(width, height, 2);
        Graphics2D g2 = (Graphics2D)bim.getGraphics();
        int counter = 0;
        for (List<LegendItem> legend : this.m_legends) {
            int legendX = 0;
            if (counter != 0) {
                legendX = chartWidth + legendWidth * counter;
            }
            Graphics2D innerg2 = (Graphics2D)g2.create(legendX, 0, legendWidth, height);
            LegendUtil.paintLegend(innerg2, legend, legendWidth);
            ++counter;
        }
        if (this.m_legends.size() > 0) {
            chartX = legendWidth;
        }
        byte[] chartPNG = this.renderPNGImageChartOnly(chartWidth, height);
        ImageIcon imagePNG = new ImageIcon(chartPNG);
        g2.drawImage(imagePNG.getImage(), chartX, 0, null);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bim, "PNG", out);
        byte[] result = out.toByteArray();
        return result;
    }

    public byte[] renderPNGImageChartOnly(int width, int height) throws IOException {
        JFreeChart chart = this.m_renderedChart;
        ChartRenderingInfo info = new ChartRenderingInfo((EntityCollection)new StandardEntityCollection());
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ChartUtilities.writeChartAsPNG((OutputStream)bos, (JFreeChart)chart, (int)width, (int)height, (ChartRenderingInfo)info);
        return bos.toByteArray();
    }
}

