/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.util.chart.util;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.List;
import org.eclnt.util.chart.util.LegendItem;
import org.eclnt.util.valuemgmt.ValueManager;

public class LegendUtil {
    public static void paintLegend(Graphics2D g2, List<LegendItem> legendItems, int width) {
        int padding = 5;
        g2 = (Graphics2D)g2.create();
        int counter = 0;
        int yPosition = padding + 30;
        int xPosition = padding;
        for (LegendItem li : legendItems) {
            int height = LegendUtil.paintLegendItem(g2, li, xPosition, yPosition, width - 2 * padding);
            yPosition += height;
            yPosition += padding;
            ++counter;
        }
    }

    private static int paintLegendItem(Graphics2D g2, LegendItem li, int xPosition, int yPosition, int width) {
        int lineHeight = 12;
        int padding = 5;
        Color c = ValueManager.decodeColor(li.getColor(), "#000000");
        g2.setStroke(new BasicStroke(2.0f));
        g2.setColor(c);
        int height = li.getTexts().size() * lineHeight + 2 * padding;
        g2.drawRect(xPosition, yPosition, width, height);
        int counter = 0;
        for (String text : li.getTexts()) {
            int textY = yPosition + lineHeight * (counter + 1) + 2;
            int textX = xPosition + padding;
            if (text != null) {
                g2.drawString(text, textX, textY);
            }
            ++counter;
        }
        return height;
    }
}

