/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.util.file;

import jakarta.servlet.ServletContext;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.eclnt.jsfserver.util.WebResourceClassloaderReader;
import org.eclnt.util.file.FileManager;
import org.eclnt.util.valuemgmt.ValueManager;

public class ConfigFileReader {
    private static String s_webApplicationName = "(undefined)";

    public static void initialize(ServletContext servletContext) {
        s_webApplicationName = servletContext.getContextPath();
        if (s_webApplicationName.startsWith("/")) {
            s_webApplicationName = s_webApplicationName.substring(1);
        }
    }

    public static String readConfigFile(String configFileName) {
        return ConfigFileReader.readConfigFile(configFileName, false);
    }

    public static String readConfigFile(String configFileName, boolean contentIsXML) {
        return ConfigFileReader.readConfigFile(configFileName, true, contentIsXML);
    }

    public static List<String> readConfigFiles(String configFileName, boolean withReadingExternalConfiguration, boolean contentIsXML) {
        String s;
        ArrayList<String> result = new ArrayList<String>();
        List<String> configTexts = WebResourceClassloaderReader.readUTF8FilesIntoStrings(configFileName, false);
        if (configTexts != null) {
            for (String configText : configTexts) {
                if (configText == null || configText.length() <= 0) continue;
                configText = ValueManager.replaceSystemProperties(configText, s_webApplicationName, contentIsXML);
                result.add(configText);
            }
        }
        if (withReadingExternalConfiguration && (s = ConfigFileReader.readExternalConfigFile(configFileName, contentIsXML)) != null) {
            result.add(s);
        }
        return result;
    }

    public static ResourceBundle readPropertiesFile(String configFileName) {
        try {
            String content = ConfigFileReader.readConfigFile(configFileName, false);
            if (content == null) {
                return null;
            }
            StringReader sr = new StringReader(content);
            PropertyResourceBundle prb = new PropertyResourceBundle(sr);
            sr.close();
            return prb;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static String readExternalConfigFile(String configFileName, boolean contentIsXML) {
        String result = ConfigFileReader.readFileFromExternalConfigDirectory(configFileName);
        result = ValueManager.replaceSystemProperties(result, s_webApplicationName, contentIsXML);
        return result;
    }

    private static String readFileFromFileSystem(String directory, String configFileName) {
        try {
            String fileName = directory + "/" + configFileName;
            fileName = ValueManager.encodeIntoValidFileName(fileName, false);
            return FileManager.readUTF8File(fileName, true);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static String readConfigFile(String configFileName, boolean withInternalFiles, boolean contentIsXML) {
        String result = ConfigFileReader.readFileFromExternalConfigDirectory(configFileName);
        if (withInternalFiles && result == null) {
            try {
                result = WebResourceClassloaderReader.readUTF8FileIntoString(configFileName, true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        result = ValueManager.replaceSystemProperties(result, s_webApplicationName, contentIsXML);
        return result;
    }

    private static String readFileFromExternalConfigDirectory(String configFileName) {
        String extConfigDirectory;
        String applicationName = null;
        try {
            applicationName = s_webApplicationName;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String result = null;
        if (result == null && applicationName != null) {
            extConfigDirectory = System.getenv("cc_configDirectory");
            if (extConfigDirectory == null) {
                extConfigDirectory = System.getenv("ccee_configDirectory");
            }
            if (extConfigDirectory != null) {
                result = ConfigFileReader.readFileFromFileSystem(extConfigDirectory + "/" + applicationName, configFileName);
            }
        }
        if (result == null) {
            extConfigDirectory = System.getenv("cc_configDirectory");
            if (extConfigDirectory == null) {
                extConfigDirectory = System.getenv("ccee_configDirectory");
            }
            if (extConfigDirectory != null) {
                result = ConfigFileReader.readFileFromFileSystem(extConfigDirectory, configFileName);
            }
        }
        return result;
    }
}

