/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.util.file;

import java.io.FileInputStream;
import org.eclnt.util.file.FileManager;
import org.eclnt.util.file.ZipUtil;

public class Unzip {
    public static void main(String[] args) {
        try {
            if (args.length != 2) {
                System.out.println("Wrong number of parameters:");
                System.out.println("1. parameter: Name of zip file");
                System.out.println("2. parameter: directory location where to unzip the content to");
                return;
            }
            System.out.println("Start unzipping");
            String fileName = args[0];
            FileInputStream fis = new FileInputStream(fileName);
            String dirName = args[1];
            FileManager.ensureDirectoryForFileExists(dirName + "/test.test");
            new ZipUtil().unZipIt(fis, dirName, new ZipUtil.IListener(){

                @Override
                public void updateStatusProblem(String s) {
                    System.out.println(s);
                }

                @Override
                public void updateDetail(String s, double progress) {
                    System.out.println(s);
                }
            });
            fis.close();
            System.out.println("Finished unzipping");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

