/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.util.log;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclnt.jsfserver.util.InitEclntJsfServer;
import org.eclnt.util.file.FileManager;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.ValueManager;

public class CLogInfo {
    public static String getLogDirectory() {
        return ValueManager.encodeIntoValidFileName(InitEclntJsfServer.getLogDirectory(), true);
    }

    public static String getLogFileBaseName() {
        return CLogInfo.getLogDirectory() + "log_eclntjsfserver.txt";
    }

    public static File getCurrentLogFile() {
        List<File> files = FileManager.getFilesOfDirectory(CLogInfo.getLogDirectory());
        File result = null;
        long highestStamp = -1L;
        for (File file : files) {
            if (file.getName().endsWith(".lck") || !file.getName().startsWith("log_eclntjsfserver.txt") || highestStamp >= file.lastModified()) continue;
            result = file;
            highestStamp = result.lastModified();
        }
        return result;
    }

    public static List<File> getLogFiles() {
        List<File> files = FileManager.getFilesOfDirectory(CLogInfo.getLogDirectory());
        ArrayList<File> result = new ArrayList<File>();
        long highestStamp = -1L;
        for (File file : files) {
            if (file.getName().endsWith(".lck") || !file.getName().startsWith("log_")) continue;
            result.add(file);
        }
        Collections.sort(files, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                long l1 = o1.lastModified();
                long l2 = o2.lastModified();
                long diff = l1 - l2;
                int result = 0;
                if (l1 < 0L) {
                    result = -1;
                }
                if (l1 > 0L) {
                    result = 1;
                }
                return result * -1;
            }
        });
        return result;
    }

    public static List<String> getContentEndOfCurrentLogFile(int numberOfBytes) {
        byte[] bytes;
        ArrayList<String> result = new ArrayList<String>();
        File currentLogFile = CLogInfo.getCurrentLogFile();
        if (currentLogFile != null && (bytes = FileManager.readLastBytesOfFile(currentLogFile, numberOfBytes, false)).length > 0) {
            int lineFeedIndex = -1;
            for (int i = 0; i < bytes.length; ++i) {
                if (bytes[i] != 10) continue;
                if (lineFeedIndex > 0) {
                    try {
                        String s = new String(bytes, lineFeedIndex + 1, i - (lineFeedIndex + 1), "UTF-8");
                        result.add(s);
                    }
                    catch (UnsupportedEncodingException exc) {
                        CLog.L.log(CLog.LL_ERR, "Should never happen...", exc);
                    }
                    catch (Throwable t) {
                        CLog.L.log(CLog.LL_ERR, "Should never happen...", t);
                    }
                }
                lineFeedIndex = i;
            }
        }
        return result;
    }
}

