/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.util.logdt;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import org.eclnt.util.file.FileManager;
import org.eclnt.util.log.CLog;
import org.eclnt.util.logdt.DTLogLine;
import org.eclnt.util.logdt.ENUMLogCategory;
import org.eclnt.util.logdt.IDTLogConstants;
import org.eclnt.util.valuemgmt.ValueManager;

public class DTLogUtil
implements IDTLogConstants {
    static Calendar s_calendar = Calendar.getInstance();

    public static String convertToDateStringMessage(Date date) {
        String ds = DTLogUtil.createDateFormat().format(date);
        return ds;
    }

    public static Date convertFromDateStringMessage(String s) {
        if (s == null) {
            return null;
        }
        try {
            return DTLogUtil.createDateFormat().parse(s);
        }
        catch (Throwable t) {
            throw new Error("Could not parse date: " + s);
        }
    }

    public static String convertToDateStringFile(Date date) {
        String ds = DTLogUtil.createDateFormatFile().format(date);
        return ds;
    }

    public static long readLastUpdateTime(String dirName) {
        String fileName = dirName + "/" + "log_devlog" + "." + "txt";
        File file = new File(fileName = ValueManager.encodeIntoValidFileName(fileName, false));
        if (file.exists()) {
            return file.lastModified();
        }
        List<File> fs = DTLogUtil.readDTLogFiles(dirName, 3, 180000L);
        if (fs.size() == 0) {
            return 0L;
        }
        return fs.get(0).lastModified();
    }

    public static List<DTLogLine> sortLogLinesByTimeAndRequest(List<DTLogLine> lines) {
        ArrayList<DTLogLine> result = new ArrayList<DTLogLine>(lines.size());
        int insertIndex = 0;
        String lastRequestId = "inittinini";
        for (int i = lines.size() - 1; i >= 0; --i) {
            DTLogLine line = lines.get(i);
            if (!lastRequestId.equals(line.getRequestId())) {
                insertIndex = result.size();
                lastRequestId = line.getRequestId();
            }
            result.add(insertIndex, line);
        }
        return result;
    }

    public static List<DTLogLine> readLogLines(String dirName) {
        ArrayList<DTLogLine> result = new ArrayList<DTLogLine>();
        List<String> stringLines = DTLogUtil.readLogStringLines(dirName);
        for (String line : stringLines) {
            String[] cols = ValueManager.decodeCSVOneLine(line);
            if (cols == null || cols.length <= 1 || !"1".equals(cols[0])) continue;
            DTLogLine ll = new DTLogLine();
            ll.setStamp(cols[1]);
            ll.setRequestId(cols[2]);
            ll.setCategory(ENUMLogCategory.fromAbrreviation(cols[3]));
            ll.setExpression(cols[4]);
            ll.setDetail(cols[5]);
            ll.setStackTrace(cols[6]);
            result.add(ll);
        }
        return result;
    }

    private static List<String> readLogStringLines(String dirName) {
        ArrayList<String> result = new ArrayList<String>();
        String s = DTLogUtil.readLog(dirName);
        StringTokenizer t = new StringTokenizer(s, "\n");
        while (t.hasMoreTokens()) {
            result.add(t.nextToken());
        }
        return result;
    }

    private static String readLog(String dirName) {
        List<File> fs = DTLogUtil.readDTLogFiles(dirName, 3, 180000L);
        StringBuffer sb = new StringBuffer();
        for (File f : fs) {
            String content = FileManager.readUTF8File(f.getAbsolutePath(), true);
            sb.append(content);
        }
        return sb.toString();
    }

    private static List<File> readDTLogFiles(String dirName, int numberOfFiles, long maxAge) {
        CLog.L.log(CLog.LL_INF, "Reading log files of directory: " + dirName);
        ArrayList<File> result = new ArrayList<File>();
        List<File> fs = FileManager.getFilesOfDirectory(dirName);
        long now = System.currentTimeMillis();
        for (File f : fs) {
            if (!f.getName().startsWith("log_devlog.") || !f.getName().endsWith(".txt") || now - maxAge > f.lastModified()) continue;
            result.add(f);
        }
        Collections.sort(result, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                long l1 = o1.lastModified();
                long l2 = o2.lastModified();
                return (int)(l1 - l2);
            }
        });
        int maxi = result.size() - numberOfFiles;
        for (int i = 0; i < maxi; ++i) {
            result.remove(0);
        }
        CLog.L.log(CLog.LL_INF, "Number of log files that are used: " + result.size());
        for (File resultFile : result) {
            CLog.L.log(CLog.LL_INF, "Log file that is used: " + resultFile.getAbsolutePath());
        }
        return result;
    }

    private static SimpleDateFormat createDateFormat() {
        SimpleDateFormat result = new SimpleDateFormat("yyyyMMdd:HHmmss:SSS");
        result.setCalendar(s_calendar);
        return result;
    }

    private static SimpleDateFormat createDateFormatFile() {
        return new SimpleDateFormat("yyyyMMdd_HHmmss_SSS");
    }
}

